/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.jet.lang.resolve.calls.inference.TypeConstraints;
import org.jetbrains.jet.lang.resolve.calls.inference.TypeConstraintsImpl;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitution;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.TypeCheckingProcedure;
import org.jetbrains.jet.lang.types.checker.TypingConstraints;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class ConstraintSystemImpl
implements ConstraintSystem {
    private final Map<TypeParameterDescriptor, TypeConstraintsImpl> typeParameterConstraints = Maps.newLinkedHashMap();
    private final Set<ConstraintPosition> errorConstraintPositions = Sets.newHashSet();
    private final TypeSubstitutor resultingSubstitutor;
    private final TypeSubstitutor currentSubstitutor;
    private boolean hasErrorInConstrainingTypes;
    @Nullable
    private ConstraintSystem systemWithoutExpectedTypeConstraint;
    private final ConstraintSystemStatus constraintSystemStatus = new ConstraintSystemStatus(){

        @Override
        public boolean isSuccessful() {
            return !this.hasContradiction() && !this.hasUnknownParameters();
        }

        @Override
        public boolean hasContradiction() {
            return this.hasTypeConstructorMismatch() || this.hasConflictingConstraints();
        }

        @Override
        public boolean hasConflictingConstraints() {
            for (TypeParameterDescriptor typeParameter : ConstraintSystemImpl.this.typeParameterConstraints.keySet()) {
                TypeConstraints typeConstraints = ConstraintSystemImpl.this.getTypeConstraints(typeParameter);
                if (typeConstraints.getValues().size() <= 1) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasUnknownParameters() {
            for (TypeConstraintsImpl constraints : ConstraintSystemImpl.this.typeParameterConstraints.values()) {
                if (!constraints.isEmpty()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasTypeConstructorMismatch() {
            return !ConstraintSystemImpl.this.errorConstraintPositions.isEmpty();
        }

        @Override
        public boolean hasTypeConstructorMismatchAt(@NotNull ConstraintPosition constraintPosition) {
            if (constraintPosition == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$1", "hasTypeConstructorMismatchAt"));
            }
            return ConstraintSystemImpl.this.errorConstraintPositions.contains(constraintPosition);
        }

        @Override
        public boolean hasOnlyExpectedTypeMismatch() {
            if (ConstraintSystemImpl.this.systemWithoutExpectedTypeConstraint == null) {
                return false;
            }
            if (!this.isSuccessful() && ConstraintSystemImpl.this.systemWithoutExpectedTypeConstraint.getStatus().isSuccessful()) {
                return true;
            }
            return ConstraintSystemImpl.this.errorConstraintPositions.size() == 1 && ConstraintSystemImpl.this.errorConstraintPositions.contains(ConstraintPosition.EXPECTED_TYPE_POSITION);
        }

        @Override
        public boolean hasErrorInConstrainingTypes() {
            return ConstraintSystemImpl.this.hasErrorInConstrainingTypes;
        }
    };

    public ConstraintSystemImpl() {
        this.resultingSubstitutor = this.createTypeSubstitutorWithDefaultForUnknownTypeParameter(new TypeProjection(TypeUtils.CANT_INFER_TYPE_PARAMETER));
        this.currentSubstitutor = this.createTypeSubstitutorWithDefaultForUnknownTypeParameter(new TypeProjection(TypeUtils.DONT_CARE));
    }

    private TypeSubstitutor createTypeSubstitutorWithDefaultForUnknownTypeParameter(final @Nullable TypeProjection defaultTypeProjection) {
        return TypeSubstitutor.create(new TypeSubstitution(){

            @Override
            public TypeProjection get(TypeConstructor key) {
                ClassifierDescriptor declarationDescriptor = key.getDeclarationDescriptor();
                if (declarationDescriptor instanceof TypeParameterDescriptor) {
                    TypeParameterDescriptor descriptor = (TypeParameterDescriptor)declarationDescriptor;
                    if (ConstraintSystemImpl.this.typeParameterConstraints.containsKey(descriptor)) {
                        JetType value = ConstraintSystemImpl.this.getTypeConstraints(descriptor).getValue();
                        if (value != null && !TypeUtils.equalsOrContainsAsArgument(value, TypeUtils.DONT_CARE)) {
                            return new TypeProjection(value);
                        }
                        return defaultTypeProjection;
                    }
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            public String toString() {
                return ConstraintSystemImpl.this.typeParameterConstraints.toString();
            }
        });
    }

    @Override
    @NotNull
    public ConstraintSystemStatus getStatus() {
        ConstraintSystemStatus constraintSystemStatus = this.constraintSystemStatus;
        if (constraintSystemStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "getStatus"));
        }
        return constraintSystemStatus;
    }

    @Override
    public void registerTypeVariable(@NotNull TypeParameterDescriptor typeVariable, @NotNull Variance positionVariance) {
        if (typeVariable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "registerTypeVariable"));
        }
        if (positionVariance == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "registerTypeVariable"));
        }
        this.typeParameterConstraints.put(typeVariable, new TypeConstraintsImpl(positionVariance));
    }

    @Override
    @NotNull
    public ConstraintSystem copy() {
        ConstraintSystem constraintSystem = this.replaceTypeVariables(Functions.<TypeParameterDescriptor>identity(), true);
        if (constraintSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "copy"));
        }
        return constraintSystem;
    }

    @NotNull
    public ConstraintSystem replaceTypeVariables(@NotNull Function<TypeParameterDescriptor, TypeParameterDescriptor> typeVariablesMap) {
        if (typeVariablesMap == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "replaceTypeVariables"));
        }
        ConstraintSystem constraintSystem = this.replaceTypeVariables(typeVariablesMap, false);
        if (constraintSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "replaceTypeVariables"));
        }
        return constraintSystem;
    }

    @NotNull
    private ConstraintSystem replaceTypeVariables(@NotNull Function<TypeParameterDescriptor, TypeParameterDescriptor> typeVariablesMap, boolean recreateTypeConstraints) {
        if (typeVariablesMap == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "replaceTypeVariables"));
        }
        ConstraintSystemImpl newConstraintSystem = new ConstraintSystemImpl();
        for (Map.Entry<TypeParameterDescriptor, TypeConstraintsImpl> entry : this.typeParameterConstraints.entrySet()) {
            TypeParameterDescriptor typeParameter = entry.getKey();
            TypeConstraintsImpl typeConstraints = entry.getValue();
            TypeParameterDescriptor newTypeParameter = typeVariablesMap.apply(typeParameter);
            assert (newTypeParameter != null);
            newConstraintSystem.typeParameterConstraints.put(newTypeParameter, recreateTypeConstraints ? typeConstraints.copy() : typeConstraints);
        }
        newConstraintSystem.errorConstraintPositions.addAll(this.errorConstraintPositions);
        newConstraintSystem.hasErrorInConstrainingTypes = this.hasErrorInConstrainingTypes;
        ConstraintSystemImpl constraintSystemImpl = newConstraintSystem;
        if (constraintSystemImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "replaceTypeVariables"));
        }
        return constraintSystemImpl;
    }

    @Override
    public void addSupertypeConstraint(@Nullable JetType constrainingType, @NotNull JetType subjectType, @NotNull ConstraintPosition constraintPosition) {
        if (subjectType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "addSupertypeConstraint"));
        }
        if (constraintPosition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "addSupertypeConstraint"));
        }
        if (constrainingType != null && TypeUtils.noExpectedType(constrainingType)) {
            return;
        }
        if (constraintPosition == ConstraintPosition.EXPECTED_TYPE_POSITION) {
            this.systemWithoutExpectedTypeConstraint = this.copy();
        }
        this.addConstraint(ConstraintKind.SUB_TYPE, subjectType, constrainingType, constraintPosition);
    }

    @Override
    public void addSubtypeConstraint(@Nullable JetType constrainingType, @NotNull JetType subjectType, @NotNull ConstraintPosition constraintPosition) {
        if (subjectType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "addSubtypeConstraint"));
        }
        if (constraintPosition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "addSubtypeConstraint"));
        }
        this.addConstraint(ConstraintKind.SUB_TYPE, constrainingType, subjectType, constraintPosition);
    }

    private void addConstraint(@NotNull ConstraintKind constraintKind, @Nullable JetType subType, @Nullable JetType superType, final @NotNull ConstraintPosition constraintPosition) {
        if (constraintKind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "addConstraint"));
        }
        if (constraintPosition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "addConstraint"));
        }
        TypeCheckingProcedure typeCheckingProcedure = new TypeCheckingProcedure(new TypingConstraints(){

            @Override
            public boolean assertEqualTypes(@NotNull JetType a, @NotNull JetType b, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
                if (a == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$3", "assertEqualTypes"));
                }
                if (b == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$3", "assertEqualTypes"));
                }
                if (typeCheckingProcedure == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$3", "assertEqualTypes"));
                }
                ConstraintSystemImpl.this.doAddConstraint(ConstraintKind.EQUAL, a, b, constraintPosition, typeCheckingProcedure);
                return true;
            }

            @Override
            public boolean assertEqualTypeConstructors(@NotNull TypeConstructor a, @NotNull TypeConstructor b) {
                if (a == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$3", "assertEqualTypeConstructors"));
                }
                if (b == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$3", "assertEqualTypeConstructors"));
                }
                throw new IllegalStateException("'assertEqualTypeConstructors' shouldn't be invoked inside 'isSubtypeOf'");
            }

            @Override
            public boolean assertSubtype(@NotNull JetType subtype, @NotNull JetType supertype, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
                if (subtype == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$3", "assertSubtype"));
                }
                if (supertype == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$3", "assertSubtype"));
                }
                if (typeCheckingProcedure == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$3", "assertSubtype"));
                }
                ConstraintSystemImpl.this.doAddConstraint(ConstraintKind.SUB_TYPE, subtype, supertype, constraintPosition, typeCheckingProcedure);
                return true;
            }

            @Override
            public boolean noCorrespondingSupertype(@NotNull JetType subtype, @NotNull JetType supertype) {
                if (subtype == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$3", "noCorrespondingSupertype"));
                }
                if (supertype == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$3", "noCorrespondingSupertype"));
                }
                ConstraintSystemImpl.this.errorConstraintPositions.add(constraintPosition);
                return true;
            }
        });
        this.doAddConstraint(constraintKind, subType, superType, constraintPosition, typeCheckingProcedure);
    }

    private boolean isErrorOrSpecialType(@Nullable JetType type) {
        if (type == TypeUtils.DONT_CARE || type == TypeUtils.CANT_INFER_TYPE_PARAMETER) {
            return true;
        }
        if (type == null || type.isError() && type != TypeUtils.PLACEHOLDER_FUNCTION_TYPE) {
            this.hasErrorInConstrainingTypes = true;
            return true;
        }
        return false;
    }

    private void doAddConstraint(@NotNull ConstraintKind constraintKind, @Nullable JetType subType, @Nullable JetType superType, @NotNull ConstraintPosition constraintPosition, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
        if (constraintKind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "doAddConstraint"));
        }
        if (constraintPosition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "doAddConstraint"));
        }
        if (typeCheckingProcedure == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "doAddConstraint"));
        }
        if (this.isErrorOrSpecialType(subType) || this.isErrorOrSpecialType(superType)) {
            return;
        }
        assert (subType != null && superType != null);
        assert (superType != TypeUtils.PLACEHOLDER_FUNCTION_TYPE) : "The type for " + constraintPosition + " shouldn't be a placeholder for function type";
        KotlinBuiltIns kotlinBuiltIns = KotlinBuiltIns.getInstance();
        if (subType == TypeUtils.PLACEHOLDER_FUNCTION_TYPE) {
            if (!kotlinBuiltIns.isFunctionOrExtensionFunctionType(superType)) {
                if (this.isMyTypeVariable(superType)) {
                    return;
                }
                this.errorConstraintPositions.add(constraintPosition);
            }
            return;
        }
        if (constraintKind == ConstraintKind.SUB_TYPE && kotlinBuiltIns.isFunctionType(subType) && kotlinBuiltIns.isExtensionFunctionType(superType)) {
            subType = ConstraintSystemImpl.createCorrespondingExtensionFunctionType(subType, TypeUtils.DONT_CARE);
        }
        if (((Object)subType).equals(superType)) {
            return;
        }
        assert (!this.isMyTypeVariable(subType) || !this.isMyTypeVariable(superType)) : "The constraint shouldn't contain different type variables on both sides: " + subType + " <: " + superType;
        if (this.isMyTypeVariable(subType)) {
            this.generateTypeParameterConstraint(subType, superType, constraintKind == ConstraintKind.SUB_TYPE ? TypeConstraintsImpl.BoundKind.UPPER_BOUND : TypeConstraintsImpl.BoundKind.EXACT_BOUND);
            return;
        }
        if (this.isMyTypeVariable(superType)) {
            this.generateTypeParameterConstraint(superType, subType, constraintKind == ConstraintKind.SUB_TYPE ? TypeConstraintsImpl.BoundKind.LOWER_BOUND : TypeConstraintsImpl.BoundKind.EXACT_BOUND);
            return;
        }
        typeCheckingProcedure.isSubtypeOf(TypeUtils.makeNotNullable(subType), TypeUtils.makeNotNullable(superType));
    }

    private void generateTypeParameterConstraint(@NotNull JetType parameterType, @NotNull JetType constrainingType, @NotNull TypeConstraintsImpl.BoundKind boundKind) {
        if (parameterType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "generateTypeParameterConstraint"));
        }
        if (constrainingType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "generateTypeParameterConstraint"));
        }
        if (boundKind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "generateTypeParameterConstraint"));
        }
        TypeConstraintsImpl typeConstraints = this.getTypeConstraints(parameterType);
        assert (typeConstraints != null) : "constraint should be generated only for type variables";
        if (parameterType.isNullable()) {
            constrainingType = TypeUtils.makeNotNullable(constrainingType);
        }
        typeConstraints.addBound(boundKind, constrainingType);
    }

    public void processDeclaredBoundConstraints() {
        for (Map.Entry<TypeParameterDescriptor, TypeConstraintsImpl> entry : this.typeParameterConstraints.entrySet()) {
            TypeParameterDescriptor typeParameterDescriptor = entry.getKey();
            TypeConstraintsImpl typeConstraints = entry.getValue();
            for (JetType declaredUpperBound : typeParameterDescriptor.getUpperBounds()) {
                for (JetType lowerOrExactBound : Sets.union(typeConstraints.getLowerBounds(), typeConstraints.getExactBounds())) {
                    this.addSubtypeConstraint(lowerOrExactBound, declaredUpperBound, ConstraintPosition.BOUND_CONSTRAINT_POSITION);
                }
            }
        }
    }

    @Override
    @NotNull
    public Set<TypeParameterDescriptor> getTypeVariables() {
        Set<TypeParameterDescriptor> set = this.typeParameterConstraints.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "getTypeVariables"));
        }
        return set;
    }

    @Override
    @NotNull
    public TypeConstraints getTypeConstraints(@NotNull TypeParameterDescriptor typeVariable) {
        if (typeVariable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "getTypeConstraints"));
        }
        TypeConstraintsImpl typeConstraints = this.typeParameterConstraints.get(typeVariable);
        assert (typeConstraints != null) : "TypeParameterDescriptor is not a type variable for constraint system: " + typeVariable;
        TypeConstraintsImpl typeConstraintsImpl = typeConstraints;
        if (typeConstraintsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "getTypeConstraints"));
        }
        return typeConstraintsImpl;
    }

    @Nullable
    private TypeConstraintsImpl getTypeConstraints(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "getTypeConstraints"));
        }
        ClassifierDescriptor parameterDescriptor = type.getConstructor().getDeclarationDescriptor();
        if (parameterDescriptor instanceof TypeParameterDescriptor) {
            return this.typeParameterConstraints.get(parameterDescriptor);
        }
        return null;
    }

    private boolean isMyTypeVariable(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "isMyTypeVariable"));
        }
        ClassifierDescriptor descriptor = type.getConstructor().getDeclarationDescriptor();
        return descriptor instanceof TypeParameterDescriptor && this.typeParameterConstraints.get(descriptor) != null;
    }

    @Override
    @NotNull
    public TypeSubstitutor getResultingSubstitutor() {
        if (this.getStatus().hasOnlyExpectedTypeMismatch()) {
            assert (this.systemWithoutExpectedTypeConstraint != null);
            TypeSubstitutor typeSubstitutor = this.systemWithoutExpectedTypeConstraint.getResultingSubstitutor();
            if (typeSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "getResultingSubstitutor"));
            }
            return typeSubstitutor;
        }
        TypeSubstitutor typeSubstitutor = this.resultingSubstitutor;
        if (typeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "getResultingSubstitutor"));
        }
        return typeSubstitutor;
    }

    @Override
    @NotNull
    public TypeSubstitutor getCurrentSubstitutor() {
        TypeSubstitutor typeSubstitutor = this.currentSubstitutor;
        if (typeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "getCurrentSubstitutor"));
        }
        return typeSubstitutor;
    }

    @NotNull
    public static JetType createCorrespondingExtensionFunctionType(@NotNull JetType functionType, @NotNull JetType receiverType) {
        if (functionType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "createCorrespondingExtensionFunctionType"));
        }
        if (receiverType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "createCorrespondingExtensionFunctionType"));
        }
        assert (KotlinBuiltIns.getInstance().isFunctionType(functionType));
        List<TypeProjection> typeArguments = functionType.getArguments();
        assert (!typeArguments.isEmpty());
        ArrayList<JetType> arguments = Lists.newArrayList();
        int index = 0;
        int lastIndex = typeArguments.size() - 1;
        for (TypeProjection typeArgument : typeArguments) {
            if (index < lastIndex) {
                arguments.add(typeArgument.getType());
            }
            ++index;
        }
        JetType returnType = typeArguments.get(lastIndex).getType();
        JetType jetType = KotlinBuiltIns.getInstance().getFunctionType(functionType.getAnnotations(), receiverType, arguments, returnType);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "createCorrespondingExtensionFunctionType"));
        }
        return jetType;
    }

    public static enum ConstraintKind {
        SUB_TYPE,
        EQUAL;

    }
}

