/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.autocasts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastReceiver;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValue;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValueFactory;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.jet.lang.types.JetType;

public class AutoCastUtils {
    private AutoCastUtils() {
    }

    @NotNull
    public static List<ReceiverValue> getAutoCastVariants(@NotNull BindingContext bindingContext, @NotNull DataFlowInfo dataFlowInfo, @NotNull ReceiverValue receiverToCast) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariants"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariants"));
        }
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariants"));
        }
        if (receiverToCast instanceof ThisReceiver) {
            ThisReceiver receiver = (ThisReceiver)receiverToCast;
            assert (receiver.exists());
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiver);
            List<ReceiverValue> list = AutoCastUtils.collectAutoCastReceiverValues(dataFlowInfo, receiver, dataFlowValue);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariants"));
            }
            return list;
        }
        if (receiverToCast instanceof ExpressionReceiver) {
            ExpressionReceiver receiver = (ExpressionReceiver)receiverToCast;
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiver.getExpression(), receiver.getType(), bindingContext);
            List<ReceiverValue> list = AutoCastUtils.collectAutoCastReceiverValues(dataFlowInfo, receiver, dataFlowValue);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariants"));
            }
            return list;
        }
        if (receiverToCast instanceof AutoCastReceiver) {
            List<ReceiverValue> list = AutoCastUtils.getAutoCastVariants(bindingContext, dataFlowInfo, ((AutoCastReceiver)receiverToCast).getOriginal());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariants"));
            }
            return list;
        }
        List<ReceiverValue> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariants"));
        }
        return list;
    }

    @NotNull
    private static List<ReceiverValue> collectAutoCastReceiverValues(@NotNull DataFlowInfo dataFlowInfo, @NotNull ReceiverValue receiver, @NotNull DataFlowValue dataFlowValue) {
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "collectAutoCastReceiverValues"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "collectAutoCastReceiverValues"));
        }
        if (dataFlowValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "collectAutoCastReceiverValues"));
        }
        Set<JetType> possibleTypes = dataFlowInfo.getPossibleTypes(dataFlowValue);
        ArrayList<ReceiverValue> result = new ArrayList<ReceiverValue>(possibleTypes.size());
        for (JetType possibleType : possibleTypes) {
            result.add(new AutoCastReceiver(receiver, possibleType, dataFlowValue.isStableIdentifier()));
        }
        ArrayList<ReceiverValue> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "collectAutoCastReceiverValues"));
        }
        return arrayList;
    }

    public static void recordAutoCastIfNecessary(ReceiverValue receiver, @NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "recordAutoCastIfNecessary"));
        }
        if (receiver instanceof AutoCastReceiver) {
            AutoCastReceiver autoCastReceiver = (AutoCastReceiver)receiver;
            ReceiverValue original = autoCastReceiver.getOriginal();
            if (original instanceof ExpressionReceiver) {
                ExpressionReceiver expressionReceiver = (ExpressionReceiver)original;
                if (autoCastReceiver.canCast()) {
                    trace.record(BindingContext.AUTOCAST, expressionReceiver.getExpression(), autoCastReceiver.getType());
                    trace.record(BindingContext.EXPRESSION_TYPE, expressionReceiver.getExpression(), autoCastReceiver.getType());
                } else {
                    trace.report(Errors.AUTOCAST_IMPOSSIBLE.on(expressionReceiver.getExpression(), autoCastReceiver.getType(), expressionReceiver.getExpression().getText()));
                }
            } else assert (autoCastReceiver.canCast()) : "A non-expression receiver must always be autocastabe: " + original;
        }
    }
}

