/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.base.Predicate;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;

public class TopDownAnalysisParameters {
    @NotNull
    private final Predicate<PsiFile> analyzeCompletely;
    private final boolean analyzingBootstrapLibrary;
    private final boolean declaredLocally;
    @NotNull
    private final List<AnalyzerScriptParameter> scriptParameters;

    public TopDownAnalysisParameters(@NotNull Predicate<PsiFile> analyzeCompletely, boolean analyzingBootstrapLibrary, boolean declaredLocally, @NotNull List<AnalyzerScriptParameter> scriptParameters) {
        if (analyzeCompletely == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/TopDownAnalysisParameters", "<init>"));
        }
        if (scriptParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/TopDownAnalysisParameters", "<init>"));
        }
        this.analyzeCompletely = analyzeCompletely;
        this.analyzingBootstrapLibrary = analyzingBootstrapLibrary;
        this.declaredLocally = declaredLocally;
        this.scriptParameters = scriptParameters;
    }

    @NotNull
    public Predicate<PsiFile> getAnalyzeCompletely() {
        Predicate<PsiFile> predicate = this.analyzeCompletely;
        if (predicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TopDownAnalysisParameters", "getAnalyzeCompletely"));
        }
        return predicate;
    }

    public boolean isAnalyzingBootstrapLibrary() {
        return this.analyzingBootstrapLibrary;
    }

    public boolean isDeclaredLocally() {
        return this.declaredLocally;
    }

    @NotNull
    public List<AnalyzerScriptParameter> getScriptParameters() {
        List<AnalyzerScriptParameter> list = this.scriptParameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TopDownAnalysisParameters", "getScriptParameters"));
        }
        return list;
    }
}

