/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetMultiDeclarationEntry;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;

public final class JetModifiableBlockHelper {
    private JetModifiableBlockHelper() {
    }

    public static boolean shouldChangeModificationCount(PsiElement place) {
        JetDeclaration declaration = PsiTreeUtil.getParentOfType(place, JetDeclaration.class, true);
        if (declaration != null) {
            if (declaration instanceof JetNamedFunction) {
                JetNamedFunction function = (JetNamedFunction)declaration;
                if (function.hasDeclaredReturnType() || function.hasBlockBody()) {
                    return JetModifiableBlockHelper.takePartInDeclarationTypeInference(function);
                }
                return JetModifiableBlockHelper.shouldChangeModificationCount(function);
            }
            if (declaration instanceof JetPropertyAccessor) {
                return JetModifiableBlockHelper.takePartInDeclarationTypeInference(declaration);
            }
            if (declaration instanceof JetProperty) {
                JetProperty property = (JetProperty)declaration;
                if (property.getTypeRef() != null) {
                    return JetModifiableBlockHelper.takePartInDeclarationTypeInference(property);
                }
                return JetModifiableBlockHelper.shouldChangeModificationCount(property);
            }
            if (declaration instanceof JetMultiDeclaration || declaration instanceof JetMultiDeclarationEntry) {
                return JetModifiableBlockHelper.shouldChangeModificationCount(declaration);
            }
            if (declaration instanceof JetFunctionLiteral) {
                return JetModifiableBlockHelper.shouldChangeModificationCount(declaration);
            }
        }
        return true;
    }

    private static boolean takePartInDeclarationTypeInference(PsiElement place) {
        JetDeclaration declaration = PsiTreeUtil.getParentOfType(place, JetDeclaration.class, true);
        if (declaration != null) {
            JetProperty property;
            JetNamedFunction function;
            if (declaration instanceof JetNamedFunction ? !(function = (JetNamedFunction)declaration).hasDeclaredReturnType() && !function.hasBlockBody() : declaration instanceof JetProperty && (property = (JetProperty)declaration).getTypeRef() == null) {
                return true;
            }
            return JetModifiableBlockHelper.takePartInDeclarationTypeInference(declaration);
        }
        return false;
    }
}

