/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import gnu.trove.TObjectHashingStrategy;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.descriptors.serialization.Interner;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class NameTable {
    public static final TObjectHashingStrategy<ProtoBuf.QualifiedNameTable.QualifiedName.Builder> QUALIFIED_NAME_BUILDER_HASHING = new TObjectHashingStrategy<ProtoBuf.QualifiedNameTable.QualifiedName.Builder>(){

        @Override
        public int computeHashCode(ProtoBuf.QualifiedNameTable.QualifiedName.Builder object) {
            int result = 13;
            result = 31 * result + object.getParentQualifiedName();
            result = 31 * result + object.getShortName();
            result = 31 * result + object.getKind().hashCode();
            return result;
        }

        @Override
        public boolean equals(ProtoBuf.QualifiedNameTable.QualifiedName.Builder o1, ProtoBuf.QualifiedNameTable.QualifiedName.Builder o2) {
            return o1.getParentQualifiedName() == o2.getParentQualifiedName() && o1.getShortName() == o2.getShortName() && o1.getKind() == o2.getKind();
        }
    };
    private final Interner<String> simpleNames = new Interner();
    private final Interner<ProtoBuf.QualifiedNameTable.QualifiedName.Builder> qualifiedNames = new Interner<ProtoBuf.QualifiedNameTable.QualifiedName.Builder>(QUALIFIED_NAME_BUILDER_HASHING);

    @NotNull
    public List<String> getSimpleNames() {
        List<String> list = this.simpleNames.getAllInternedObjects();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameTable", "getSimpleNames"));
        }
        return list;
    }

    @NotNull
    public List<ProtoBuf.QualifiedNameTable.QualifiedName.Builder> getFqNames() {
        List<ProtoBuf.QualifiedNameTable.QualifiedName.Builder> list = this.qualifiedNames.getAllInternedObjects();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameTable", "getFqNames"));
        }
        return list;
    }

    public int getSimpleNameIndex(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/NameTable", "getSimpleNameIndex"));
        }
        return this.simpleNames.intern(name.asString());
    }

    public int getFqNameIndex(@NotNull ClassOrNamespaceDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/NameTable", "getFqNameIndex"));
        }
        ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder = ProtoBuf.QualifiedNameTable.QualifiedName.newBuilder();
        if (descriptor instanceof ClassDescriptor) {
            builder.setKind(ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS);
        }
        builder.setShortName(this.getSimpleNameIndex(descriptor.getName()));
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration instanceof NamespaceDescriptor) {
            NamespaceDescriptor namespaceDescriptor = (NamespaceDescriptor)containingDeclaration;
            if (!DescriptorUtils.isRootNamespace(namespaceDescriptor)) {
                builder.setParentQualifiedName(this.getFqNameIndex(namespaceDescriptor));
            }
        } else if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor outerClass = (ClassDescriptor)containingDeclaration;
            builder.setParentQualifiedName(this.getFqNameIndex(outerClass));
        } else {
            throw new IllegalStateException("FQ names are only stored for top-level or inner classes: " + descriptor);
        }
        return this.qualifiedNames.intern(builder);
    }

    public int getFqNameIndex(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/NameTable", "getFqNameIndex"));
        }
        int result = -1;
        for (Name segment : fqName.pathSegments()) {
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder = ProtoBuf.QualifiedNameTable.QualifiedName.newBuilder();
            builder.setShortName(this.getSimpleNameIndex(segment));
            if (result != -1) {
                builder.setParentQualifiedName(result);
            }
            result = this.qualifiedNames.intern(builder);
        }
        return result;
    }
}

