/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.FieldVisitor;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.jet.codegen.AnnotationCodegen;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.FunctionGenerationStrategy;
import org.jetbrains.jet.codegen.ImplementationBodyCodegen;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.context.FieldOwnerContext;
import org.jetbrains.jet.codegen.context.MethodContext;
import org.jetbrains.jet.codegen.context.NamespaceFacadeContext;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.GenerationStateAware;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorFactory;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JvmAbi;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class PropertyCodegen
extends GenerationStateAware {
    @NotNull
    private final FunctionCodegen functionCodegen;
    @NotNull
    private final ClassBuilder v;
    @NotNull
    private final FieldOwnerContext context;
    @Nullable
    private MemberCodegen classBodyCodegen;
    @NotNull
    private final OwnerKind kind;

    public PropertyCodegen(@NotNull FieldOwnerContext context, @NotNull ClassBuilder v, @NotNull FunctionCodegen functionCodegen, @Nullable MemberCodegen classBodyCodegen) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/PropertyCodegen", "<init>"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/PropertyCodegen", "<init>"));
        }
        if (functionCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/codegen/PropertyCodegen", "<init>"));
        }
        super(functionCodegen.getState());
        this.v = v;
        this.functionCodegen = functionCodegen;
        this.context = context;
        this.classBodyCodegen = classBodyCodegen;
        this.kind = context.getContextKind();
    }

    public void gen(JetProperty p) {
        VariableDescriptor variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, p);
        assert (variableDescriptor instanceof PropertyDescriptor) : "Property should have a property descriptor: " + variableDescriptor;
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variableDescriptor;
        assert (this.kind == OwnerKind.NAMESPACE || this.kind == OwnerKind.IMPLEMENTATION || this.kind == OwnerKind.TRAIT_IMPL) : "Generating property with a wrong kind (" + (Object)((Object)this.kind) + "): " + propertyDescriptor;
        if (this.context instanceof NamespaceFacadeContext) {
            Type ownerType = ((NamespaceFacadeContext)this.context).getDelegateToClassType();
            this.v.getMemberMap().recordSrcClassNameForCallable(propertyDescriptor, AsmUtil.shortNameByAsmType(ownerType));
        } else if (this.kind != OwnerKind.TRAIT_IMPL) {
            this.generateBackingField(p, propertyDescriptor);
        }
        this.generateGetter(p, propertyDescriptor, p.getGetter());
        this.generateSetter(p, propertyDescriptor, p.getSetter());
        this.context.recordSyntheticAccessorIfNeeded(propertyDescriptor, this.typeMapper);
    }

    public void generatePrimaryConstructorProperty(JetParameter p, PropertyDescriptor descriptor) {
        this.generateBackingField(p, descriptor);
        this.generateGetter(p, descriptor, null);
        if (descriptor.isVar()) {
            this.generateSetter(p, descriptor, null);
        }
    }

    public void generateConstructorPropertyAsMethodForAnnotationClass(JetParameter p, PropertyDescriptor descriptor) {
        Type type = this.state.getTypeMapper().mapType(descriptor);
        String name = p.getName();
        assert (name != null) : "Annotation parameter has no name: " + p.getText();
        MethodVisitor visitor = this.v.newMethod(p, 1025, name, "()" + type.getDescriptor(), null, null);
        JetExpression defaultValue = p.getDefaultValue();
        if (defaultValue != null) {
            CompileTimeConstant<?> constant = this.state.getBindingContext().get(BindingContext.COMPILE_TIME_VALUE, defaultValue);
            assert (constant != null) : "Default value for annotation parameter should be compile time value: " + defaultValue.getText();
            AnnotationCodegen annotationCodegen = AnnotationCodegen.forAnnotationDefaultValue(visitor, this.typeMapper);
            annotationCodegen.generateAnnotationDefaultValue(constant);
        }
    }

    private void generateBackingField(JetNamedDeclaration p, PropertyDescriptor propertyDescriptor) {
        boolean isDelegated;
        boolean hasBackingField = Boolean.TRUE.equals(this.bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor));
        boolean bl = isDelegated = p instanceof JetProperty && ((JetProperty)p).getDelegateExpression() != null;
        if (hasBackingField || isDelegated) {
            DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
            if (CodegenUtil.isInterface(containingDeclaration)) {
                return;
            }
            FieldVisitor fieldVisitor = hasBackingField ? this.generateBackingFieldAccess(p, propertyDescriptor) : this.generatePropertyDelegateAccess((JetProperty)p, propertyDescriptor);
            AnnotationCodegen.forField(fieldVisitor, this.typeMapper).genAnnotations(propertyDescriptor);
        } else if (!propertyDescriptor.getAnnotations().isEmpty()) {
            String methodName = JvmAbi.getSyntheticMethodNameForAnnotatedProperty(propertyDescriptor.getName());
            MethodVisitor mv = this.v.newMethod(null, 135194, methodName, "()V", null, null);
            this.v.getMemberMap().recordSyntheticMethodNameOfProperty(propertyDescriptor, methodName);
            AnnotationCodegen.forMethod(mv, this.typeMapper).genAnnotations(propertyDescriptor);
            mv.visitCode();
            mv.visitInsn(177);
            mv.visitEnd();
        }
    }

    private FieldVisitor generateBackingField(JetNamedDeclaration element, PropertyDescriptor propertyDescriptor, boolean isDelegate, JetType jetType, Object defaultValue) {
        int modifiers = AsmUtil.getDeprecatedAccessFlag(propertyDescriptor);
        if (KotlinBuiltIns.getInstance().isVolatile(propertyDescriptor)) {
            modifiers |= 0x40;
        }
        if (this.kind == OwnerKind.NAMESPACE) {
            modifiers |= 8;
        }
        if (!propertyDescriptor.isVar() || isDelegate) {
            modifiers |= 0x10;
        }
        Type type = this.typeMapper.mapType(jetType);
        ClassBuilder builder = this.v;
        FieldOwnerContext backingFieldContext = this.context;
        if (AsmUtil.isPropertyWithBackingFieldInOuterClass(propertyDescriptor)) {
            modifiers |= 8 | AsmUtil.getVisibilityForSpecialPropertyBackingField(propertyDescriptor, isDelegate);
            ImplementationBodyCodegen codegen = CodegenUtil.getParentBodyCodegen(this.classBodyCodegen);
            builder = codegen.v;
            backingFieldContext = codegen.context;
            this.v.getMemberMap().recordStaticFieldInOuterClass(propertyDescriptor);
        } else if (this.kind != OwnerKind.NAMESPACE || isDelegate) {
            modifiers |= 2;
        }
        if (AsmUtil.isPropertyWithBackingFieldCopyInOuterClass(propertyDescriptor)) {
            ImplementationBodyCodegen parentBodyCodegen = CodegenUtil.getParentBodyCodegen(this.classBodyCodegen);
            parentBodyCodegen.addClassObjectPropertyToCopy(propertyDescriptor, defaultValue);
        }
        String name = backingFieldContext.getFieldName(propertyDescriptor, isDelegate);
        this.v.getMemberMap().recordFieldOfProperty(propertyDescriptor, type, name);
        return builder.newField(element, modifiers, name, type.getDescriptor(), this.typeMapper.mapFieldSignature(jetType), defaultValue);
    }

    private FieldVisitor generatePropertyDelegateAccess(JetProperty p, PropertyDescriptor propertyDescriptor) {
        JetType delegateType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, p.getDelegateExpression());
        if (delegateType == null) {
            delegateType = ErrorUtils.createErrorType("Delegate type");
        }
        return this.generateBackingField(p, propertyDescriptor, true, delegateType, null);
    }

    private FieldVisitor generateBackingFieldAccess(JetNamedDeclaration p, PropertyDescriptor propertyDescriptor) {
        Object value = null;
        if (ImplementationBodyCodegen.shouldWriteFieldInitializer(propertyDescriptor, this.typeMapper)) {
            JetExpression initializer;
            JetExpression jetExpression = initializer = p instanceof JetProperty ? ((JetProperty)p).getInitializer() : null;
            if (initializer != null) {
                CompileTimeConstant<?> compileTimeValue = this.bindingContext.get(BindingContext.COMPILE_TIME_VALUE, initializer);
                value = compileTimeValue != null ? compileTimeValue.getValue() : null;
            }
        }
        return this.generateBackingField(p, propertyDescriptor, false, propertyDescriptor.getType(), value);
    }

    private void generateGetter(JetNamedDeclaration p, PropertyDescriptor propertyDescriptor, JetPropertyAccessor getter) {
        boolean defaultGetter = getter == null || getter.getBodyExpression() == null;
        JvmMethodSignature signature = this.typeMapper.mapGetterSignature(propertyDescriptor, this.kind);
        PropertyGetterDescriptor getterDescriptor = propertyDescriptor.getGetter();
        PropertyGetterDescriptor propertyGetterDescriptor = getterDescriptor = getterDescriptor != null ? getterDescriptor : DescriptorFactory.createDefaultGetter(propertyDescriptor);
        if (this.kind != OwnerKind.TRAIT_IMPL || !defaultGetter) {
            FunctionGenerationStrategy.CodegenBased strategy = defaultGetter ? (p instanceof JetProperty && ((JetProperty)p).getDelegateExpression() != null ? new DefaultPropertyWithDelegateAccessorStrategy(this.state, getterDescriptor) : new DefaultPropertyAccessorStrategy(this.state, getterDescriptor)) : new FunctionGenerationStrategy.FunctionDefault(this.state, getterDescriptor, getter);
            this.functionCodegen.generateMethod(getter != null ? getter : p, signature, getterDescriptor, strategy);
        }
    }

    private void generateSetter(JetNamedDeclaration p, PropertyDescriptor propertyDescriptor, JetPropertyAccessor setter) {
        boolean defaultSetter;
        boolean bl = defaultSetter = setter == null || setter.getBodyExpression() == null;
        if (propertyDescriptor.isVar()) {
            JvmMethodSignature signature = this.typeMapper.mapSetterSignature(propertyDescriptor, this.kind);
            PropertySetterDescriptor setterDescriptor = propertyDescriptor.getSetter();
            PropertySetterDescriptor propertySetterDescriptor = setterDescriptor = setterDescriptor != null ? setterDescriptor : DescriptorFactory.createDefaultSetter(propertyDescriptor);
            if (this.kind != OwnerKind.TRAIT_IMPL || !defaultSetter) {
                FunctionGenerationStrategy.CodegenBased strategy = defaultSetter ? (p instanceof JetProperty && ((JetProperty)p).getDelegateExpression() != null ? new DefaultPropertyWithDelegateAccessorStrategy(this.state, setterDescriptor) : new DefaultPropertyAccessorStrategy(this.state, setterDescriptor)) : new FunctionGenerationStrategy.FunctionDefault(this.state, setterDescriptor, setter);
                this.functionCodegen.generateMethod(setter != null ? setter : p, signature, setterDescriptor, strategy);
            }
        }
    }

    private static void generateDefaultAccessor(@NotNull PropertyAccessorDescriptor accessorDescriptor, @NotNull InstructionAdapter iv, @NotNull ExpressionCodegen codegen) {
        if (accessorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/PropertyCodegen", "generateDefaultAccessor"));
        }
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/PropertyCodegen", "generateDefaultAccessor"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/codegen/PropertyCodegen", "generateDefaultAccessor"));
        }
        JetTypeMapper typeMapper = codegen.typeMapper;
        MethodContext context = codegen.context;
        OwnerKind kind = context.getContextKind();
        PropertyDescriptor propertyDescriptor = accessorDescriptor.getCorrespondingProperty();
        Type type = typeMapper.mapType(propertyDescriptor);
        int paramCode = 0;
        if (kind != OwnerKind.NAMESPACE) {
            iv.load(0, AsmTypeConstants.OBJECT_TYPE);
            paramCode = 1;
        }
        StackValue property = codegen.intermediateValueForProperty(accessorDescriptor.getCorrespondingProperty(), true, null);
        if (accessorDescriptor instanceof PropertyGetterDescriptor) {
            property.put(type, iv);
            iv.areturn(type);
        } else if (accessorDescriptor instanceof PropertySetterDescriptor) {
            ReceiverParameterDescriptor receiverParameter = propertyDescriptor.getReceiverParameter();
            if (receiverParameter != null) {
                paramCode += typeMapper.mapType(receiverParameter.getType()).getSize();
            }
            iv.load(paramCode, type);
            property.store(type, iv);
            iv.visitInsn(177);
        } else assert (false) : "Unreachable state";
    }

    public static String getterName(Name propertyName) {
        return "get" + StringUtil.capitalizeWithJavaBeanConvention(propertyName.asString());
    }

    public static String setterName(Name propertyName) {
        return "set" + StringUtil.capitalizeWithJavaBeanConvention(propertyName.asString());
    }

    public void genDelegate(PropertyDescriptor delegate, PropertyDescriptor overridden, StackValue field) {
        ClassDescriptor toClass = (ClassDescriptor)overridden.getContainingDeclaration();
        this.functionCodegen.genDelegate(delegate.getGetter(), toClass, field, this.typeMapper.mapGetterSignature(delegate, OwnerKind.IMPLEMENTATION), this.typeMapper.mapGetterSignature(overridden.getOriginal(), OwnerKind.IMPLEMENTATION));
        if (delegate.isVar()) {
            this.functionCodegen.genDelegate(delegate.getSetter(), toClass, field, this.typeMapper.mapSetterSignature(delegate, OwnerKind.IMPLEMENTATION), this.typeMapper.mapSetterSignature(overridden.getOriginal(), OwnerKind.IMPLEMENTATION));
        }
    }

    private static class DefaultPropertyWithDelegateAccessorStrategy
    extends FunctionGenerationStrategy.CodegenBased<PropertyAccessorDescriptor> {
        public DefaultPropertyWithDelegateAccessorStrategy(@NotNull GenerationState state, @NotNull PropertyAccessorDescriptor descriptor) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/PropertyCodegen$DefaultPropertyWithDelegateAccessorStrategy", "<init>"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/PropertyCodegen$DefaultPropertyWithDelegateAccessorStrategy", "<init>"));
            }
            super(state, descriptor);
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
            if (codegen == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/PropertyCodegen$DefaultPropertyWithDelegateAccessorStrategy", "doGenerateBody"));
            }
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/PropertyCodegen$DefaultPropertyWithDelegateAccessorStrategy", "doGenerateBody"));
            }
            JetTypeMapper typeMapper = codegen.typeMapper;
            OwnerKind kind = codegen.context.getContextKind();
            InstructionAdapter iv = codegen.v;
            BindingContext bindingContext = this.state.getBindingContext();
            ResolvedCall<FunctionDescriptor> resolvedCall = bindingContext.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, this.callableDescriptor);
            Call call = bindingContext.get(BindingContext.DELEGATED_PROPERTY_CALL, this.callableDescriptor);
            assert (call != null) : "Call should be recorded for delegate call " + signature.toString();
            PropertyDescriptor property = ((PropertyAccessorDescriptor)this.callableDescriptor).getCorrespondingProperty();
            Type asmType = typeMapper.mapType(property);
            if (kind != OwnerKind.NAMESPACE) {
                iv.load(0, AsmTypeConstants.OBJECT_TYPE);
            }
            StackValue delegatedProperty = codegen.intermediateValueForProperty(property, true, null);
            StackValue lastValue = codegen.invokeFunction(call, delegatedProperty, resolvedCall);
            if (lastValue.type != Type.VOID_TYPE) {
                lastValue.put(asmType, iv);
                iv.areturn(asmType);
            } else {
                iv.areturn(Type.VOID_TYPE);
            }
        }
    }

    private static class DefaultPropertyAccessorStrategy
    extends FunctionGenerationStrategy.CodegenBased<PropertyAccessorDescriptor> {
        public DefaultPropertyAccessorStrategy(@NotNull GenerationState state, @NotNull PropertyAccessorDescriptor callableDescriptor) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy", "<init>"));
            }
            if (callableDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy", "<init>"));
            }
            super(state, callableDescriptor);
        }

        @Override
        public void doGenerateBody(ExpressionCodegen codegen, JvmMethodSignature signature) {
            PropertyCodegen.generateDefaultAccessor((PropertyAccessorDescriptor)this.callableDescriptor, codegen.v, codegen);
        }
    }
}

