/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.util.Pair;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.codegen.MemberMap;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBuf;
import org.jetbrains.jet.descriptors.serialization.NameTable;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.SerializerExtension;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class JavaSerializerExtension
extends SerializerExtension {
    private final MemberMap memberMap;

    public JavaSerializerExtension(@NotNull MemberMap memberMap) {
        if (memberMap == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/JavaSerializerExtension", "<init>"));
        }
        this.memberMap = memberMap;
    }

    @Override
    public void serializeCallable(@NotNull CallableMemberDescriptor callable, @NotNull ProtoBuf.Callable.Builder proto, @NotNull NameTable nameTable) {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/JavaSerializerExtension", "serializeCallable"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/JavaSerializerExtension", "serializeCallable"));
        }
        if (nameTable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/codegen/JavaSerializerExtension", "serializeCallable"));
        }
        this.saveSignature(callable, proto, nameTable);
        this.saveSrcClassName(callable, proto, nameTable);
    }

    private void saveSignature(@NotNull CallableMemberDescriptor callable, @NotNull ProtoBuf.Callable.Builder proto, @NotNull NameTable nameTable) {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/JavaSerializerExtension", "saveSignature"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/JavaSerializerExtension", "saveSignature"));
        }
        if (nameTable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/codegen/JavaSerializerExtension", "saveSignature"));
        }
        if (callable instanceof FunctionDescriptor) {
            Method method = this.memberMap.getMethodOfDescriptor((FunctionDescriptor)callable);
            if (method != null) {
                proto.setExtension(JavaProtoBuf.methodSignature, new SignatureSerializer(nameTable).methodSignature(method));
            }
        } else if (callable instanceof PropertyDescriptor) {
            String syntheticMethodName;
            boolean isStaticInOuter;
            String fieldName;
            Type fieldType;
            PropertyDescriptor property = (PropertyDescriptor)callable;
            PropertyGetterDescriptor getter = property.getGetter();
            PropertySetterDescriptor setter = property.getSetter();
            Method getterMethod = getter == null ? null : this.memberMap.getMethodOfDescriptor(getter);
            Method setterMethod = setter == null ? null : this.memberMap.getMethodOfDescriptor(setter);
            Pair<Type, String> field = this.memberMap.getFieldOfProperty(property);
            if (field != null) {
                fieldType = (Type)field.first;
                fieldName = (String)field.second;
                isStaticInOuter = this.memberMap.isStaticFieldInOuterClass(property);
                syntheticMethodName = null;
            } else {
                fieldType = null;
                fieldName = null;
                isStaticInOuter = false;
                syntheticMethodName = this.memberMap.getSyntheticMethodNameOfProperty(property);
            }
            JavaProtoBuf.JavaPropertySignature signature = new SignatureSerializer(nameTable).propertySignature(fieldType, fieldName, isStaticInOuter, syntheticMethodName, getterMethod, setterMethod);
            proto.setExtension(JavaProtoBuf.propertySignature, signature);
        }
    }

    private void saveSrcClassName(@NotNull CallableMemberDescriptor callable, @NotNull ProtoBuf.Callable.Builder proto, @NotNull NameTable nameTable) {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/JavaSerializerExtension", "saveSrcClassName"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/JavaSerializerExtension", "saveSrcClassName"));
        }
        if (nameTable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/codegen/JavaSerializerExtension", "saveSrcClassName"));
        }
        String name = this.memberMap.getSrcClassNameOfCallable(callable);
        if (name != null) {
            proto.setExtension(JavaProtoBuf.srcClassName, nameTable.getSimpleNameIndex(Name.identifier(name)));
        }
    }

    private static class SignatureSerializer {
        private final NameTable nameTable;

        public SignatureSerializer(@NotNull NameTable nameTable) {
            if (nameTable == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "<init>"));
            }
            this.nameTable = nameTable;
        }

        @NotNull
        public JavaProtoBuf.JavaMethodSignature methodSignature(@NotNull Method method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "methodSignature"));
            }
            JavaProtoBuf.JavaMethodSignature.Builder signature = JavaProtoBuf.JavaMethodSignature.newBuilder();
            signature.setName(this.nameTable.getSimpleNameIndex(Name.guess(method.getName())));
            signature.setReturnType(this.type(method.getReturnType()));
            for (Type type : method.getArgumentTypes()) {
                signature.addParameterType(this.type(type));
            }
            JavaProtoBuf.JavaMethodSignature javaMethodSignature = signature.build();
            if (javaMethodSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "methodSignature"));
            }
            return javaMethodSignature;
        }

        @NotNull
        public JavaProtoBuf.JavaPropertySignature propertySignature(@Nullable Type fieldType, @Nullable String fieldName, boolean isStaticInOuter, @Nullable String syntheticMethodName, @Nullable Method getter, @Nullable Method setter) {
            JavaProtoBuf.JavaPropertySignature.Builder signature = JavaProtoBuf.JavaPropertySignature.newBuilder();
            if (fieldType != null) {
                assert (fieldName != null) : "Field name shouldn't be null when there's a field type: " + fieldType;
                signature.setField(this.fieldSignature(fieldType, fieldName, isStaticInOuter));
            }
            if (syntheticMethodName != null) {
                signature.setSyntheticMethodName(this.nameTable.getSimpleNameIndex(Name.guess(syntheticMethodName)));
            }
            if (getter != null) {
                signature.setGetter(this.methodSignature(getter));
            }
            if (setter != null) {
                signature.setSetter(this.methodSignature(setter));
            }
            JavaProtoBuf.JavaPropertySignature javaPropertySignature = signature.build();
            if (javaPropertySignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "propertySignature"));
            }
            return javaPropertySignature;
        }

        @NotNull
        public JavaProtoBuf.JavaFieldSignature fieldSignature(@NotNull Type type, @NotNull String name, boolean isStaticInOuter) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "fieldSignature"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "fieldSignature"));
            }
            JavaProtoBuf.JavaFieldSignature.Builder signature = JavaProtoBuf.JavaFieldSignature.newBuilder();
            signature.setName(this.nameTable.getSimpleNameIndex(Name.guess(name)));
            signature.setType(this.type(type));
            if (isStaticInOuter) {
                signature.setIsStaticInOuter(true);
            }
            JavaProtoBuf.JavaFieldSignature javaFieldSignature = signature.build();
            if (javaFieldSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "fieldSignature"));
            }
            return javaFieldSignature;
        }

        @NotNull
        public JavaProtoBuf.JavaType type(@NotNull Type givenType) {
            if (givenType == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "type"));
            }
            JavaProtoBuf.JavaType.Builder builder = JavaProtoBuf.JavaType.newBuilder();
            int arrayDimension = 0;
            Type type = givenType;
            while (type.getSort() == 9) {
                ++arrayDimension;
                type = type.getElementType();
            }
            if (arrayDimension != 0) {
                builder.setArrayDimension(arrayDimension);
            }
            if (type.getSort() == 10) {
                FqName fqName = SignatureSerializer.internalNameToFqName(type.getInternalName());
                builder.setClassFqName(this.nameTable.getFqNameIndex(fqName));
            } else {
                builder.setPrimitiveType(JavaProtoBuf.JavaType.PrimitiveType.valueOf(type.getSort()));
            }
            JavaProtoBuf.JavaType javaType = builder.build();
            if (javaType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "type"));
            }
            return javaType;
        }

        @NotNull
        private static FqName internalNameToFqName(@NotNull String internalName) {
            if (internalName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "internalNameToFqName"));
            }
            FqName fqName = FqName.fromSegments(Arrays.asList(internalName.split("/")));
            if (fqName == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "internalNameToFqName"));
            }
            return fqName;
        }
    }
}

