/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common.messages;

import com.google.common.base.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.MessageCollector;

public class FilteringMessageCollector
implements MessageCollector {
    private final MessageCollector messageCollector;
    private final Predicate<CompilerMessageSeverity> decline;

    public FilteringMessageCollector(@NotNull MessageCollector messageCollector, @NotNull Predicate<CompilerMessageSeverity> decline) {
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/common/messages/FilteringMessageCollector", "<init>"));
        }
        if (decline == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/cli/common/messages/FilteringMessageCollector", "<init>"));
        }
        this.messageCollector = messageCollector;
        this.decline = decline;
    }

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/common/messages/FilteringMessageCollector", "report"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/cli/common/messages/FilteringMessageCollector", "report"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/cli/common/messages/FilteringMessageCollector", "report"));
        }
        if (!this.decline.apply(severity)) {
            this.messageCollector.report(severity, message, location);
        }
    }
}

