/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class WeakReferenceArray<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.containers.WeakReferenceArray");
    private final ReferenceQueue<T> myQueue = new TReferenceQueue();
    private MyWeakReference[] myReferences;
    private int mySize = 0;
    private int myCorpseCounter = 0;

    public WeakReferenceArray() {
        this(5);
    }

    public WeakReferenceArray(int size) {
        this.myReferences = new MyWeakReference[size];
    }

    public T remove(int index) {
        this.checkRange(index);
        T result = this.getImpl(index);
        this.removeReference(index);
        return result;
    }

    private void checkRange(int index) {
        if (index >= this.mySize) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
    }

    public int getCorpseCount() {
        this.flushQueue();
        return this.myCorpseCounter;
    }

    private void flushQueue() {
        Reference<T> nextRef;
        while ((nextRef = this.myQueue.poll()) != null) {
            if (!(nextRef instanceof MyWeakReference)) continue;
            MyWeakReference reference = (MyWeakReference)nextRef;
            reference.setNull(this.myReferences);
            ++this.myCorpseCounter;
        }
    }

    public void add(T object) {
        this.ensureCapacity(this.mySize + 1);
        MyWeakReference.createAt(this.myReferences, this.mySize, object, this.myQueue);
        ++this.mySize;
    }

    public void add(int index, T element) {
        this.ensureCapacity(this.mySize + 1);
        if (index < 0 || index > this.mySize) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        for (int i = this.mySize - 1; i >= index; --i) {
            MyWeakReference aliveReference = MyWeakReference.getFrom(this.myReferences, i);
            if (aliveReference == null) continue;
            aliveReference.putTo(this.myReferences, i + 1);
        }
        MyWeakReference.createAt(this.myReferences, index, element, this.myQueue);
        ++this.mySize;
    }

    private void ensureCapacity(int size) {
        if (size != 0 && this.myReferences.length < 5) {
            this.growTo(Math.max(5, size));
            return;
        }
        if (size <= this.myReferences.length) {
            return;
        }
        if (size - this.myReferences.length <= this.getCorpseCount()) {
            this.compress(-1);
            if (this.mySize < this.myReferences.length - 1) {
                return;
            }
        }
        int newCapacity = 2 * this.myReferences.length;
        this.growTo(newCapacity);
    }

    private void growTo(int newCapacity) {
        MyWeakReference[] references = new MyWeakReference[newCapacity];
        System.arraycopy(this.myReferences, 0, references, 0, this.myReferences.length);
        this.myReferences = references;
    }

    public int size() {
        return this.mySize;
    }

    public int compress(int trackIndex) {
        if (this.getCorpseCount() == 0) {
            return trackIndex;
        }
        return this.doCompress(this.myReferences, trackIndex);
    }

    private int doCompress(MyWeakReference[] references, int trackIndex) {
        this.myCorpseCounter = 0;
        int validIndex = 0;
        int newIndex = -1;
        boolean trackingDone = false;
        int i = this.nextValid(-1);
        while (i < this.size()) {
            if (!trackingDone) {
                if (i == trackIndex) {
                    newIndex = validIndex;
                    trackingDone = true;
                }
                if (i > trackIndex) {
                    newIndex = -validIndex - 1;
                    trackingDone = true;
                }
            }
            MyWeakReference aliveReference = MyWeakReference.getFrom(this.myReferences, i);
            if (validIndex < i) {
                this.performRemoveAt(validIndex);
            } else {
                LOG.assertTrue(validIndex == i);
            }
            aliveReference.moveTo(this.myReferences, references, validIndex);
            ++validIndex;
            i = this.nextValid(i);
        }
        if (newIndex == -1) {
            newIndex = -validIndex - 1;
        }
        for (i = validIndex; i < this.mySize; ++i) {
            this.performRemoveAt(i);
        }
        for (i = validIndex; i < this.myReferences.length; ++i) {
            LOG.assertTrue(this.myReferences[i] == null);
        }
        this.flushQueue();
        this.mySize = validIndex;
        return newIndex;
    }

    private void performRemoveAt(int index) {
        if (this.removeReference(index)) {
            --this.myCorpseCounter;
            this.flushQueue();
            if (this.myCorpseCounter < 0) {
                LOG.error(String.valueOf(this.myCorpseCounter));
            }
        }
    }

    int nextValid(int index) {
        ++index;
        while (index < this.size()) {
            if (this.getImpl(index) != null) {
                return index;
            }
            ++index;
        }
        return this.size();
    }

    private T getImpl(int index) {
        MyWeakReference reference = MyWeakReference.getFrom(this.myReferences, index);
        return reference == null ? null : (T)reference.get();
    }

    public int getCapacity() {
        return this.myReferences.length;
    }

    public T get(int index) {
        this.checkRange(index);
        return this.getImpl(index);
    }

    public int reduceCapacity(int trackIndex) {
        int aliveSize = this.getNotBuriedCount();
        if (this.myReferences.length / 4 >= aliveSize) {
            MyWeakReference[] references = new MyWeakReference[aliveSize * 2];
            int newIndex = this.doCompress(references, trackIndex);
            this.myReferences = references;
            return newIndex;
        }
        return trackIndex;
    }

    private int getNotBuriedCount() {
        this.flushQueue();
        int counter = 0;
        for (MyWeakReference myReference : this.myReferences) {
            if (myReference == null) continue;
            ++counter;
        }
        return counter;
    }

    public int getAliveCount() {
        return this.size() - this.getCorpseCount();
    }

    boolean removeReference(int index) {
        MyWeakReference reference = MyWeakReference.getFrom(this.myReferences, index);
        return reference != null && reference.removeFrom(this.myReferences);
    }

    private static class TReferenceQueue<T>
    extends ReferenceQueue<T> {
        private TReferenceQueue() {
        }

        @Override
        public Reference<? extends T> poll() {
            Reference reference = super.poll();
            return reference;
        }
    }

    private static class MyWeakReference<E>
    extends WeakReference<E> {
        private int myIndex = -1;

        private MyWeakReference(E e, ReferenceQueue<E> referenceQueue) {
            super(e, referenceQueue);
        }

        public static <E> void createAt(MyWeakReference[] array, int index, E element, ReferenceQueue<E> queue) {
            super.putTo(array, index);
        }

        public static <E> MyWeakReference<E> getFrom(MyWeakReference[] array, int index) {
            MyWeakReference reference = array[index];
            if (reference == null) {
                return null;
            }
            LOG.assertTrue(index == reference.myIndex);
            return reference;
        }

        private void putTo(MyWeakReference[] array, int index) {
            array[index] = this;
            this.myIndex = index;
        }

        public boolean removeFrom(MyWeakReference[] array) {
            LOG.assertTrue(array[this.myIndex] == this);
            this.clear();
            array[this.myIndex] = null;
            this.myIndex = -1;
            return this.enqueue();
        }

        public void moveTo(MyWeakReference[] fromArray, MyWeakReference[] toArray, int newIndex) {
            LOG.assertTrue(fromArray[this.myIndex] == this);
            fromArray[this.myIndex] = null;
            LOG.assertTrue(toArray[newIndex] == null);
            toArray[newIndex] = this;
            this.myIndex = newIndex;
        }

        public void setNull(MyWeakReference[] array) {
            LOG.assertTrue(this.get() == null);
            if (this.myIndex == -1) {
                return;
            }
            LOG.assertTrue(array[this.myIndex] == this);
            array[this.myIndex] = null;
        }
    }
}

