/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceIncorporationPhase;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariablesOrder;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.CheckedExceptionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceSession {
    private static final Logger LOG = Logger.getInstance("#" + InferenceSession.class.getName());
    private Map<PsiTypeParameter, InferenceVariable> myInferenceVariables = new LinkedHashMap<PsiTypeParameter, InferenceVariable>();
    private final List<ConstraintFormula> myConstraints = new ArrayList<ConstraintFormula>();
    private PsiSubstitutor mySiteSubstitutor;
    private PsiManager myManager;
    private int myConstraintIdx = 0;
    private final InferenceIncorporationPhase myIncorporationPhase = new InferenceIncorporationPhase(this);

    public InferenceSession(PsiSubstitutor siteSubstitutor) {
        this.mySiteSubstitutor = siteSubstitutor;
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiType[] leftTypes, PsiType[] rightTypes, PsiSubstitutor siteSubstitutor, PsiManager manager) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.initBounds(typeParams);
        LOG.assertTrue(leftTypes.length == rightTypes.length);
        for (int i = 0; i < leftTypes.length; ++i) {
            this.myConstraints.add(new TypeCompatibilityConstraint(leftTypes[i], this.mySiteSubstitutor.substitute(rightTypes[i])));
        }
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiParameter[] parameters, PsiExpression[] args, PsiSubstitutor siteSubstitutor, PsiElement parent, PsiManager manager) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.initBounds(typeParams);
        Pair<PsiMethod, PsiCallExpression> pair = InferenceSession.getPair(parent);
        if (parameters.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                PsiType parameterType = InferenceSession.getParameterType(parameters, args, i, this.mySiteSubstitutor);
                if (args[i] == null || pair != null && !InferenceSession.isPertinentToApplicability(args[i], (PsiMethod)pair.first, this.mySiteSubstitutor, parameterType, this)) continue;
                this.myConstraints.add(new ExpressionCompatibilityConstraint(args[i], parameterType));
            }
        }
        if (pair != null) {
            this.initReturnTypeConstraint((PsiMethod)pair.first, (PsiCallExpression)parent);
        }
    }

    private static Pair<PsiMethod, PsiCallExpression> getPair(PsiElement parent) {
        Pair<PsiMethod, PsiSubstitutor> pair;
        if (parent instanceof PsiCallExpression && (pair = MethodCandidateInfo.getCurrentMethod(((PsiCallExpression)parent).getArgumentList())) != null) {
            return Pair.create(pair.first, (PsiCallExpression)parent);
        }
        return null;
    }

    private static boolean areLambdaParameterTypesKnown(PsiSubstitutor siteSubstitutor, PsiType targetType, @NotNull InferenceSession session) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "areLambdaParameterTypesKnown"));
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(targetType);
        PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
        if (method != null) {
            PsiSubstitutor substitutor = LambdaUtil.getSubstitutor(method, resolveResult);
            for (PsiParameter parameter : method.getParameterList().getParameters()) {
                if (session.isProperType(siteSubstitutor.substitute(substitutor.substitute(parameter.getType())))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method) {
        return InferenceSession.isPertinentToApplicability(expr, method, PsiSubstitutor.EMPTY, null, null);
    }

    public static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method, PsiSubstitutor siteSubstitutor, @Nullable PsiType targetType, @Nullable InferenceSession session) {
        if (expr instanceof PsiLambdaExpression) {
            PsiElement gParent;
            PsiElement parent;
            if (!(((PsiLambdaExpression)expr).hasFormalParameterTypes() || session != null && InferenceSession.areLambdaParameterTypesKnown(siteSubstitutor, targetType, session))) {
                return false;
            }
            for (PsiExpression expression : LambdaUtil.getReturnExpressions((PsiLambdaExpression)expr)) {
                if (InferenceSession.isPertinentToApplicability(expression, method, siteSubstitutor, targetType, session)) continue;
                return false;
            }
            if (method.getTypeParameters().length > 0 && (parent = PsiUtil.skipParenthesizedExprUp(expr.getParent())) instanceof PsiExpressionList && (gParent = parent.getParent()) instanceof PsiCallExpression && ((PsiCallExpression)gParent).getTypeArgumentList().getTypeParameterElements().length == 0) {
                PsiType paramType;
                PsiParameter[] parameters;
                int idx = LambdaUtil.getLambdaIdx((PsiExpressionList)parent, expr);
                if (idx > (parameters = method.getParameterList().getParameters()).length - 1) {
                    PsiType lastParamType = parameters[parameters.length - 1].getType();
                    paramType = parameters[parameters.length - 1].isVarArgs() ? ((PsiEllipsisType)lastParamType).getComponentType() : lastParamType;
                } else {
                    paramType = parameters[idx].getType();
                }
                PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(paramType);
                if (psiClass instanceof PsiTypeParameter && ((PsiTypeParameter)psiClass).getOwner() == method) {
                    return false;
                }
            }
            return true;
        }
        if (expr instanceof PsiMethodReferenceExpression) {
            return ((PsiMethodReferenceExpression)expr).isExact();
        }
        if (expr instanceof PsiParenthesizedExpression) {
            return InferenceSession.isPertinentToApplicability(((PsiParenthesizedExpression)expr).getExpression(), method, siteSubstitutor, targetType, session);
        }
        if (expr instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
            if (!InferenceSession.isPertinentToApplicability(thenExpression, method, siteSubstitutor, targetType, session)) {
                return false;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
            if (!InferenceSession.isPertinentToApplicability(elseExpression, method, siteSubstitutor, targetType, session)) {
                return false;
            }
        }
        return true;
    }

    private static PsiType getParameterType(PsiParameter[] parameters, PsiExpression[] args, int i, PsiSubstitutor substitutor) {
        PsiType parameterType = substitutor.substitute(parameters[i < parameters.length ? i : parameters.length - 1].getType());
        if (parameterType instanceof PsiEllipsisType && (args.length != parameters.length || PsiPolyExpressionUtil.isPolyExpression(args[i]) || args[i] != null && !(args[i].getType() instanceof PsiArrayType))) {
            parameterType = ((PsiEllipsisType)parameterType).getComponentType();
        }
        return parameterType;
    }

    @NotNull
    public PsiSubstitutor infer() {
        PsiSubstitutor psiSubstitutor = this.infer(null, null, null);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor infer(@Nullable PsiParameter[] parameters, @Nullable PsiExpression[] args, @Nullable PsiElement parent) {
        this.repeatInferencePhases();
        if (parameters != null && args != null) {
            HashSet<ConstraintFormula> additionalConstraints = new HashSet<ConstraintFormula>();
            if (parameters.length > 0) {
                Pair<PsiMethod, PsiCallExpression> pair = InferenceSession.getPair(parent);
                for (int i = 0; i < args.length; ++i) {
                    PsiType parameterType = InferenceSession.getParameterType(parameters, args, i, this.mySiteSubstitutor);
                    if (args[i] == null) continue;
                    if (pair == null || !InferenceSession.isPertinentToApplicability(args[i], (PsiMethod)pair.first, this.mySiteSubstitutor, parameterType, this) || !this.isProperType(LambdaUtil.getFunctionalInterfaceReturnType(parameterType))) {
                        additionalConstraints.add(new ExpressionCompatibilityConstraint(args[i], parameterType));
                    }
                    additionalConstraints.add(new CheckedExceptionCompatibilityConstraint(args[i], parameterType));
                }
            }
            if (!additionalConstraints.isEmpty()) {
                for (InferenceVariable inferenceVariable : this.myInferenceVariables.values()) {
                    inferenceVariable.ignoreInstantiation();
                }
                this.proceedWithAdditionalConstraints(additionalConstraints);
            }
        }
        this.mySiteSubstitutor = this.resolveBounds(this.myInferenceVariables.values(), this.mySiteSubstitutor);
        for (InferenceVariable inferenceVariable : this.myInferenceVariables.values()) {
            if (inferenceVariable.isCaptured()) continue;
            PsiTypeParameter typeParameter = inferenceVariable.getParameter();
            PsiType instantiation = inferenceVariable.getInstantiation();
            if (instantiation != PsiType.NULL) continue;
            this.mySiteSubstitutor = this.mySiteSubstitutor.put(typeParameter, JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(typeParameter));
        }
        PsiSubstitutor psiSubstitutor = this.mySiteSubstitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    private void initBounds(PsiTypeParameter[] typeParameters) {
        for (PsiTypeParameter parameter : typeParameters) {
            this.myInferenceVariables.put(parameter, new InferenceVariable(parameter));
        }
        for (InferenceVariable variable : this.myInferenceVariables.values()) {
            PsiClassType[] extendsListTypes;
            PsiTypeParameter parameter = variable.getParameter();
            boolean added = false;
            for (PsiType classType : extendsListTypes = parameter.getExtendsListTypes()) {
                if (this.isProperType(classType = this.mySiteSubstitutor.substitute(classType))) {
                    added = true;
                }
                variable.addBound(classType, InferenceBound.UPPER);
            }
            if (added) continue;
            variable.addBound(PsiType.getJavaLangObject(parameter.getManager(), parameter.getResolveScope()), InferenceBound.UPPER);
        }
    }

    public void addCapturedVariable(PsiTypeParameter param) {
        if (this.myInferenceVariables.containsKey(param)) {
            return;
        }
        InferenceVariable variable = new InferenceVariable(param);
        variable.setCaptured(true);
        this.myInferenceVariables.put(param, variable);
    }

    private void initReturnTypeConstraint(PsiMethod method, PsiCallExpression context) {
        PsiType returnType;
        if ((PsiPolyExpressionUtil.isMethodCallPolyExpression(context, method) || context instanceof PsiNewExpression && PsiDiamondType.ourDiamondGuard.currentStack().contains(context)) && !PsiType.VOID.equals(returnType = method.getReturnType()) && returnType != null) {
            PsiType targetType = PsiTypesUtil.getExpectedTypeByParent(context);
            if (targetType == null) {
                PsiElement parent = PsiUtil.skipParenthesizedExprUp(context.getParent());
                if (parent instanceof PsiExpressionList) {
                    PsiExpressionList argumentList;
                    PsiElement gParent = parent.getParent();
                    if (gParent instanceof PsiCallExpression && (argumentList = ((PsiCallExpression)gParent).getArgumentList()) != null) {
                        PsiElement parentMethod;
                        Pair<PsiMethod, PsiSubstitutor> pair = MethodCandidateInfo.getCurrentMethod(argumentList);
                        JavaResolveResult resolveResult = pair == null ? ((PsiCallExpression)gParent).resolveMethodGenerics() : null;
                        PsiElement psiElement = parentMethod = pair != null ? (PsiElement)pair.first : resolveResult.getElement();
                        if (parentMethod instanceof PsiMethod) {
                            PsiParameter[] parameters = ((PsiMethod)parentMethod).getParameterList().getParameters();
                            PsiElement arg = context;
                            while (arg.getParent() instanceof PsiParenthesizedExpression) {
                                arg = parent.getParent();
                            }
                            PsiExpression[] args = argumentList.getExpressions();
                            targetType = InferenceSession.getParameterType(parameters, args, ArrayUtilRt.find(args, arg), pair != null ? (PsiSubstitutor)pair.second : resolveResult.getSubstitutor());
                        }
                    }
                } else if (parent instanceof PsiConditionalExpression) {
                    targetType = PsiTypesUtil.getExpectedTypeByParent((PsiExpression)parent);
                } else if (parent instanceof PsiLambdaExpression) {
                    targetType = LambdaUtil.getFunctionalInterfaceReturnType(((PsiLambdaExpression)parent).getFunctionalInterfaceType());
                }
            }
            if (targetType != null) {
                this.myConstraints.add(new TypeCompatibilityConstraint(GenericsUtil.eliminateWildcards(targetType, false), PsiImplUtil.normalizeWildcardTypeByPosition(returnType, context)));
            }
        }
    }

    public InferenceVariable getInferenceVariable(PsiType psiType) {
        return this.getInferenceVariable(psiType, true);
    }

    public InferenceVariable getInferenceVariable(PsiType psiType, boolean acceptCaptured) {
        InferenceVariable inferenceVariable;
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(psiType);
        if (psiClass instanceof PsiTypeParameter && (inferenceVariable = this.myInferenceVariables.get(psiClass)) != null && (acceptCaptured || !inferenceVariable.isCaptured())) {
            return inferenceVariable;
        }
        return null;
    }

    public boolean isProperType(@Nullable PsiType type) {
        return this.isProperType(type, true);
    }

    public boolean isProperType(@Nullable PsiType type, boolean acceptCaptured) {
        return this.collectDependencies(type, null, acceptCaptured);
    }

    public boolean collectDependencies(@Nullable PsiType type, final @Nullable Set<InferenceVariable> dependencies, final boolean acceptCaptured) {
        if (type == null) {
            return true;
        }
        Boolean isProper = type.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visitType(PsiType type) {
                return true;
            }

            @Override
            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return arrayType.getComponentType().accept(this);
            }

            @Override
            @Nullable
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound == null) {
                    return true;
                }
                return bound.accept(this);
            }

            @Override
            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                InferenceVariable inferenceVariable = InferenceSession.this.getInferenceVariable(classType, acceptCaptured);
                if (inferenceVariable != null) {
                    if (dependencies != null) {
                        dependencies.add(inferenceVariable);
                        return true;
                    }
                    return false;
                }
                for (PsiType psiType : classType.getParameters()) {
                    if (psiType.accept(this).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        });
        return dependencies != null ? !dependencies.isEmpty() : isProper;
    }

    private void repeatInferencePhases() {
        do {
            if (!this.reduceConstraints()) {
                return;
            }
            this.myIncorporationPhase.incorporate();
        } while (!this.myIncorporationPhase.isFullyIncorporated() || this.myConstraintIdx < this.myConstraints.size());
        this.mySiteSubstitutor = this.resolveBounds(this.myInferenceVariables.values(), this.mySiteSubstitutor);
    }

    private boolean reduceConstraints() {
        ArrayList<ConstraintFormula> newConstraints = new ArrayList<ConstraintFormula>();
        for (int i = this.myConstraintIdx; i < this.myConstraints.size(); ++i) {
            ConstraintFormula constraint = this.myConstraints.get(i);
            if (constraint.reduce(this, newConstraints)) continue;
            return false;
        }
        this.myConstraintIdx = this.myConstraints.size();
        for (ConstraintFormula constraint : newConstraints) {
            this.addConstraint(constraint);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PsiSubstitutor resolveBounds(Collection<InferenceVariable> inferenceVariables, PsiSubstitutor substitutor) {
        List<List<InferenceVariable>> independentVars = InferenceVariablesOrder.resolveOrder(inferenceVariables, this);
        for (List<InferenceVariable> variables : independentVars) {
            for (InferenceVariable inferenceVariable : variables) {
                if (inferenceVariable.isCaptured() || inferenceVariable.getInstantiation() != PsiType.NULL) continue;
                PsiTypeParameter typeParameter = inferenceVariable.getParameter();
                try {
                    List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
                    List<PsiType> lowerBounds = inferenceVariable.getBounds(InferenceBound.LOWER);
                    List<PsiType> upperBounds = inferenceVariable.getBounds(InferenceBound.UPPER);
                    if (upperBounds.contains(null)) {
                        inferenceVariable.setInstantiation(null);
                        continue;
                    }
                    PsiType bound = null;
                    for (PsiType eqBound : eqBounds) {
                        if (eqBound != null && (bound = this.acceptBoundsWithRecursiveDependencies(typeParameter, eqBound)) != null) break;
                    }
                    if (bound != null) {
                        if (bound instanceof PsiCapturedWildcardType && eqBounds.size() > 1) continue;
                        inferenceVariable.setInstantiation(bound);
                        continue;
                    }
                    PsiType lub = null;
                    for (PsiType lowerBound : lowerBounds) {
                        if (!this.isProperType(lowerBound = this.acceptBoundsWithRecursiveDependencies(typeParameter, lowerBound), false)) continue;
                        if (lub == null) {
                            lub = lowerBound;
                            continue;
                        }
                        lub = GenericsUtil.getLeastUpperBound(lub, lowerBound, this.myManager);
                    }
                    if (lub != null) {
                        inferenceVariable.setInstantiation(lub instanceof PsiCapturedWildcardType ? ((PsiCapturedWildcardType)lub).getWildcard() : lub);
                        continue;
                    }
                    PsiType glb = null;
                    for (PsiType upperBound : upperBounds) {
                        if (!this.isProperType(upperBound = this.acceptBoundsWithRecursiveDependencies(typeParameter, upperBound), false)) continue;
                        if (glb == null) {
                            glb = upperBound;
                            continue;
                        }
                        glb = GenericsUtil.getGreatestLowerBound(glb, upperBound);
                    }
                    if (glb == null) continue;
                    inferenceVariable.setInstantiation(glb);
                }
                finally {
                    PsiType instantiation = inferenceVariable.getInstantiation();
                    if (instantiation == PsiType.NULL) continue;
                    substitutor = substitutor.put(typeParameter, instantiation);
                }
            }
        }
        return substitutor;
    }

    private PsiType acceptBoundsWithRecursiveDependencies(PsiTypeParameter typeParameter, PsiType bound) {
        if (!this.isProperType(bound)) {
            PsiSubstitutor substitutor = PsiUtil.resolveClassInType(bound) != typeParameter ? this.mySiteSubstitutor.put(typeParameter, null) : this.mySiteSubstitutor;
            return substitutor.substitute(bound);
        }
        return bound;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public GlobalSearchScope getScope() {
        return GlobalSearchScope.allScope(this.myManager.getProject());
    }

    public Collection<InferenceVariable> getInferenceVariables() {
        return this.myInferenceVariables.values();
    }

    public void addConstraint(ConstraintFormula constraint) {
        if (!this.myConstraints.contains(constraint)) {
            this.myConstraints.add(constraint);
        }
    }

    public Collection<PsiTypeParameter> getTypeParams() {
        return this.myInferenceVariables.keySet();
    }

    public void addVariable(PsiTypeParameter typeParameter, PsiType parameter) {
        InferenceVariable variable = new InferenceVariable(typeParameter);
        if (parameter instanceof PsiWildcardType) {
            PsiType bound = ((PsiWildcardType)parameter).getBound();
            if (bound != null) {
                variable.addBound(bound, ((PsiWildcardType)parameter).isExtends() ? InferenceBound.UPPER : InferenceBound.LOWER);
            } else {
                variable.addBound(PsiType.getJavaLangObject(typeParameter.getManager(), parameter.getResolveScope()), InferenceBound.UPPER);
            }
        } else {
            variable.addBound(parameter, InferenceBound.EQ);
        }
        this.myInferenceVariables.put(typeParameter, variable);
    }

    private boolean proceedWithAdditionalConstraints(Set<ConstraintFormula> additionalConstraints) {
        while (!additionalConstraints.isEmpty()) {
            HashSet<InferenceVariable> outputVariables = new HashSet<InferenceVariable>();
            for (ConstraintFormula constraint : additionalConstraints) {
                Set<InferenceVariable> outputVars;
                if (!(constraint instanceof InputOutputConstraintFormula) || (outputVars = ((InputOutputConstraintFormula)constraint).getOutputVariables(((InputOutputConstraintFormula)constraint).getInputVariables(this), this)) == null) continue;
                outputVariables.addAll(outputVars);
            }
            Set<Object> subset = new HashSet<ConstraintFormula>();
            HashSet<InferenceVariable> varsToResolve = new HashSet<InferenceVariable>();
            for (ConstraintFormula constraintFormula : additionalConstraints) {
                if (constraintFormula instanceof InputOutputConstraintFormula) {
                    Set<InferenceVariable> inputVariables = ((InputOutputConstraintFormula)constraintFormula).getInputVariables(this);
                    if (inputVariables == null) continue;
                    boolean dependsOnOutput = false;
                    for (InferenceVariable inputVariable : inputVariables) {
                        Set<InferenceVariable> dependencies = inputVariable.getDependencies(this);
                        dependencies.add(inputVariable);
                        dependencies.retainAll(outputVariables);
                        if (dependencies.isEmpty()) continue;
                        dependsOnOutput = true;
                        break;
                    }
                    if (dependsOnOutput) continue;
                    subset.add(constraintFormula);
                    varsToResolve.addAll(inputVariables);
                    continue;
                }
                subset.add(constraintFormula);
            }
            if (subset.isEmpty()) {
                subset = Collections.singleton(additionalConstraints.iterator().next());
            }
            additionalConstraints.removeAll(subset);
            this.mySiteSubstitutor = this.resolveBounds(varsToResolve, this.mySiteSubstitutor);
            for (ConstraintFormula constraintFormula : subset) {
                constraintFormula.apply(this.mySiteSubstitutor);
                if (constraintFormula.reduce(this, this.myConstraints)) continue;
                return false;
            }
            this.myConstraintIdx = this.myConstraints.size();
            this.myIncorporationPhase.incorporate();
        }
        return true;
    }
}

