/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import org.jetbrains.annotations.NotNull;

public class VirtualFilePropertyEvent
extends VirtualFileEvent {
    private final String myPropertyName;
    private final Object myOldValue;
    private final Object myNewValue;

    public VirtualFilePropertyEvent(Object requestor, @NotNull VirtualFile file, @NotNull String propertyName, Object oldValue, Object newValue) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/VirtualFilePropertyEvent", "<init>"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/VirtualFilePropertyEvent", "<init>"));
        }
        super(requestor, file, file.getName(), file.getParent());
        this.myPropertyName = propertyName;
        this.myOldValue = oldValue;
        this.myNewValue = newValue;
    }

    @NotNull
    public String getPropertyName() {
        String string = this.myPropertyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFilePropertyEvent", "getPropertyName"));
        }
        return string;
    }

    public Object getOldValue() {
        return this.myOldValue;
    }

    public Object getNewValue() {
        return this.myNewValue;
    }
}

