/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.jetbrains.annotations.NotNull;

public abstract class JobScheduler {
    private static final ScheduledThreadPoolExecutor ourScheduledExecutorService;
    private static final Logger LOG;
    private static final ThreadLocal<Long> START;

    private static Object info(Runnable r) {
        if (!(r instanceof FutureTask)) {
            return r;
        }
        Object sync = ReflectionUtil.getField(FutureTask.class, r, Object.class, "sync");
        Object o = sync == null ? r : sync;
        Callable callable = ReflectionUtil.getField(o.getClass(), o, Callable.class, "callable");
        if (callable == null) {
            return null;
        }
        Object task = ReflectionUtil.getField(callable.getClass(), callable, Object.class, "task");
        return task == null ? callable : task;
    }

    private static void enableRemoveOnCancelPolicy(ScheduledThreadPoolExecutor executor) {
        try {
            Method setRemoveOnCancelPolicy = ScheduledThreadPoolExecutor.class.getDeclaredMethod("setRemoveOnCancelPolicy", Boolean.TYPE);
            setRemoveOnCancelPolicy.setAccessible(true);
            setRemoveOnCancelPolicy.invoke((Object)executor, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public static ScheduledExecutorService getScheduler() {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = ourScheduledExecutorService;
        if (scheduledThreadPoolExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/concurrency/JobScheduler", "getScheduler"));
        }
        return scheduledThreadPoolExecutor;
    }

    static {
        LOG = Logger.getInstance("#com.intellij.concurrency.JobScheduler");
        START = new ThreadLocal();
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, ConcurrencyUtil.newNamedThreadFactory("Periodic tasks thread", true, 5)){

            @Override
            protected void beforeExecute(Thread t, Runnable r) {
                START.set(System.currentTimeMillis());
            }

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                Object unwrapped;
                long elapsed = System.currentTimeMillis() - (Long)START.get();
                if (elapsed > 50L && (unwrapped = JobScheduler.info(r)) != null) {
                    String msg = "50 ms execution limit failed for: " + unwrapped + "; elapsed time was " + elapsed + "ms";
                    LOG.info(msg);
                }
            }
        };
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        JobScheduler.enableRemoveOnCancelPolicy(executor);
        ourScheduledExecutorService = executor;
    }
}

