/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetEscapeStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetLiteralStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

public final class StringTemplateTranslator
extends AbstractTranslator {
    @NotNull
    private final JetStringTemplateExpression expression;

    @NotNull
    public static JsExpression translate(@NotNull JetStringTemplateExpression expression, @NotNull TranslationContext context) {
        return new StringTemplateTranslator(expression, context).translate();
    }

    private StringTemplateTranslator(@NotNull JetStringTemplateExpression expression, @NotNull TranslationContext context) {
        super(context);
        this.expression = expression;
    }

    @NotNull
    private JsExpression translate() {
        assert (this.expression.getEntries().length != 0) : "String template must have one or more entries.";
        EntryVisitor entryVisitor = new EntryVisitor();
        for (JetStringTemplateEntry entry : this.expression.getEntries()) {
            entry.accept(entryVisitor);
        }
        return entryVisitor.getResultingExpression();
    }

    private final class EntryVisitor
    extends JetVisitorVoid {
        @Nullable
        private JsExpression resultingExpression = null;

        private EntryVisitor() {
        }

        void append(@NotNull JsExpression expression) {
            this.resultingExpression = this.resultingExpression == null ? expression : JsAstUtils.sum(this.resultingExpression, expression);
        }

        @Override
        public void visitStringTemplateEntryWithExpression(@NotNull JetStringTemplateEntryWithExpression entry) {
            JetExpression entryExpression = entry.getExpression();
            assert (entryExpression != null) : "JetStringTemplateEntryWithExpression must have not null entry expression.";
            JsExpression translatedExpression = Translation.translateAsExpression(entryExpression, StringTemplateTranslator.this.context());
            if (translatedExpression instanceof JsNumberLiteral) {
                this.append(StringTemplateTranslator.this.context().program().getStringLiteral(translatedExpression.toString()));
                return;
            }
            if (this.mustCallToString(entryExpression)) {
                this.append(new JsInvocation(new JsNameRef("toString", translatedExpression)));
            } else {
                this.append(translatedExpression);
            }
        }

        private boolean mustCallToString(@NotNull JetExpression entryExpression) {
            Name typeName = JsDescriptorUtils.getNameIfStandardType(entryExpression, StringTemplateTranslator.this.context());
            if (typeName == null) {
                return true;
            }
            if (typeName.asString().equals("String")) {
                return false;
            }
            return !typeName.asString().equals("Int") || this.resultingExpression == null;
        }

        @Override
        public void visitLiteralStringTemplateEntry(@NotNull JetLiteralStringTemplateEntry entry) {
            this.appendText(entry.getText());
        }

        @Override
        public void visitEscapeStringTemplateEntry(@NotNull JetEscapeStringTemplateEntry entry) {
            this.appendText(entry.getUnescapedValue());
        }

        private void appendText(@NotNull String text) {
            this.append(StringTemplateTranslator.this.program().getStringLiteral(text));
        }

        @NotNull
        public JsExpression getResultingExpression() {
            assert (this.resultingExpression != null);
            return this.resultingExpression;
        }
    }
}

