/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNew;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.expression.FunctionTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class PropertyTranslator
extends AbstractTranslator {
    @NotNull
    private final PropertyDescriptor descriptor;
    @Nullable
    private final JetProperty declaration;

    public static void translateAccessors(@NotNull PropertyDescriptor descriptor, @NotNull List<JsPropertyInitializer> result, @NotNull TranslationContext context) {
        PropertyTranslator.translateAccessors(descriptor, null, result, context);
    }

    public static void translateAccessors(@NotNull PropertyDescriptor descriptor, @Nullable JetProperty declaration, @NotNull List<JsPropertyInitializer> result, @NotNull TranslationContext context) {
        if (context.isEcma5() && !JsDescriptorUtils.isAsPrivate(descriptor)) {
            return;
        }
        new PropertyTranslator(descriptor, declaration, context).translate(result);
    }

    private PropertyTranslator(@NotNull PropertyDescriptor descriptor, @Nullable JetProperty declaration, @NotNull TranslationContext context) {
        super(context);
        this.descriptor = descriptor;
        this.declaration = declaration;
    }

    private void translate(@NotNull List<JsPropertyInitializer> result) {
        List<JsPropertyInitializer> to;
        if (this.context().isEcma5() && !JsDescriptorUtils.isExtension(this.descriptor)) {
            to = new SmartList<JsPropertyInitializer>();
            result.add(new JsPropertyInitializer(this.context().nameToLiteral(this.descriptor), new JsObjectLiteral(to, true)));
        } else {
            to = result;
        }
        to.add(this.generateGetter());
        if (this.descriptor.isVar()) {
            to.add(this.generateSetter());
        }
    }

    private JsPropertyInitializer generateGetter() {
        if (this.hasCustomGetter()) {
            return this.translateCustomAccessor(this.getCustomGetterDeclaration());
        }
        return this.generateDefaultGetter();
    }

    private JsPropertyInitializer generateSetter() {
        if (this.hasCustomSetter()) {
            return this.translateCustomAccessor(this.getCustomSetterDeclaration());
        }
        return this.generateDefaultSetter();
    }

    private boolean hasCustomGetter() {
        return this.declaration != null && this.declaration.getGetter() != null && this.getCustomGetterDeclaration().getBodyExpression() != null;
    }

    private boolean hasCustomSetter() {
        return this.declaration != null && this.declaration.getSetter() != null && this.getCustomSetterDeclaration().getBodyExpression() != null;
    }

    @NotNull
    private JetPropertyAccessor getCustomGetterDeclaration() {
        assert (this.declaration != null);
        JetPropertyAccessor getterDeclaration = this.declaration.getGetter();
        assert (getterDeclaration != null);
        return getterDeclaration;
    }

    @NotNull
    private JetPropertyAccessor getCustomSetterDeclaration() {
        assert (this.declaration != null);
        JetPropertyAccessor setter = this.declaration.getSetter();
        assert (setter != null);
        return setter;
    }

    @NotNull
    private JsPropertyInitializer generateDefaultGetter() {
        PropertyGetterDescriptor getterDescriptor = this.descriptor.getGetter();
        assert (getterDescriptor != null) : "Getter descriptor should not be null";
        return this.generateDefaultAccessor(getterDescriptor, this.generateDefaultGetterFunction(getterDescriptor));
    }

    private JsExpression createPropertyMetadata() {
        JsNameRef propertyMetadataRef = this.context().namer().propertyMetadataRef();
        JsStringLiteral argument = this.context().program().getStringLiteral(this.getPropertyName());
        if (this.context().isEcma5()) {
            return new JsInvocation((JsExpression)propertyMetadataRef, (JsExpression)argument);
        }
        return new JsNew(propertyMetadataRef, Collections.singletonList(argument));
    }

    private JsExpression getDelegateCall(ResolvedCall<FunctionDescriptor> call, List<JsExpression> args) {
        return CallBuilder.build(this.context()).receiver(Namer.getDelegateNameRef(this.getPropertyName())).args(args).resolvedCall(call).type(CallType.NORMAL).translate();
    }

    private String getPropertyName() {
        return this.descriptor.getName().asString();
    }

    @NotNull
    private JsFunction generateDefaultGetterFunction(@NotNull PropertyGetterDescriptor getterDescriptor) {
        ResolvedCall<FunctionDescriptor> delegatedCall = this.bindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, getterDescriptor);
        JsExpression value = delegatedCall != null ? this.getDelegateCall(delegatedCall, this.getDelegateCallArgs(null)) : TranslationUtils.backingFieldReference(this.context(), this.descriptor);
        return TranslationUtils.simpleReturnFunction(this.context().getScopeForDescriptor(getterDescriptor.getContainingDeclaration()), value);
    }

    @NotNull
    private List<JsExpression> getDelegateCallArgs(@Nullable JsExpression valueExpression) {
        ArrayList<JsExpression> args = new ArrayList<JsExpression>();
        args.add(JsLiteral.THIS);
        args.add(this.createPropertyMetadata());
        if (valueExpression != null) {
            args.add(valueExpression);
        }
        return args;
    }

    @NotNull
    private JsPropertyInitializer generateDefaultSetter() {
        PropertySetterDescriptor setterDescriptor = this.descriptor.getSetter();
        assert (setterDescriptor != null) : "Setter descriptor should not be null";
        return this.generateDefaultAccessor(setterDescriptor, this.generateDefaultSetterFunction(setterDescriptor));
    }

    @NotNull
    private JsFunction generateDefaultSetterFunction(@NotNull PropertySetterDescriptor setterDescriptor) {
        JsFunction fun = new JsFunction(this.context().getScopeForDescriptor(setterDescriptor.getContainingDeclaration()));
        JsParameter defaultParameter = new JsParameter(this.propertyAccessContext(setterDescriptor).scope().declareTemporary());
        fun.getParameters().add(defaultParameter);
        ResolvedCall<FunctionDescriptor> delegatedCall = this.bindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, setterDescriptor);
        JsNameRef defaultParameterRef = defaultParameter.getName().makeRef();
        JsExpression setExpression = delegatedCall != null ? this.getDelegateCall(delegatedCall, this.getDelegateCallArgs(defaultParameterRef)) : TranslationUtils.assignmentToBackingField(this.context(), this.descriptor, defaultParameterRef);
        fun.setBody(new JsBlock(setExpression.makeStmt()));
        return fun;
    }

    @NotNull
    private JsPropertyInitializer generateDefaultAccessor(@NotNull PropertyAccessorDescriptor accessorDescriptor, @NotNull JsFunction function) {
        if (this.context().isEcma5()) {
            return TranslationUtils.translateFunctionAsEcma5PropertyDescriptor(function, accessorDescriptor, this.context());
        }
        return new JsPropertyInitializer(this.context().getNameForDescriptor(accessorDescriptor).makeRef(), function);
    }

    @NotNull
    private TranslationContext propertyAccessContext(@NotNull PropertySetterDescriptor propertySetterDescriptor) {
        return this.context().newDeclaration(propertySetterDescriptor);
    }

    @NotNull
    private JsPropertyInitializer translateCustomAccessor(@NotNull JetPropertyAccessor expression) {
        FunctionTranslator translator = Translation.functionTranslator(expression, this.context());
        return this.context().isEcma5() ? translator.translateAsEcma5PropertyDescriptor() : translator.translateAsMethod();
    }
}

