/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Named;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class Namer {
    public static final String KOTLIN_NAME = "Kotlin";
    public static final String KOTLIN_LOWER_NAME = "Kotlin".toLowerCase();
    public static final String CALLEE_NAME = "$fun";
    public static final String OUTER_CLASS_NAME = "$outer";
    private static final Named CLASS_OBJECT_INITIALIZER_NAMED = new Named(){

        @Override
        @NotNull
        public Name getName() {
            return Name.identifier("object_initializer$");
        }
    };
    @NotNull
    private final JsName kotlinName;
    @NotNull
    private final JsScope kotlinScope;
    @NotNull
    private final JsName className;
    @NotNull
    private final JsName traitName;
    @NotNull
    private final JsExpression definePackage;
    @NotNull
    private final JsName objectName;
    @NotNull
    private final JsName enumEntriesName;
    @NotNull
    private final JsName isTypeName;

    @NotNull
    public static String getReceiverParameterName() {
        return "$receiver";
    }

    @NotNull
    public static String getRootNamespaceName() {
        return "_";
    }

    @NotNull
    public static JsNameRef initializeMethodReference() {
        return new JsNameRef("initialize");
    }

    @NotNull
    public static String superMethodName() {
        return "super_init";
    }

    @NotNull
    public static String nameForClassesVariable() {
        return "classes";
    }

    @NotNull
    public static String getNameForAccessor(@NotNull String propertyName, boolean isGetter, boolean useNativeAccessor) {
        if (useNativeAccessor) {
            return propertyName;
        }
        if (isGetter) {
            return Namer.getNameForGetter(propertyName);
        }
        return Namer.getNameForSetter(propertyName);
    }

    @NotNull
    public static String getKotlinBackingFieldName(@NotNull String propertyName) {
        return Namer.getNameWithPrefix(propertyName, "$");
    }

    @NotNull
    private static String getNameForGetter(@NotNull String propertyName) {
        return Namer.getNameWithPrefix(propertyName, "get_");
    }

    @NotNull
    private static String getNameForSetter(@NotNull String propertyName) {
        return Namer.getNameWithPrefix(propertyName, "set_");
    }

    @NotNull
    public static JsExpression getClassObjectAccessor(@NotNull JsExpression referenceToClass) {
        return new JsInvocation(new JsNameRef("object$", referenceToClass));
    }

    @NotNull
    public static Named getNamedForClassObjectInitializer() {
        return CLASS_OBJECT_INITIALIZER_NAMED;
    }

    @NotNull
    public static String getDelegateName(@NotNull String propertyName) {
        return propertyName + "$delegate";
    }

    @NotNull
    public static JsNameRef getDelegateNameRef(String propertyName) {
        return new JsNameRef(Namer.getDelegateName(propertyName), (JsExpression)JsLiteral.THIS);
    }

    @NotNull
    private static String getNameWithPrefix(@NotNull String name, @NotNull String prefix) {
        return prefix + name;
    }

    @NotNull
    public static Namer newInstance(@NotNull JsScope rootScope) {
        return new Namer(rootScope);
    }

    private Namer(@NotNull JsScope rootScope) {
        this.kotlinName = rootScope.declareName(KOTLIN_NAME);
        this.kotlinScope = new JsScope(rootScope, "Kotlin standard object");
        this.traitName = this.kotlinScope.declareName("createTrait");
        this.definePackage = this.kotlin("definePackage");
        this.className = this.kotlinScope.declareName("createClass");
        this.enumEntriesName = this.kotlinScope.declareName("createEnumEntries");
        this.objectName = this.kotlinScope.declareName("createObject");
        this.isTypeName = this.kotlinScope.declareName("isType");
    }

    @NotNull
    public JsExpression classCreationMethodReference() {
        return this.kotlin(this.className);
    }

    @NotNull
    public JsExpression enumEntriesCreationMethodReference() {
        return this.kotlin(this.enumEntriesName);
    }

    @NotNull
    public JsExpression traitCreationMethodReference() {
        return this.kotlin(this.traitName);
    }

    @NotNull
    public JsExpression packageDefinitionMethodReference() {
        return this.definePackage;
    }

    @NotNull
    public JsExpression objectCreationMethodReference() {
        return this.kotlin(this.objectName);
    }

    @NotNull
    public JsExpression throwNPEFunctionRef() {
        return new JsNameRef("throwNPE", (JsExpression)this.kotlinObject());
    }

    @NotNull
    public JsNameRef propertyMetadataRef() {
        return new JsNameRef("PropertyMetadata", (JsExpression)this.kotlinObject());
    }

    @NotNull
    private JsNameRef kotlin(@NotNull JsName name) {
        return new JsNameRef(name, (JsExpression)this.kotlinObject());
    }

    @NotNull
    public JsExpression kotlin(@NotNull String name) {
        return this.kotlin(this.kotlinScope.declareName(name));
    }

    @NotNull
    public JsNameRef kotlinObject() {
        return this.kotlinName.makeRef();
    }

    @NotNull
    public JsExpression isOperationReference() {
        return this.kotlin(this.isTypeName);
    }

    @NotNull
    JsScope getKotlinScope() {
        return this.kotlinScope;
    }

    @NotNull
    static String generateNamespaceName(DeclarationDescriptor descriptor) {
        if (DescriptorUtils.isRootNamespace((NamespaceDescriptor)descriptor)) {
            return Namer.getRootNamespaceName();
        }
        return descriptor.getName().asString();
    }

    @NotNull
    public JsInvocation classCreateInvocation(@NotNull ClassDescriptor descriptor) {
        switch (descriptor.getKind()) {
            case TRAIT: {
                return new JsInvocation(this.traitCreationMethodReference());
            }
            case OBJECT: 
            case CLASS_OBJECT: 
            case ENUM_ENTRY: {
                return new JsInvocation(this.objectCreationMethodReference());
            }
        }
        return new JsInvocation(this.classCreationMethodReference());
    }

    @NotNull
    public JsInvocation enumEntriesObjectCreateInvocation() {
        return new JsInvocation(this.enumEntriesCreationMethodReference());
    }
}

