/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetBreakExpression;
import org.jetbrains.jet.lang.psi.JetContinueExpression;
import org.jetbrains.jet.lang.psi.JetDoWhileExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetIdeTemplate;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetThrowExpression;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.JetWhileExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.expressions.BasicExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.ClosureExpressionsTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.ControlStructureTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingFacade;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingVisitorForStatements;
import org.jetbrains.jet.lang.types.expressions.PatternMatchingTypingVisitor;
import org.jetbrains.jet.util.lazy.ReenteringLazyValueComputationException;

public class ExpressionTypingVisitorDispatcher
extends JetVisitor<JetTypeInfo, ExpressionTypingContext>
implements ExpressionTypingInternals {
    private final BasicExpressionTypingVisitor basic;
    private final ExpressionTypingVisitorForStatements statements;
    private final ClosureExpressionsTypingVisitor closures = new ClosureExpressionsTypingVisitor(this);
    private final ControlStructureTypingVisitor controlStructures = new ControlStructureTypingVisitor(this);
    private final PatternMatchingTypingVisitor patterns = new PatternMatchingTypingVisitor(this);

    @Override
    public JetTypeInfo visitIdeTemplate(JetIdeTemplate expression, ExpressionTypingContext data) {
        return (JetTypeInfo)this.basic.visitIdeTemplate(expression, data);
    }

    @NotNull
    public static ExpressionTypingFacade create() {
        return new ExpressionTypingVisitorDispatcher(null);
    }

    @NotNull
    public static ExpressionTypingInternals createForBlock(WritableScope writableScope) {
        return new ExpressionTypingVisitorDispatcher(writableScope);
    }

    private ExpressionTypingVisitorDispatcher(WritableScope writableScope) {
        this.basic = new BasicExpressionTypingVisitor(this);
        this.statements = writableScope != null ? new ExpressionTypingVisitorForStatements(this, writableScope, this.basic, this.controlStructures, this.patterns) : null;
    }

    @Override
    @NotNull
    public JetTypeInfo checkInExpression(JetElement callElement, @NotNull JetSimpleNameExpression operationSign, @Nullable JetExpression left, @NotNull JetExpression right, ExpressionTypingContext context) {
        return this.basic.checkInExpression(callElement, operationSign, left, right, context);
    }

    @Override
    @NotNull
    public final JetTypeInfo safeGetTypeInfo(@NotNull JetExpression expression, ExpressionTypingContext context) {
        JetTypeInfo typeInfo = this.getTypeInfo(expression, context);
        if (typeInfo.getType() != null) {
            return typeInfo;
        }
        return JetTypeInfo.create(ErrorUtils.createErrorType("Type for " + expression.getText()), context.dataFlowInfo);
    }

    @Override
    @NotNull
    public final JetTypeInfo getTypeInfo(@NotNull JetExpression expression, ExpressionTypingContext context) {
        return this.getTypeInfo(expression, context, this);
    }

    @Override
    @NotNull
    public final JetTypeInfo getTypeInfo(@NotNull JetExpression expression, ExpressionTypingContext context, boolean isStatement) {
        if (!isStatement) {
            return this.getTypeInfo(expression, context);
        }
        if (this.statements != null) {
            return this.getTypeInfo(expression, context, this.statements);
        }
        return this.getTypeInfo(expression, context, this.createStatementVisitor(context));
    }

    private ExpressionTypingVisitorForStatements createStatementVisitor(ExpressionTypingContext context) {
        return new ExpressionTypingVisitorForStatements(this, ExpressionTypingUtils.newWritableScopeImpl(context, "statement scope"), this.basic, this.controlStructures, this.patterns);
    }

    @Override
    public void checkStatementType(@NotNull JetExpression expression, ExpressionTypingContext context) {
        expression.accept(this.createStatementVisitor(context), context);
    }

    @NotNull
    private JetTypeInfo getTypeInfo(@NotNull JetExpression expression, ExpressionTypingContext context, JetVisitor<JetTypeInfo, ExpressionTypingContext> visitor) {
        JetTypeInfo result;
        JetTypeInfo recordedTypeInfo = BindingContextUtils.getRecordedTypeInfo(expression, context.trace.getBindingContext());
        if (recordedTypeInfo != null) {
            return recordedTypeInfo;
        }
        try {
            result = expression.accept(visitor, context);
            if (context.trace.get(BindingContext.PROCESSED, expression).booleanValue()) {
                return JetTypeInfo.create(context.trace.getBindingContext().get(BindingContext.EXPRESSION_TYPE, expression), result.getDataFlowInfo());
            }
            if (result.getType() instanceof DeferredType) {
                result = JetTypeInfo.create(((DeferredType)result.getType()).getActualType(), result.getDataFlowInfo());
            }
            if (result.getType() != null) {
                context.trace.record(BindingContext.EXPRESSION_TYPE, expression, result.getType());
            }
        }
        catch (ReenteringLazyValueComputationException e) {
            context.trace.report(Errors.TYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM.on(expression));
            result = JetTypeInfo.create(null, context.dataFlowInfo);
        }
        if (!context.trace.get(BindingContext.PROCESSED, expression).booleanValue() && !BindingContextUtils.isExpressionWithValidReference(expression, context.trace.getBindingContext())) {
            context.trace.record(BindingContext.RESOLUTION_SCOPE, expression, context.scope);
        }
        context.trace.record(BindingContext.PROCESSED, expression);
        if (result.getDataFlowInfo() != DataFlowInfo.EMPTY) {
            context.trace.record(BindingContext.EXPRESSION_DATA_FLOW_INFO, expression, result.getDataFlowInfo());
        }
        return result;
    }

    @Override
    public JetTypeInfo visitFunctionLiteralExpression(JetFunctionLiteralExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.closures, data);
    }

    @Override
    public JetTypeInfo visitObjectLiteralExpression(JetObjectLiteralExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.closures, data);
    }

    @Override
    public JetTypeInfo visitThrowExpression(JetThrowExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.controlStructures, data);
    }

    @Override
    public JetTypeInfo visitReturnExpression(JetReturnExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.controlStructures, data);
    }

    @Override
    public JetTypeInfo visitContinueExpression(JetContinueExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.controlStructures, data);
    }

    @Override
    public JetTypeInfo visitIfExpression(JetIfExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.controlStructures, data);
    }

    @Override
    public JetTypeInfo visitTryExpression(JetTryExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.controlStructures, data);
    }

    @Override
    public JetTypeInfo visitForExpression(JetForExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.controlStructures, data);
    }

    @Override
    public JetTypeInfo visitWhileExpression(JetWhileExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.controlStructures, data);
    }

    @Override
    public JetTypeInfo visitDoWhileExpression(JetDoWhileExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.controlStructures, data);
    }

    @Override
    public JetTypeInfo visitBreakExpression(JetBreakExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.controlStructures, data);
    }

    @Override
    public JetTypeInfo visitIsExpression(JetIsExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.patterns, data);
    }

    @Override
    public JetTypeInfo visitWhenExpression(JetWhenExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.patterns, data);
    }

    @Override
    public JetTypeInfo visitJetElement(JetElement element, ExpressionTypingContext data) {
        return element.accept(this.basic, data);
    }
}

