/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.provider.ClassPsiDeclarationProvider;
import org.jetbrains.jet.lang.resolve.java.scope.JavaBaseScope;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;

public abstract class JavaClassMembersScope
extends JavaBaseScope {
    @NotNull
    protected final ClassPsiDeclarationProvider declarationProvider;
    private Map<Name, ClassDescriptor> innerClassesMap = null;

    protected JavaClassMembersScope(@NotNull ClassOrNamespaceDescriptor descriptor, @NotNull ClassPsiDeclarationProvider declarationProvider, @NotNull JavaSemanticServices semanticServices) {
        super(descriptor, semanticServices, declarationProvider);
        this.declarationProvider = declarationProvider;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(LabelName labelName) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected Set<FunctionDescriptor> computeFunctionDescriptor(@NotNull Name name) {
        return this.getResolver().resolveFunctionGroup(name, this.declarationProvider, this.descriptor);
    }

    @NotNull
    private Map<Name, ClassDescriptor> getInnerClassesMap() {
        if (this.innerClassesMap == null) {
            Collection<ClassDescriptor> innerClasses = this.getInnerClasses();
            this.innerClassesMap = new HashMap<Name, ClassDescriptor>();
            for (ClassDescriptor innerClass : innerClasses) {
                this.innerClassesMap.put(innerClass.getName(), innerClass);
            }
        }
        return this.innerClassesMap;
    }

    @Override
    @NotNull
    protected Collection<ClassDescriptor> computeInnerClasses() {
        return this.getResolver().resolveInnerClasses(this.declarationProvider);
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
        ClassDescriptor innerClass = this.getInnerClassesMap().get(name);
        if (innerClass != null && innerClass.getKind().isObject()) {
            return innerClass;
        }
        return null;
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        ClassDescriptor innerClass = this.getInnerClassesMap().get(name);
        if (innerClass == null || innerClass.getKind().isObject()) {
            return null;
        }
        return innerClass;
    }
}

