/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorByExpressionSpecifier;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;

public class DelegationResolver {
    private DelegationResolver() {
    }

    public static void addDelegatedMembers(@NotNull BindingTrace trace, @NotNull JetClassOrObject jetClass, @NotNull MutableClassDescriptor classDescriptor) {
        for (JetDelegationSpecifier delegationSpecifier : jetClass.getDelegationSpecifiers()) {
            JetDelegatorByExpressionSpecifier specifier;
            JetType type;
            if (!(delegationSpecifier instanceof JetDelegatorByExpressionSpecifier) || (type = trace.get(BindingContext.TYPE, (specifier = (JetDelegatorByExpressionSpecifier)delegationSpecifier).getTypeReference())) == null) continue;
            final Collection<CallableMemberDescriptor> membersToSkip = DelegationResolver.getMembersFromClassSupertype(type);
            Collection<CallableMemberDescriptor> descriptorsToDelegate = Collections2.filter(DelegationResolver.extractCallableMembers(type), new Predicate<CallableMemberDescriptor>(){

                @Override
                public boolean apply(@Nullable CallableMemberDescriptor descriptor) {
                    for (CallableMemberDescriptor memberToSkip : membersToSkip) {
                        if (!DelegationResolver.haveSameSignatures(memberToSkip, descriptor)) continue;
                        return false;
                    }
                    return true;
                }
            });
            Collection<CallableMemberDescriptor> generatedDescriptors = DelegationResolver.generateDelegatedMembers(classDescriptor, descriptorsToDelegate);
            block1: for (CallableMemberDescriptor descriptor : generatedDescriptors) {
                for (CallableMemberDescriptor existingDescriptor : classDescriptor.getAllCallableMembers()) {
                    if (OverridingUtil.isOverridableBy(existingDescriptor, descriptor).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) continue;
                    if (existingDescriptor.getKind() != CallableMemberDescriptor.Kind.DELEGATION) continue block1;
                    trace.report(Errors.MANY_IMPL_MEMBER_NOT_IMPLEMENTED.on(jetClass.getNameIdentifier(), jetClass, existingDescriptor));
                    continue block1;
                }
                if (descriptor instanceof PropertyDescriptor) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
                    classDescriptor.getBuilder().addPropertyDescriptor(propertyDescriptor);
                    continue;
                }
                if (!(descriptor instanceof SimpleFunctionDescriptor)) continue;
                SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)descriptor;
                classDescriptor.getBuilder().addFunctionDescriptor(functionDescriptor);
            }
        }
    }

    private static boolean haveSameSignatures(CallableDescriptor memberOne, CallableDescriptor memberTwo) {
        return OverridingUtil.isOverridableBy(memberOne, memberTwo).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE;
    }

    private static Collection<CallableMemberDescriptor> getMembersFromClassSupertype(JetType type) {
        JetType classSupertype = null;
        for (JetType supertype : TypeUtils.getAllSupertypes(type)) {
            if (!DelegationResolver.isNotTrait(supertype.getConstructor().getDeclarationDescriptor())) continue;
            classSupertype = supertype;
            break;
        }
        return classSupertype != null ? DelegationResolver.extractCallableMembers(classSupertype) : Collections.emptyList();
    }

    private static Collection<CallableMemberDescriptor> extractCallableMembers(JetType type) {
        return Collections2.filter(type.getMemberScope().getAllDescriptors(), Predicates.instanceOf(CallableMemberDescriptor.class));
    }

    private static boolean isNotTrait(DeclarationDescriptor descriptor) {
        if (descriptor instanceof ClassDescriptor) {
            ClassKind kind = ((ClassDescriptor)descriptor).getKind();
            return kind != ClassKind.TRAIT;
        }
        return false;
    }

    public static <T extends CallableMemberDescriptor> Collection<T> generateDelegatedMembers(DeclarationDescriptor newOwner, Collection<T> delegatedDescriptors) {
        ArrayList<CallableMemberDescriptor> result = Lists.newArrayList();
        for (CallableMemberDescriptor memberDescriptor : delegatedDescriptors) {
            if (!memberDescriptor.getModality().isOverridable()) continue;
            Modality modality = DescriptorUtils.convertModality(memberDescriptor.getModality(), true);
            CallableMemberDescriptor copy = memberDescriptor.copy(newOwner, modality, memberDescriptor.getVisibility(), CallableMemberDescriptor.Kind.DELEGATION, false);
            result.add(copy);
        }
        return result;
    }
}

