/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.parsing;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.JetNodeType;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.parsing.JetParser;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementType;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lexer.JetLexer;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.plugin.JetLanguage;

public class JetParserDefinition
implements ParserDefinition {
    public static final String KTSCRIPT_FILE_SUFFIX = "ktscript";

    @NotNull
    public static JetParserDefinition getInstance() {
        return (JetParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(JetLanguage.INSTANCE);
    }

    @Override
    @NotNull
    public Lexer createLexer(Project project) {
        return new JetLexer();
    }

    @Override
    public PsiParser createParser(Project project) {
        return new JetParser(project);
    }

    @Override
    public IFileElementType getFileNodeType() {
        return JetStubElementTypes.FILE;
    }

    @Override
    @NotNull
    public TokenSet getWhitespaceTokens() {
        return JetTokens.WHITESPACES;
    }

    @Override
    @NotNull
    public TokenSet getCommentTokens() {
        return JetTokens.COMMENTS;
    }

    @Override
    @NotNull
    public TokenSet getStringLiteralElements() {
        return JetTokens.STRINGS;
    }

    @Override
    @NotNull
    public PsiElement createElement(ASTNode astNode) {
        IElementType elementType = astNode.getElementType();
        if (elementType instanceof JetStubElementType) {
            return ((JetStubElementType)elementType).createPsiFromAst(astNode);
        }
        if (elementType == JetNodeTypes.TYPE_CODE_FRAGMENT || elementType == JetNodeTypes.EXPRESSION_CODE_FRAGMENT) {
            return new ASTWrapperPsiElement(astNode);
        }
        return ((JetNodeType)elementType).createPsi(astNode);
    }

    @Override
    public PsiFile createFile(FileViewProvider fileViewProvider) {
        return new JetFile(fileViewProvider);
    }

    @Override
    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode astNode, ASTNode astNode1) {
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

