/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.sampullara.cli.Args;
import java.io.PrintStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.common.CLIConfigurationKeys;
import org.jetbrains.jet.cli.common.CompilerArguments;
import org.jetbrains.jet.cli.common.ExitCode;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.GroupingMessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageRenderer;
import org.jetbrains.jet.cli.common.messages.MessageSeverityCollector;
import org.jetbrains.jet.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.jet.config.CompilerConfiguration;

public abstract class CLICompiler<A extends CompilerArguments> {
    @NotNull
    public ExitCode exec(@NotNull PrintStream errStream, String ... args) {
        A arguments = this.createArguments();
        if (!this.parseArguments(errStream, arguments, args)) {
            return ExitCode.INTERNAL_ERROR;
        }
        return this.exec(errStream, arguments);
    }

    protected boolean parseArguments(@NotNull PrintStream errStream, @NotNull A arguments, @NotNull String[] args) {
        try {
            ((CompilerArguments)arguments).freeArgs = Args.parse(arguments, args);
            return true;
        }
        catch (IllegalArgumentException e) {
            errStream.println(e.getMessage());
            this.usage(errStream);
        }
        catch (Throwable t) {
            errStream.println(MessageRenderer.TAGS.renderException(t));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void usage(@NotNull PrintStream target) {
        PrintStream oldErr = System.err;
        System.setErr(target);
        try {
            Args.usage(this.createArguments());
        }
        finally {
            System.setErr(oldErr);
        }
    }

    protected void configureEnvironment(@NotNull CompilerConfiguration configuration, @NotNull A arguments) {
        configuration.addAll(CLIConfigurationKeys.COMPILER_PLUGINS, ((CompilerArguments)arguments).getCompilerPlugins());
    }

    @NotNull
    protected abstract A createArguments();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ExitCode exec(@NotNull PrintStream errStream, @NotNull A arguments) {
        if (((CompilerArguments)arguments).isHelp()) {
            this.usage(errStream);
            return ExitCode.OK;
        }
        MessageRenderer messageRenderer = this.getMessageRenderer(arguments);
        errStream.print(messageRenderer.renderPreamble());
        this.printVersionIfNeeded(errStream, arguments, messageRenderer);
        PrintingMessageCollector printingCollector = new PrintingMessageCollector(errStream, messageRenderer, ((CompilerArguments)arguments).isVerbose());
        try {
            ExitCode exitCode = this.exec(printingCollector, arguments);
            return exitCode;
        }
        finally {
            errStream.print(messageRenderer.renderConclusion());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ExitCode exec(@NotNull MessageCollector messageCollector, @NotNull A arguments) {
        GroupingMessageCollector groupingCollector = new GroupingMessageCollector(messageCollector);
        try {
            ExitCode exitCode;
            Disposable rootDisposable = CompileEnvironmentUtil.createMockDisposable();
            try {
                MessageSeverityCollector severityCollector = new MessageSeverityCollector(groupingCollector);
                ExitCode code = this.doExecute(arguments, severityCollector, rootDisposable);
                exitCode = severityCollector.anyReported(CompilerMessageSeverity.ERROR) ? ExitCode.COMPILATION_ERROR : code;
            }
            catch (Throwable throwable) {
                try {
                    Disposer.dispose(rootDisposable);
                    throw throwable;
                }
                catch (Throwable t) {
                    groupingCollector.report(CompilerMessageSeverity.EXCEPTION, MessageRenderer.PLAIN.renderException(t), CompilerMessageLocation.NO_LOCATION);
                    ExitCode exitCode2 = ExitCode.INTERNAL_ERROR;
                    return exitCode2;
                }
            }
            Disposer.dispose(rootDisposable);
            return exitCode;
        }
        finally {
            groupingCollector.flush();
        }
    }

    @NotNull
    protected abstract ExitCode doExecute(A var1, MessageCollector var2, Disposable var3);

    @NotNull
    protected MessageRenderer getMessageRenderer(@NotNull A arguments) {
        return ((CompilerArguments)arguments).isTags() ? MessageRenderer.TAGS : MessageRenderer.PLAIN;
    }

    protected void printVersionIfNeeded(@NotNull PrintStream errStream, @NotNull A arguments, @NotNull MessageRenderer messageRenderer) {
        if (((CompilerArguments)arguments).isVersion()) {
            String versionMessage = messageRenderer.render(CompilerMessageSeverity.INFO, "Kotlin Compiler version 0.6.69", CompilerMessageLocation.NO_LOCATION);
            errStream.println(versionMessage);
        }
    }

    public static void doMain(@NotNull CLICompiler compiler, @NotNull String[] args) {
        System.setProperty("java.awt.headless", "true");
        ExitCode exitCode = CLICompiler.doMainNoExit(compiler, args);
        if (exitCode != ExitCode.OK) {
            System.exit(exitCode.getCode());
        }
    }

    @NotNull
    public static ExitCode doMainNoExit(@NotNull CLICompiler compiler, @NotNull String[] args) {
        try {
            ExitCode rc = compiler.exec(System.out, args);
            if (rc != ExitCode.OK) {
                System.err.println("exec() finished with " + (Object)((Object)rc) + " return code");
            }
            if (Boolean.parseBoolean(System.getProperty("kotlin.print.cmd.args"))) {
                System.out.println("Command line arguments:");
                for (String arg : args) {
                    System.out.println(arg);
                }
            }
            return rc;
        }
        catch (CompileEnvironmentException e) {
            System.err.println(e.getMessage());
            return ExitCode.INTERNAL_ERROR;
        }
    }
}

