/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ConstraintType;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.GraphInferencePolicy;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ProcessCandidateParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ResolveClassUtil;
import com.intellij.psi.impl.source.resolve.ResolveVariableUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiResolveHelperImpl
implements PsiResolveHelper {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.resolve.PsiResolveHelperImpl");
    public static final Pair<PsiType, ConstraintType> RAW_INFERENCE = new Pair<Object, ConstraintType>(null, ConstraintType.EQUALS);
    private final PsiManager myManager;
    private static final Pair<PsiType, ConstraintType> FAILED_INFERENCE = new Pair<PsiPrimitiveType, ConstraintType>(PsiType.NULL, ConstraintType.EQUALS);
    private static final Key<Boolean> inferSubtyping = Key.create("infer.subtyping.marker");
    private static final ProcessCandidateParameterTypeInferencePolicy GRAPH_INFERENCE_POLICY = new GraphInferencePolicy();

    public PsiResolveHelperImpl(PsiManager manager) {
        this.myManager = manager;
    }

    @Override
    @NotNull
    public JavaResolveResult resolveConstructor(PsiClassType classType, PsiExpressionList argumentList, PsiElement place) {
        JavaResolveResult[] result = this.multiResolveConstructor(classType, argumentList, place);
        JavaResolveResult javaResolveResult = result.length == 1 ? result[0] : JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "resolveConstructor"));
        }
        return javaResolveResult;
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolveConstructor(@NotNull PsiClassType type, @NotNull PsiExpressionList argumentList, @NotNull PsiElement place) {
        MethodResolverProcessor processor;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
        }
        if (argumentList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
        }
        PsiClassType.ClassResolveResult classResolveResult = type.resolveGenerics();
        PsiClass aClass = classResolveResult.getElement();
        if (aClass == null) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        PsiSubstitutor substitutor = classResolveResult.getSubstitutor();
        if (argumentList.getParent() instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymous = (PsiAnonymousClass)argumentList.getParent();
            processor = new MethodResolverProcessor(anonymous, argumentList, place, place.getContainingFile());
            aClass = anonymous.getBaseClassType().resolve();
            if (aClass == null) {
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
            substitutor = substitutor.putAll(TypeConversionUtil.getSuperClassSubstitutor(aClass, anonymous, substitutor));
        } else {
            processor = new MethodResolverProcessor(aClass, argumentList, place, place.getContainingFile());
        }
        ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, substitutor);
        for (PsiMethod constructor : aClass.getConstructors()) {
            if (!processor.execute(constructor, state)) break;
        }
        JavaResolveResult[] javaResolveResultArray = processor.getResult();
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
        }
        return javaResolveResultArray;
    }

    @Override
    public PsiClass resolveReferencedClass(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "resolveReferencedClass"));
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.myManager.getProject()).getParserFacade();
        try {
            PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(referenceText, context);
            LOG.assertTrue(ref.isValid(), referenceText);
            return ResolveClassUtil.resolveClass(ref);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    public PsiVariable resolveReferencedVariable(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "resolveReferencedVariable"));
        }
        return this.resolveVar(referenceText, context, null);
    }

    @Override
    public PsiVariable resolveAccessibleReferencedVariable(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "resolveAccessibleReferencedVariable"));
        }
        boolean[] problemWithAccess = new boolean[1];
        PsiVariable variable = this.resolveVar(referenceText, context, problemWithAccess);
        return problemWithAccess[0] ? null : variable;
    }

    @Nullable
    private PsiVariable resolveVar(String referenceText, PsiElement context, boolean[] problemWithAccess) {
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.myManager.getProject()).getParserFacade();
        try {
            PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(referenceText, context);
            return ResolveVariableUtil.resolveVariable(ref, problemWithAccess, null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    public boolean isAccessible(@NotNull PsiMember member, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "isAccessible"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "isAccessible"));
        }
        return this.isAccessible(member, member.getModifierList(), place, accessObjectClass, null);
    }

    @Override
    public boolean isAccessible(@NotNull PsiMember member, @Nullable PsiModifierList modifierList, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass, @Nullable PsiElement currentFileResolveScope) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "isAccessible"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "isAccessible"));
        }
        PsiClass containingClass = member.getContainingClass();
        return JavaResolveUtil.isAccessible(member, containingClass, modifierList, place, accessObjectClass, currentFileResolveScope);
    }

    @Override
    @NotNull
    public CandidateInfo[] getReferencedMethodCandidates(@NotNull PsiCallExpression expr, boolean dummyImplicitConstructor) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getReferencedMethodCandidates"));
        }
        PsiFile containingFile = expr.getContainingFile();
        MethodCandidatesProcessor processor = new MethodCandidatesProcessor(expr, containingFile);
        try {
            PsiScopesUtil.setupAndRunProcessor(processor, expr, dummyImplicitConstructor);
        }
        catch (MethodProcessorSetupFailedException e) {
            if (CandidateInfo.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getReferencedMethodCandidates"));
            }
            return CandidateInfo.EMPTY_ARRAY;
        }
        CandidateInfo[] candidateInfoArray = processor.getCandidates();
        if (candidateInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getReferencedMethodCandidates"));
        }
        return candidateInfoArray;
    }

    private Pair<PsiType, ConstraintType> inferTypeForMethodTypeParameterInner(@NotNull PsiTypeParameter typeParameter, @NotNull PsiParameter[] parameters, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameterInner"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameterInner"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameterInner"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameterInner"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameterInner"));
        }
        PsiType[] paramTypes = new PsiType[arguments.length];
        PsiType[] argTypes = new PsiType[arguments.length];
        if (parameters.length > 0) {
            for (int j = 0; j < argTypes.length; ++j) {
                PsiExpression argument = arguments[j];
                if (argument == null || argument instanceof PsiMethodCallExpression && ourGuard.currentStack().contains(argument)) continue;
                RecursionGuard.StackStamp stackStamp = PsiDiamondType.ourDiamondGuard.markStack();
                argTypes[j] = argument.getType();
                if (!stackStamp.mayCacheNow()) {
                    argTypes[j] = null;
                    continue;
                }
                PsiParameter parameter = parameters[Math.min(j, parameters.length - 1)];
                if (j >= parameters.length && !parameter.isVarArgs()) break;
                paramTypes[j] = parameter.getType();
                if (!(paramTypes[j] instanceof PsiEllipsisType)) continue;
                paramTypes[j] = ((PsiEllipsisType)paramTypes[j]).getComponentType();
                if (arguments.length != parameters.length || !(argTypes[j] instanceof PsiArrayType) || ((PsiArrayType)argTypes[j]).getComponentType() instanceof PsiPrimitiveType) continue;
                argTypes[j] = ((PsiArrayType)argTypes[j]).getComponentType();
            }
        }
        return this.inferTypeForMethodTypeParameterInner(typeParameter, paramTypes, argTypes, partialSubstitutor, parent, policy);
    }

    private Pair<PsiType, ConstraintType> inferTypeForMethodTypeParameterInner(@NotNull PsiTypeParameter typeParameter, @NotNull PsiType[] paramTypes, @NotNull PsiType[] argTypes, @NotNull PsiSubstitutor partialSubstitutor, @Nullable PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        Pair<PsiType, ConstraintType> constraint;
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameterInner"));
        }
        if (paramTypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameterInner"));
        }
        if (argTypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameterInner"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameterInner"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameterInner"));
        }
        PsiType wildcardToCapture = null;
        Pair<PsiType, ConstraintType> rawInference = null;
        PsiType lowerBound = PsiType.NULL;
        PsiType upperBound = PsiType.NULL;
        if (paramTypes.length > 0) {
            PsiResolveHelperImpl.sortLambdaExpressionsLast(paramTypes, argTypes);
            boolean rawType = false;
            boolean nullPassed = false;
            boolean lambdaRaw = false;
            block5: for (int j = 0; j < argTypes.length; ++j) {
                Pair<PsiType, ConstraintType> currentSubstitution;
                PsiType parameterType;
                PsiType argumentType = argTypes[j];
                if (argumentType == null) continue;
                if (j >= paramTypes.length || (parameterType = paramTypes[j]) == null) break;
                rawType |= parameterType instanceof PsiClassType && ((PsiClassType)parameterType).isRaw();
                nullPassed |= argumentType == PsiType.NULL;
                if (parameterType instanceof PsiEllipsisType) {
                    parameterType = ((PsiEllipsisType)parameterType).getComponentType();
                    if (argTypes.length == paramTypes.length && argumentType instanceof PsiArrayType && !(((PsiArrayType)argumentType).getComponentType() instanceof PsiPrimitiveType)) {
                        argumentType = ((PsiArrayType)argumentType).getComponentType();
                    }
                }
                if (argumentType instanceof PsiLambdaExpressionType) {
                    currentSubstitution = this.inferSubstitutionFromLambda(typeParameter, (PsiLambdaExpressionType)argumentType, lowerBound, partialSubstitutor);
                    if (rawType && (currentSubstitution == FAILED_INFERENCE || currentSubstitution == null && lowerBound == PsiType.NULL)) {
                        return RAW_INFERENCE;
                    }
                    if (nullPassed && currentSubstitution == null) {
                        return RAW_INFERENCE;
                    }
                    if (currentSubstitution != null && currentSubstitution.first == null) {
                        lambdaRaw = true;
                    }
                    if (currentSubstitution == null && lambdaRaw) {
                        return new Pair<PsiType, ConstraintType>(PsiType.getJavaLangObject(this.myManager, typeParameter.getResolveScope()), ConstraintType.EQUALS);
                    }
                } else if (argumentType instanceof PsiMethodReferenceType) {
                    PsiMethodReferenceExpression referenceExpression = ((PsiMethodReferenceType)argumentType).getExpression();
                    currentSubstitution = this.inferConstraintFromFunctionalInterfaceMethod(typeParameter, referenceExpression, partialSubstitutor.substitute(parameterType), partialSubstitutor, policy);
                } else {
                    currentSubstitution = this.getSubstitutionForTypeParameterConstraint(typeParameter, parameterType, argumentType, true, PsiUtil.getLanguageLevel(typeParameter));
                }
                if (currentSubstitution == null) continue;
                if (currentSubstitution == FAILED_INFERENCE) {
                    return PsiResolveHelperImpl.getFailedInferenceConstraint(typeParameter);
                }
                ConstraintType constraintType = currentSubstitution.getSecond();
                PsiType type = currentSubstitution.getFirst();
                if (type == null) {
                    rawInference = RAW_INFERENCE;
                    continue;
                }
                switch (constraintType) {
                    case EQUALS: {
                        if (!(type instanceof PsiWildcardType)) {
                            return currentSubstitution;
                        }
                        if (wildcardToCapture != null) {
                            return PsiResolveHelperImpl.getFailedInferenceConstraint(typeParameter);
                        }
                        wildcardToCapture = (PsiWildcardType)type;
                        continue block5;
                    }
                    case SUPERTYPE: {
                        if (PsiType.NULL.equals(lowerBound)) {
                            lowerBound = type;
                            continue block5;
                        }
                        if (((Object)lowerBound).equals(type) || (lowerBound = GenericsUtil.getLeastUpperBound(lowerBound, type, this.myManager)) != null) continue block5;
                        return PsiResolveHelperImpl.getFailedInferenceConstraint(typeParameter);
                    }
                    case SUBTYPE: {
                        if (!PsiType.NULL.equals(upperBound) && !TypeConversionUtil.isAssignable(upperBound, type)) continue block5;
                        upperBound = type;
                    }
                }
            }
        }
        if (wildcardToCapture != null) {
            if (lowerBound != PsiType.NULL) {
                if (!wildcardToCapture.isAssignableFrom(lowerBound)) {
                    return PsiResolveHelperImpl.getFailedInferenceConstraint(typeParameter);
                }
                if (((PsiWildcardType)wildcardToCapture).isSuper()) {
                    return new Pair<PsiType, ConstraintType>(wildcardToCapture, ConstraintType.SUPERTYPE);
                }
                lowerBound = GenericsUtil.getLeastUpperBound(lowerBound, wildcardToCapture, this.myManager);
            } else {
                if (upperBound != PsiType.NULL && !upperBound.isAssignableFrom(wildcardToCapture)) {
                    return PsiResolveHelperImpl.getFailedInferenceConstraint(typeParameter);
                }
                return new Pair<PsiType, ConstraintType>(wildcardToCapture, ConstraintType.EQUALS);
            }
        }
        if (rawInference != null) {
            return rawInference;
        }
        if (lowerBound != PsiType.NULL) {
            return new Pair<PsiType, ConstraintType>(lowerBound, ConstraintType.EQUALS);
        }
        if (parent != null && (constraint = this.inferMethodTypeParameterFromParent(typeParameter, partialSubstitutor, parent, policy)) != null) {
            if (constraint.getSecond() != ConstraintType.SUBTYPE) {
                return constraint;
            }
            if (upperBound != PsiType.NULL) {
                return new Pair<PsiType, ConstraintType>(upperBound, ConstraintType.SUBTYPE);
            }
            return constraint;
        }
        if (upperBound != PsiType.NULL) {
            return new Pair<PsiType, ConstraintType>(upperBound, ConstraintType.SUBTYPE);
        }
        return null;
    }

    private static void sortLambdaExpressionsLast(@NotNull PsiType[] paramTypes, @NotNull PsiType[] argTypes) {
        if (paramTypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "sortLambdaExpressionsLast"));
        }
        if (argTypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "sortLambdaExpressionsLast"));
        }
        for (int i = 0; i < argTypes.length; ++i) {
            int k;
            PsiType argType = argTypes[i];
            if (!(argType instanceof PsiLambdaExpressionType) && !(argType instanceof PsiMethodReferenceType) || i >= argTypes.length - 1) continue;
            for (k = i + 1; (argTypes[k] instanceof PsiLambdaExpressionType || argTypes[k] instanceof PsiMethodReferenceType) && k < argTypes.length - 1; ++k) {
            }
            if (argTypes[k] instanceof PsiLambdaExpressionType || argTypes[k] instanceof PsiMethodReferenceType) continue;
            ArrayUtil.swap(paramTypes, i, k);
            ArrayUtil.swap(argTypes, i, k);
            i = k;
        }
    }

    private static Pair<PsiType, ConstraintType> getFailedInferenceConstraint(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getFailedInferenceConstraint"));
        }
        return new Pair<PsiType, ConstraintType>(JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(typeParameter), ConstraintType.EQUALS);
    }

    @Override
    public PsiType inferTypeForMethodTypeParameter(@NotNull PsiTypeParameter typeParameter, @NotNull PsiParameter[] parameters, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameter"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameter"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameter"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameter"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameter"));
        }
        Pair<PsiType, ConstraintType> constraint = this.inferTypeForMethodTypeParameterInner(typeParameter, parameters, arguments, partialSubstitutor, parent, policy);
        if (constraint == null) {
            return PsiType.NULL;
        }
        return constraint.getFirst();
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiParameter[] parameters, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent, @NotNull ParameterTypeInferencePolicy policy, @NotNull LanguageLevel languageLevel) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiParameter[] parameters, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        PsiSubstitutor psiSubstitutor = this.inferTypeArguments(typeParameters, parameters, arguments, partialSubstitutor, parent, policy, PsiUtil.getLanguageLevel(parent));
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiType[] leftTypes, @NotNull PsiType[] rightTypes, @NotNull LanguageLevel languageLevel) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (leftTypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (rightTypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (leftTypes.length != rightTypes.length) {
            throw new IllegalArgumentException("Types must be of the same length");
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter typeParameter : typeParameters) {
            PsiType substitution = PsiType.NULL;
            PsiType lowerBound = PsiType.NULL;
            for (int i1 = 0; i1 < leftTypes.length; ++i1) {
                PsiType leftType = leftTypes[i1];
                PsiType rightType = rightTypes[i1];
                Pair<PsiType, ConstraintType> constraint = this.getSubstitutionForTypeParameterConstraint(typeParameter, leftType, rightType, true, languageLevel);
                if (constraint == null) continue;
                ConstraintType constraintType = constraint.getSecond();
                PsiType current = constraint.getFirst();
                if (constraintType == ConstraintType.EQUALS) {
                    substitution = current;
                    break;
                }
                if (constraintType == ConstraintType.SUBTYPE) {
                    if (PsiType.NULL.equals(substitution)) {
                        substitution = current;
                        continue;
                    }
                    substitution = GenericsUtil.getLeastUpperBound(substitution, current, this.myManager);
                    continue;
                }
                lowerBound = PsiType.NULL.equals(lowerBound) ? current : GenericsUtil.getLeastUpperBound(lowerBound, current, this.myManager);
            }
            if (PsiType.NULL.equals(substitution)) {
                substitution = lowerBound;
            }
            if (substitution == PsiType.NULL) continue;
            substitutor = substitutor.put(typeParameter, substitution);
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    @Nullable
    private static Pair<PsiType, ConstraintType> processArgType(PsiType arg, ConstraintType constraintType, boolean captureWildcard) {
        if (arg instanceof PsiWildcardType && !captureWildcard) {
            return FAILED_INFERENCE;
        }
        if (arg != PsiType.NULL) {
            PsiType bound;
            if (arg instanceof PsiWildcardType && (bound = ((PsiWildcardType)arg).getBound()) instanceof PsiClassType && ((PsiClassType)bound).isRaw()) {
                return Pair.create(null, constraintType);
            }
            return new Pair<PsiType, ConstraintType>(arg, constraintType);
        }
        return null;
    }

    private Pair<PsiType, ConstraintType> inferMethodTypeParameterFromParent(@NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor substitutor, @NotNull PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferMethodTypeParameterFromParent"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferMethodTypeParameterFromParent"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferMethodTypeParameterFromParent"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferMethodTypeParameterFromParent"));
        }
        PsiTypeParameterListOwner owner = typeParameter.getOwner();
        Pair<PsiType, ConstraintType> substitution = null;
        if (owner instanceof PsiMethod && parent instanceof PsiCallExpression) {
            PsiCallExpression methodCall = (PsiCallExpression)parent;
            substitution = this.inferMethodTypeParameterFromParent(PsiUtil.skipParenthesizedExprUp(methodCall.getParent()), methodCall, typeParameter, substitutor, policy);
        }
        return substitution;
    }

    @Override
    public PsiType getSubstitutionForTypeParameter(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        Pair<PsiType, ConstraintType> constraint = this.getSubstitutionForTypeParameterConstraint(typeParam, param, arg, isContraVariantPosition, languageLevel);
        return constraint == null ? PsiType.NULL : constraint.getFirst();
    }

    @Nullable
    public Pair<PsiType, ConstraintType> getSubstitutionForTypeParameterConstraint(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        PsiClassType.ClassResolveResult paramResult;
        PsiClass paramClass;
        if (param instanceof PsiArrayType && arg instanceof PsiArrayType) {
            return this.getSubstitutionForTypeParameterConstraint(typeParam, ((PsiArrayType)param).getComponentType(), ((PsiArrayType)arg).getComponentType(), isContraVariantPosition, languageLevel);
        }
        if (!(param instanceof PsiClassType)) {
            return null;
        }
        PsiManager manager = this.myManager;
        if (arg instanceof PsiPrimitiveType) {
            if (!JavaVersionService.getInstance().isAtLeast(typeParam, JavaSdkVersion.JDK_1_7) && !isContraVariantPosition) {
                return null;
            }
            if ((arg = ((PsiPrimitiveType)arg).getBoxedType(typeParam)) == null) {
                return null;
            }
        }
        if (typeParam == (paramClass = (PsiClass)(paramResult = ((PsiClassType)param).resolveGenerics()).getElement())) {
            PsiClass psiClass = PsiUtil.resolveClassInType(arg);
            if (arg == null || arg.getDeepComponentType() instanceof PsiPrimitiveType || arg instanceof PsiIntersectionType || psiClass != null && (isContraVariantPosition || !"java.lang.Object".equals(psiClass.getQualifiedName()) || arg instanceof PsiArrayType)) {
                PsiType bound = PsiResolveHelperImpl.intersectAllExtends(typeParam, arg);
                return new Pair<PsiType, ConstraintType>(bound, ConstraintType.SUPERTYPE);
            }
            if (psiClass == null && arg instanceof PsiClassType) {
                return Pair.create(arg, ConstraintType.EQUALS);
            }
            return null;
        }
        if (paramClass == null) {
            return null;
        }
        if (!(arg instanceof PsiClassType)) {
            return null;
        }
        PsiClassType.ClassResolveResult argResult = ((PsiClassType)arg).resolveGenerics();
        PsiClass argClass = (PsiClass)argResult.getElement();
        if (argClass == null) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
        PsiClassType patternType = factory.createType(typeParam);
        if (isContraVariantPosition) {
            PsiSubstitutor substitutor = TypeConversionUtil.getClassSubstitutor(paramClass, argClass, argResult.getSubstitutor());
            if (substitutor == null) {
                return null;
            }
            arg = factory.createType(paramClass, substitutor, languageLevel);
        } else {
            PsiSubstitutor substitutor = TypeConversionUtil.getClassSubstitutor(argClass, paramClass, paramResult.getSubstitutor());
            if (substitutor == null) {
                return null;
            }
            param = factory.createType(argClass, substitutor, languageLevel);
        }
        return this.getSubstitutionForTypeParameterInner(param, arg, patternType, ConstraintType.SUPERTYPE, 0);
    }

    @Nullable
    private Pair<PsiType, ConstraintType> inferSubstitutionFromLambda(PsiTypeParameter typeParam, PsiLambdaExpressionType arg, PsiType lowerBound, PsiSubstitutor partialSubstitutor) {
        PsiLambdaExpression lambdaExpression = arg.getExpression();
        if (PsiUtil.getLanguageLevel(lambdaExpression).isAtLeast(LanguageLevel.JDK_1_8)) {
            PsiElement parent = PsiUtil.skipParenthesizedExprUp(lambdaExpression.getParent());
            if (parent instanceof PsiExpressionList) {
                Pair<PsiMethod, PsiSubstitutor> pair;
                PsiExpressionList expressionList = (PsiExpressionList)parent;
                Map<PsiElement, Pair<PsiMethod, PsiSubstitutor>> methodMap = MethodCandidateInfo.CURRENT_CANDIDATE.get();
                Pair<PsiMethod, PsiSubstitutor> pair2 = pair = methodMap != null ? methodMap.get(expressionList) : null;
                if (pair != null) {
                    int i = LambdaUtil.getLambdaIdx(expressionList, lambdaExpression);
                    if (i < 0) {
                        return null;
                    }
                    PsiParameter[] parameters = ((PsiMethod)pair.first).getParameterList().getParameters();
                    if (parameters.length <= i) {
                        return null;
                    }
                    PsiSubstitutor combinedSubst = ((PsiSubstitutor)pair.second).putAll(partialSubstitutor);
                    methodMap.put(expressionList, Pair.create(pair.first, combinedSubst));
                    return this.inferConstraintFromFunctionalInterfaceMethod(typeParam, lambdaExpression, combinedSubst.substitute(parameters[i].getType()), lowerBound);
                }
            } else {
                return this.inferConstraintFromFunctionalInterfaceMethod(typeParam, lambdaExpression, partialSubstitutor.substitute(lambdaExpression.getFunctionalInterfaceType()), lowerBound);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Pair<PsiType, ConstraintType> inferConstraintFromFunctionalInterfaceMethod(PsiTypeParameter typeParam, PsiMethodReferenceExpression methodReferenceExpression, PsiType functionalInterfaceType, PsiSubstitutor partialSubstitutor, ParameterTypeInferencePolicy policy) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiMethod functionalInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
        if (functionalInterfaceMethod != null) {
            JavaResolveResult methReferenceResolveResult;
            PsiSubstitutor subst = LambdaUtil.getSubstitutor(functionalInterfaceMethod, resolveResult);
            PsiParameter[] methodParameters = functionalInterfaceMethod.getParameterList().getParameters();
            PsiType[] methodParamTypes = new PsiType[methodParameters.length];
            for (int i = 0; i < methodParameters.length; ++i) {
                methodParamTypes[i] = GenericsUtil.eliminateWildcards(subst.substitute(methodParameters[i].getType()));
            }
            if (PsiResolveHelperImpl.methodParamsDependOn(typeParam, methodReferenceExpression, functionalInterfaceType, methodParameters, subst)) {
                return null;
            }
            PsiType[] args = new PsiType[methodParameters.length];
            Map<PsiMethodReferenceExpression, PsiType> map = PsiMethodReferenceUtil.ourRefs.get();
            if (map == null) {
                map = new HashMap<PsiMethodReferenceExpression, PsiType>();
                PsiMethodReferenceUtil.ourRefs.set(map);
            }
            PsiType added = map.put(methodReferenceExpression, functionalInterfaceType);
            try {
                methReferenceResolveResult = methodReferenceExpression.advancedResolve(false);
            }
            finally {
                if (added == null) {
                    map.remove(methodReferenceExpression);
                }
            }
            PsiElement resolved = methReferenceResolveResult.getElement();
            if (resolved instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)resolved;
                PsiParameter[] parameters = method.getParameterList().getParameters();
                boolean hasReceiver = false;
                if (methodParamTypes.length == parameters.length + 1) {
                    if (!PsiMethodReferenceUtil.isReceiverType(methodParamTypes[0], method.getContainingClass(), methReferenceResolveResult.getSubstitutor())) {
                        return null;
                    }
                    hasReceiver = true;
                } else if (parameters.length != methodParameters.length) {
                    return null;
                }
                for (int i = 0; i < parameters.length; ++i) {
                    args[i] = methReferenceResolveResult.getSubstitutor().substitute(subst.substitute(parameters[i].getType()));
                }
                PsiType[] typesToInfer = hasReceiver ? ArrayUtil.remove(methodParamTypes, 0) : methodParamTypes;
                Pair<PsiType, ConstraintType> constraint = this.inferTypeForMethodTypeParameterInner(typeParam, typesToInfer, args, subst, null, (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
                if (constraint != null) {
                    return constraint;
                }
                PsiType functionalInterfaceReturnType = functionalInterfaceMethod.getReturnType();
                if (functionalInterfaceReturnType != null && functionalInterfaceReturnType != PsiType.VOID) {
                    Pair<PsiType, ConstraintType> constraintFromParent;
                    PsiType argType;
                    Pair<PsiType, ConstraintType> typeParameterConstraint = this.getSubstitutionForTypeParameterConstraint(typeParam, functionalInterfaceReturnType = GenericsUtil.eliminateWildcards(subst.substitute(functionalInterfaceReturnType)), argType = method.isConstructor() ? JavaPsiFacade.getElementFactory(functionalInterfaceMethod.getProject()).createType(method.getContainingClass(), methReferenceResolveResult.getSubstitutor()) : methReferenceResolveResult.getSubstitutor().substitute(subst.substitute(method.getReturnType())), true, PsiUtil.getLanguageLevel(functionalInterfaceMethod));
                    if (typeParameterConstraint != null && typeParameterConstraint.getSecond() != ConstraintType.EQUALS && method.isConstructor() && (constraintFromParent = this.inferMethodTypeParameterFromParent(typeParam, partialSubstitutor, methodReferenceExpression.getParent().getParent(), policy)) != null && constraintFromParent.getSecond() == ConstraintType.EQUALS) {
                        return constraintFromParent;
                    }
                    return typeParameterConstraint;
                }
            }
        }
        return null;
    }

    @Nullable
    private Pair<PsiType, ConstraintType> inferConstraintFromFunctionalInterfaceMethod(PsiTypeParameter typeParam, PsiLambdaExpression lambdaExpression, PsiType functionalInterfaceType, PsiType lowerBound) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
        if (method != null) {
            PsiSubstitutor subst = LambdaUtil.getSubstitutor(method, resolveResult);
            Pair<PsiType, ConstraintType> constraintFromFormalParams = this.inferConstraintFromLambdaFormalParams(typeParam, subst, method, lambdaExpression);
            if (constraintFromFormalParams != null) {
                return constraintFromFormalParams;
            }
            PsiParameter[] methodParameters = method.getParameterList().getParameters();
            if (PsiResolveHelperImpl.methodParamsDependOn(typeParam, lambdaExpression, functionalInterfaceType, methodParameters, subst)) {
                return null;
            }
            PsiType returnType = subst.substitute(method.getReturnType());
            if (returnType != null && returnType != PsiType.VOID) {
                Pair<PsiType, ConstraintType> constraint = null;
                List<PsiExpression> expressions = LambdaUtil.getReturnExpressions(lambdaExpression);
                for (final PsiExpression expression : expressions) {
                    boolean independent;
                    boolean bl = independent = lambdaExpression.hasFormalParameterTypes() || LambdaUtil.isFreeFromTypeInferenceArgs(methodParameters, lambdaExpression, expression, subst, functionalInterfaceType, typeParam);
                    if (!independent) {
                        if (lowerBound == PsiType.NULL) continue;
                        return null;
                    }
                    if (expression instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression).resolve() == null) continue;
                    PsiType exprType = ourGraphGuard.doPreventingRecursion(expression, true, new Computable<PsiType>(){

                        @Override
                        public PsiType compute() {
                            return expression.getType();
                        }
                    });
                    if (exprType instanceof PsiLambdaParameterType) {
                        PsiParameter parameter = ((PsiLambdaParameterType)exprType).getParameter();
                        int parameterIndex = lambdaExpression.getParameterList().getParameterIndex(parameter);
                        if (parameterIndex > -1) {
                            exprType = subst.substitute(methodParameters[parameterIndex].getType());
                        }
                    } else {
                        if (exprType instanceof PsiLambdaExpressionType) {
                            return this.inferConstraintFromFunctionalInterfaceMethod(typeParam, ((PsiLambdaExpressionType)exprType).getExpression(), returnType, lowerBound);
                        }
                        if (exprType == null && independent) {
                            return null;
                        }
                    }
                    if (exprType == null) {
                        return FAILED_INFERENCE;
                    }
                    Pair<PsiType, ConstraintType> returnExprConstraint = this.getSubstitutionForTypeParameterConstraint(typeParam, GenericsUtil.eliminateWildcards(returnType), exprType, true, PsiUtil.getLanguageLevel(method));
                    if (returnExprConstraint == null) continue;
                    if (returnExprConstraint == FAILED_INFERENCE) {
                        return returnExprConstraint;
                    }
                    if (constraint != null) {
                        PsiType leastUpperBound = GenericsUtil.getLeastUpperBound((PsiType)constraint.getFirst(), returnExprConstraint.getFirst(), this.myManager);
                        constraint = new Pair<PsiType, ConstraintType>(leastUpperBound, ConstraintType.SUPERTYPE);
                        continue;
                    }
                    constraint = returnExprConstraint;
                }
                if (constraint != null) {
                    return constraint;
                }
            }
        }
        return null;
    }

    private static boolean methodParamsDependOn(PsiTypeParameter typeParam, PsiElement psiElement, PsiType functionalInterfaceType, PsiParameter[] methodParameters, PsiSubstitutor subst) {
        for (PsiParameter parameter : methodParameters) {
            if (!LambdaUtil.dependsOnTypeParams(subst.substitute(parameter.getType()), functionalInterfaceType, psiElement, typeParam)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private Pair<PsiType, ConstraintType> inferConstraintFromLambdaFormalParams(PsiTypeParameter typeParam, PsiSubstitutor subst, PsiMethod method, PsiLambdaExpression lambdaExpression) {
        PsiParameter[] parameters = lambdaExpression.getParameterList().getParameters();
        if (parameters.length == 0) {
            return null;
        }
        PsiType[] lambdaArgs = new PsiType[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            if (parameter.getTypeElement() == null) {
                return null;
            }
            lambdaArgs[i] = parameter.getType();
        }
        PsiParameter[] methodParameters = method.getParameterList().getParameters();
        PsiType[] methodParamTypes = new PsiType[methodParameters.length];
        for (int i = 0; i < methodParameters.length; ++i) {
            methodParamTypes[i] = GenericsUtil.eliminateWildcards(subst.substitute(methodParameters[i].getType()));
        }
        return this.inferTypeForMethodTypeParameterInner(typeParam, methodParamTypes, lambdaArgs, subst, null, (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
    }

    private static PsiType intersectAllExtends(PsiTypeParameter typeParam, PsiType arg) {
        if (arg == null) {
            return null;
        }
        PsiClassType[] superTypes = typeParam.getSuperTypes();
        PsiType[] erasureTypes = new PsiType[superTypes.length];
        for (int i = 0; i < superTypes.length; ++i) {
            erasureTypes[i] = TypeConversionUtil.erasure(superTypes[i]);
        }
        PsiType[] types = ArrayUtil.append(erasureTypes, arg, PsiType.class);
        assert (types.length != 0);
        return PsiIntersectionType.createIntersection(types);
    }

    @Nullable
    private Pair<PsiType, ConstraintType> getSubstitutionForTypeParameterInner(PsiType param, PsiType arg, PsiType patternType, ConstraintType constraintType, int depth) {
        if (arg instanceof PsiCapturedWildcardType && (depth < 2 || constraintType != ConstraintType.EQUALS)) {
            arg = ((PsiCapturedWildcardType)arg).getWildcard();
        }
        if (patternType.equals(param)) {
            return PsiResolveHelperImpl.processArgType(arg, constraintType, depth < 2);
        }
        if (param instanceof PsiWildcardType) {
            PsiClassType.ClassResolveResult argResult;
            PsiClass argClass;
            PsiClassType.ClassResolveResult boundResult;
            PsiClass boundClass;
            Pair<PsiType, ConstraintType> res;
            ConstraintType constrType;
            PsiWildcardType wildcardParam = (PsiWildcardType)param;
            PsiType paramBound = wildcardParam.getBound();
            if (paramBound == null) {
                return null;
            }
            ConstraintType constraintType2 = constrType = wildcardParam.isExtends() ? ConstraintType.SUPERTYPE : ConstraintType.SUBTYPE;
            if (arg instanceof PsiWildcardType) {
                if (((PsiWildcardType)arg).isExtends() == wildcardParam.isExtends() && ((PsiWildcardType)arg).isBounded() == wildcardParam.isBounded() && (res = this.getSubstitutionForTypeParameterInner(paramBound, ((PsiWildcardType)arg).getBound(), patternType, constrType, depth)) != null) {
                    return res;
                }
            } else if (patternType.equals(paramBound)) {
                res = this.getSubstitutionForTypeParameterInner(paramBound, arg, patternType, constrType, depth);
                if (res != null) {
                    return res;
                }
            } else if (paramBound instanceof PsiArrayType && arg instanceof PsiArrayType) {
                res = this.getSubstitutionForTypeParameterInner(((PsiArrayType)paramBound).getComponentType(), ((PsiArrayType)arg).getComponentType(), patternType, constrType, depth);
                if (res != null) {
                    return res;
                }
            } else if (paramBound instanceof PsiClassType && arg instanceof PsiClassType && (boundClass = (boundResult = ((PsiClassType)paramBound).resolveGenerics()).getElement()) != null && (argClass = (argResult = ((PsiClassType)arg).resolveGenerics()).getElement()) != null) {
                Pair<PsiType, ConstraintType> res2;
                PsiType substituted;
                PsiSubstitutor superSubstitutor;
                if (wildcardParam.isExtends()) {
                    superSubstitutor = TypeConversionUtil.getClassSubstitutor(boundClass, argClass, argResult.getSubstitutor());
                    if (superSubstitutor != null) {
                        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(boundClass)) {
                            substituted = superSubstitutor.substitute(typeParameter);
                            if (substituted == null || (res2 = this.getSubstitutionForTypeParameterInner(boundResult.getSubstitutor().substitute(typeParameter), substituted, patternType, ConstraintType.EQUALS, depth + 1)) == null) continue;
                            return res2;
                        }
                    }
                } else {
                    superSubstitutor = TypeConversionUtil.getClassSubstitutor(argClass, boundClass, boundResult.getSubstitutor());
                    if (superSubstitutor != null) {
                        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(argClass)) {
                            substituted = argResult.getSubstitutor().substitute(typeParameter);
                            if (substituted == null || (res2 = this.getSubstitutionForTypeParameterInner(superSubstitutor.substitute(typeParameter), substituted, patternType, ConstraintType.EQUALS, depth + 1)) == null || res2 == FAILED_INFERENCE) continue;
                            return res2;
                        }
                    }
                }
            }
        }
        if (param instanceof PsiArrayType && arg instanceof PsiArrayType) {
            return this.getSubstitutionForTypeParameterInner(((PsiArrayType)param).getComponentType(), ((PsiArrayType)arg).getComponentType(), patternType, constraintType, depth);
        }
        if (param instanceof PsiClassType && arg instanceof PsiClassType) {
            PsiClassType.ClassResolveResult paramResult = ((PsiClassType)param).resolveGenerics();
            PsiClass paramClass = paramResult.getElement();
            if (paramClass == null) {
                return null;
            }
            PsiClassType.ClassResolveResult argResult = ((PsiClassType)arg).resolveGenerics();
            PsiClass argClass = argResult.getElement();
            if (argClass != paramClass) {
                return this.inferBySubtypingConstraint(patternType, constraintType, depth, paramClass, argClass);
            }
            PsiType lowerBound = PsiType.NULL;
            PsiType upperBound = PsiType.NULL;
            Pair<PsiType, ConstraintType> wildcardCaptured = null;
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(paramClass)) {
                Pair<PsiType, ConstraintType> res;
                PsiType paramType = paramResult.getSubstitutor().substitute(typeParameter);
                PsiType argType = argResult.getSubstitutor().substituteWithBoundsPromotion(typeParameter);
                if (wildcardCaptured != null) {
                    boolean alreadyFound = false;
                    for (PsiTypeParameter typeParam : PsiUtil.typeParametersIterable(paramClass)) {
                        if (typeParam == typeParameter || paramType == null || argResult.getSubstitutor().substituteWithBoundsPromotion(typeParam) != argType || !paramType.equals(paramResult.getSubstitutor().substitute(typeParam))) continue;
                        alreadyFound = true;
                    }
                    if (alreadyFound) continue;
                }
                if ((res = this.getSubstitutionForTypeParameterInner(paramType, argType, patternType, ConstraintType.EQUALS, depth + 1)) == null) continue;
                PsiType type = res.getFirst();
                switch (res.getSecond()) {
                    case EQUALS: {
                        if (!(type instanceof PsiWildcardType)) {
                            return res;
                        }
                        if (wildcardCaptured != null) {
                            return FAILED_INFERENCE;
                        }
                        wildcardCaptured = res;
                        break;
                    }
                    case SUPERTYPE: {
                        wildcardCaptured = res;
                        if (PsiType.NULL.equals(lowerBound)) {
                            lowerBound = type;
                            break;
                        }
                        if (((Object)lowerBound).equals(type) || (lowerBound = GenericsUtil.getLeastUpperBound(lowerBound, type, this.myManager)) != null) break;
                        return FAILED_INFERENCE;
                    }
                    case SUBTYPE: {
                        wildcardCaptured = res;
                        if (!PsiType.NULL.equals(upperBound) && !TypeConversionUtil.isAssignable(upperBound, type)) break;
                        upperBound = type;
                    }
                }
            }
            if (lowerBound != PsiType.NULL) {
                return new Pair<PsiType, ConstraintType>(lowerBound, ConstraintType.SUPERTYPE);
            }
            if (upperBound != PsiType.NULL) {
                return new Pair<PsiType, ConstraintType>(upperBound, ConstraintType.SUBTYPE);
            }
            return wildcardCaptured;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<PsiType, ConstraintType> inferBySubtypingConstraint(PsiType patternType, ConstraintType constraintType, int depth, PsiClass paramClass, PsiClass argClass) {
        if (argClass instanceof PsiTypeParameter && paramClass instanceof PsiTypeParameter && PsiUtil.isLanguageLevel8OrHigher(argClass)) {
            PsiClassType[] paramExtendsListTypes;
            Boolean alreadyInferBySubtyping = paramClass.getCopyableUserData(inferSubtyping);
            if (alreadyInferBySubtyping != null) {
                return null;
            }
            PsiClassType[] argExtendsListTypes = argClass.getExtendsListTypes();
            if (argExtendsListTypes.length == (paramExtendsListTypes = paramClass.getExtendsListTypes()).length) {
                try {
                    paramClass.putCopyableUserData(inferSubtyping, true);
                    for (int i = 0; i < argExtendsListTypes.length; ++i) {
                        Pair<PsiType, ConstraintType> constraint;
                        PsiClassType argBoundType = argExtendsListTypes[i];
                        PsiClassType paramBoundType = paramExtendsListTypes[i];
                        PsiClassType.ClassResolveResult argResolveResult = argBoundType.resolveGenerics();
                        PsiClassType.ClassResolveResult paramResolveResult = paramBoundType.resolveGenerics();
                        PsiClass paramBoundClass = paramResolveResult.getElement();
                        PsiClass argBoundClass = argResolveResult.getElement();
                        if (argBoundClass != null && paramBoundClass != null && paramBoundClass != argBoundClass) {
                            PsiSubstitutor superClassSubstitutor;
                            if (argBoundClass.isInheritor(paramBoundClass, true)) {
                                superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(paramBoundClass, argBoundClass, argResolveResult.getSubstitutor());
                                argBoundType = JavaPsiFacade.getElementFactory(argClass.getProject()).createType(paramBoundClass, superClassSubstitutor);
                            } else {
                                superClassSubstitutor = null;
                                return superClassSubstitutor;
                            }
                        }
                        if ((constraint = this.getSubstitutionForTypeParameterInner(paramBoundType, argBoundType, patternType, constraintType, depth)) == null) continue;
                        Pair<PsiType, ConstraintType> pair = constraint;
                        return pair;
                    }
                }
                finally {
                    paramClass.putCopyableUserData(inferSubtyping, null);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<PsiType, ConstraintType> inferMethodTypeParameterFromParent(final @NotNull PsiElement parent, @NotNull PsiExpression methodCall, @NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor substitutor, @NotNull ParameterTypeInferencePolicy policy) {
        PsiType guess;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferMethodTypeParameterFromParent"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferMethodTypeParameterFromParent"));
        }
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferMethodTypeParameterFromParent"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferMethodTypeParameterFromParent"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferMethodTypeParameterFromParent"));
        }
        Pair<PsiType, ConstraintType> constraint = null;
        PsiType expectedType = PsiTypesUtil.getExpectedTypeByParent(methodCall);
        if (expectedType == null) {
            if (parent instanceof PsiReturnStatement) {
                PsiLambdaExpression lambdaExpression = PsiTreeUtil.getParentOfType(parent, PsiLambdaExpression.class);
                if (lambdaExpression != null) {
                    return PsiResolveHelperImpl.getFailedInferenceConstraint(typeParameter);
                }
            } else if (parent instanceof PsiExpressionList) {
                PsiType constraintFirst;
                PsiElement pParent = parent.getParent();
                if (pParent instanceof PsiCallExpression && parent.equals(((PsiCallExpression)pParent).getArgumentList()) && (constraint = policy.inferTypeConstraintFromCallContext(methodCall, (PsiExpressionList)parent, (PsiCallExpression)pParent, typeParameter)) == null && PsiUtil.isLanguageLevel8OrHigher(methodCall) && (constraint = PsiResolveHelperImpl.graphInferenceFromCallContext(methodCall, typeParameter, (PsiCallExpression)pParent)) != null && ((constraintFirst = constraint.getFirst()) == null || constraintFirst.equalsToText("java.lang.Object"))) {
                    constraint = null;
                }
            } else if (parent instanceof PsiLambdaExpression) {
                expectedType = ourGraphGuard.doPreventingRecursion(methodCall, true, new Computable<PsiType>(){

                    @Override
                    public PsiType compute() {
                        return LambdaUtil.getFunctionalInterfaceReturnType(((PsiLambdaExpression)parent).getFunctionalInterfaceType());
                    }
                });
                if (expectedType == null) {
                    return null;
                }
                expectedType = GenericsUtil.eliminateWildcards(expectedType);
            } else if (parent instanceof PsiConditionalExpression && PsiUtil.isLanguageLevel8OrHigher(parent)) {
                try {
                    Pair<PsiType, ConstraintType> pair = this.inferFromConditionalExpression(parent, methodCall, typeParameter, substitutor, policy);
                    if (pair != null) {
                        Pair<PsiType, ConstraintType> constraintFirst = pair;
                        return constraintFirst;
                    }
                }
                finally {
                    GraphInferencePolicy.forget(parent);
                }
            }
        }
        GlobalSearchScope scope = parent.getResolveScope();
        PsiType returnType = null;
        if (constraint == null) {
            if (expectedType == null) {
                PsiType psiType = expectedType = methodCall instanceof PsiCallExpression ? policy.getDefaultExpectedType((PsiCallExpression)methodCall) : null;
            }
            if ((constraint = this.getSubstitutionForTypeParameterConstraint(typeParameter, returnType = ((PsiMethod)typeParameter.getOwner()).getReturnType(), expectedType, false, PsiUtil.getLanguageLevel(parent))) != null && (guess = constraint.getFirst()) != null && !guess.equals(PsiType.NULL) && constraint.getSecond() == ConstraintType.SUPERTYPE && guess instanceof PsiIntersectionType) {
                for (PsiType conjuct : ((PsiIntersectionType)guess).getConjuncts()) {
                    if (conjuct.isAssignableFrom(expectedType)) continue;
                    return FAILED_INFERENCE;
                }
            }
        }
        if (constraint == null) {
            if (methodCall instanceof PsiCallExpression) {
                PsiClassType[] superTypes;
                PsiExpressionList argumentList = ((PsiCallExpression)methodCall).getArgumentList();
                if (argumentList != null && PsiUtil.getLanguageLevel(argumentList).isAtLeast(LanguageLevel.JDK_1_8)) {
                    for (PsiExpression expression : argumentList.getExpressions()) {
                        if (!(expression instanceof PsiLambdaExpression) && !(expression instanceof PsiMethodReferenceExpression)) continue;
                        PsiType functionalInterfaceType = LambdaUtil.getFunctionalInterfaceType(expression, false);
                        if (functionalInterfaceType == null || PsiUtil.resolveClassInType(functionalInterfaceType) == typeParameter) {
                            return PsiResolveHelperImpl.getFailedInferenceConstraint(typeParameter);
                        }
                        PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod(functionalInterfaceType);
                        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
                        if (method == null || PsiResolveHelperImpl.methodParamsDependOn(typeParameter, expression, functionalInterfaceType, method.getParameterList().getParameters(), LambdaUtil.getSubstitutor(method, resolveResult))) {
                            if (expression instanceof PsiMethodReferenceExpression) {
                                return PsiResolveHelperImpl.getFailedInferenceConstraint(typeParameter);
                            }
                            return null;
                        }
                        Pair<PsiType, ConstraintType> inferredExceptionTypeConstraint = PsiResolveHelperImpl.inferExceptionConstrains(typeParameter, expression, method, resolveResult.getSubstitutor());
                        if (inferredExceptionTypeConstraint == null) continue;
                        return inferredExceptionTypeConstraint;
                    }
                }
                if ((superTypes = typeParameter.getSuperTypes()).length == 0) {
                    return null;
                }
                PsiType superType = substitutor.substitute(superTypes[0]);
                if (superType instanceof PsiClassType && ((PsiClassType)superType).isRaw()) {
                    superType = TypeConversionUtil.erasure(superType);
                }
                if (superType == null) {
                    superType = PsiType.getJavaLangObject(this.myManager, scope);
                }
                if (superType == null) {
                    return null;
                }
                return policy.getInferredTypeWithNoConstraint(this.myManager, superType);
            }
            return null;
        }
        guess = (PsiType)constraint.getFirst();
        guess = policy.adjustInferredType(this.myManager, guess, (ConstraintType)((Object)constraint.getSecond()));
        if (returnType instanceof PsiClassType && typeParameter.equals(((PsiClassType)returnType).resolve())) {
            PsiClassType[] extendsTypes = typeParameter.getExtendsListTypes();
            PsiSubstitutor newSubstitutor = substitutor.put(typeParameter, guess);
            for (PsiClassType extendsType1 : extendsTypes) {
                PsiType extendsType = newSubstitutor.substitute(extendsType1);
                if (guess == null || extendsType.isAssignableFrom(guess)) continue;
                if (!guess.isAssignableFrom(extendsType)) break;
                guess = extendsType;
                newSubstitutor = substitutor.put(typeParameter, guess);
            }
        }
        return new Pair<PsiType, ConstraintType>(guess, constraint.getSecond());
    }

    private static Pair<PsiType, ConstraintType> inferExceptionConstrains(PsiTypeParameter typeParameter, PsiExpression expression, PsiMethod method, PsiSubstitutor substitutor) {
        PsiClassType[] declaredExceptions;
        for (PsiClassType exception : declaredExceptions = method.getThrowsList().getReferencedTypes()) {
            PsiClassType[] declaredThrowsList;
            PsiElement resolve;
            PsiType substitute = substitutor.substitute(exception);
            if (PsiUtil.resolveClassInType(substitute) != typeParameter) continue;
            if (expression instanceof PsiLambdaExpression) {
                List<PsiClassType> unhandledExceptions;
                PsiElement body = ((PsiLambdaExpression)expression).getBody();
                if (body == null || !(unhandledExceptions = ExceptionUtil.getUnhandledExceptions(body)).isEmpty()) break;
                return PsiResolveHelperImpl.inferUncheckedException(typeParameter, exception, method);
            }
            if (!(expression instanceof PsiMethodReferenceExpression) || !((resolve = ((PsiMethodReferenceExpression)expression).resolve()) instanceof PsiMethod)) break;
            for (PsiClassType psiClassType : declaredThrowsList = ((PsiMethod)resolve).getThrowsList().getReferencedTypes()) {
                if (ExceptionUtil.isUncheckedException(psiClassType)) continue;
                return null;
            }
            return PsiResolveHelperImpl.inferUncheckedException(typeParameter, exception, method);
        }
        return null;
    }

    private static Pair<PsiType, ConstraintType> inferUncheckedException(PsiTypeParameter typeParameter, PsiClassType exception, PsiMethod method) {
        Project project = typeParameter.getProject();
        PsiClass runtimeException = JavaPsiFacade.getInstance(project).findClass("java.lang.RuntimeException", method.getResolveScope());
        if (runtimeException != null) {
            for (PsiType superType : exception.getSuperTypes()) {
                if (InheritanceUtil.isInheritorOrSelf(runtimeException, PsiUtil.resolveClassInType(superType), true)) continue;
                return PsiResolveHelperImpl.getFailedInferenceConstraint(typeParameter);
            }
            return Pair.create(JavaPsiFacade.getElementFactory(project).createType(runtimeException, PsiSubstitutor.EMPTY), ConstraintType.EQUALS);
        }
        return null;
    }

    private Pair<PsiType, ConstraintType> inferFromConditionalExpression(@NotNull PsiElement parent, @NotNull PsiExpression methodCall, @NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor substitutor, @NotNull ParameterTypeInferencePolicy policy) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferFromConditionalExpression"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferFromConditionalExpression"));
        }
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferFromConditionalExpression"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferFromConditionalExpression"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferFromConditionalExpression"));
        }
        Pair<PsiType, ConstraintType> pair = this.inferMethodTypeParameterFromParent(PsiUtil.skipParenthesizedExprUp(parent.getParent()), (PsiExpression)parent, typeParameter, substitutor, policy);
        if (pair == null) {
            PsiType elseType;
            final PsiExpression thenExpression = ((PsiConditionalExpression)parent).getThenExpression();
            final PsiExpression elseExpression = ((PsiConditionalExpression)parent).getElseExpression();
            PsiType[] paramTypes = new PsiType[]{((PsiMethod)typeParameter.getOwner()).getReturnType()};
            if (methodCall.equals(PsiUtil.skipParenthesizedExprDown(elseExpression)) && thenExpression != null) {
                PsiType thenType = ourGraphGuard.doPreventingRecursion(parent, true, new Computable<PsiType>(){

                    @Override
                    public PsiType compute() {
                        return thenExpression.getType();
                    }
                });
                if (thenType != null) {
                    pair = this.inferTypeForMethodTypeParameterInner(typeParameter, paramTypes, new PsiType[]{thenType}, substitutor, null, policy);
                }
            } else if (methodCall.equals(PsiUtil.skipParenthesizedExprDown(thenExpression)) && elseExpression != null && (elseType = ourGraphGuard.doPreventingRecursion(parent, true, new Computable<PsiType>(){

                @Override
                public PsiType compute() {
                    return elseExpression.getType();
                }
            })) != null) {
                pair = this.inferTypeForMethodTypeParameterInner(typeParameter, paramTypes, new PsiType[]{elseType}, substitutor, null, policy);
            }
        }
        return pair;
    }

    private static Pair<PsiType, ConstraintType> graphInferenceFromCallContext(final @NotNull PsiExpression methodCall, final @NotNull PsiTypeParameter typeParameter, final @NotNull PsiCallExpression parentCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "graphInferenceFromCallContext"));
        }
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "graphInferenceFromCallContext"));
        }
        if (parentCall == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "graphInferenceFromCallContext"));
        }
        if (Registry.is("disable.graph.inference", false)) {
            return null;
        }
        final PsiExpressionList argumentList = parentCall.getArgumentList();
        if (PsiDiamondType.ourDiamondGuard.currentStack().contains(parentCall)) {
            PsiDiamondType.ourDiamondGuard.prohibitResultCaching(parentCall);
            return FAILED_INFERENCE;
        }
        return ourGraphGuard.doPreventingRecursion(methodCall, true, new Computable<Pair<PsiType, ConstraintType>>(){

            @Override
            public Pair<PsiType, ConstraintType> compute() {
                return GRAPH_INFERENCE_POLICY.inferTypeConstraintFromCallContext(methodCall, argumentList, parentCall, typeParameter);
            }
        });
    }
}

