/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.test;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsNew;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.JetTestFunctionDetector;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.reference.ReferenceTranslator;
import org.jetbrains.k2js.translate.test.JSTester;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

public final class JSTestGenerator {
    private JSTestGenerator() {
    }

    public static void generateTestCalls(@NotNull TranslationContext context, @NotNull Collection<JetFile> files, @NotNull JSTester tester) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/test/JSTestGenerator", "generateTestCalls"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/test/JSTestGenerator", "generateTestCalls"));
        }
        if (tester == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/test/JSTestGenerator", "generateTestCalls"));
        }
        List<FunctionDescriptor> functionDescriptors = JetTestFunctionDetector.getTestFunctionDescriptors(context.bindingContext(), files);
        JSTestGenerator.doGenerateTestCalls(functionDescriptors, context, tester);
    }

    private static void doGenerateTestCalls(@NotNull List<FunctionDescriptor> functionDescriptors, @NotNull TranslationContext context, @NotNull JSTester jsTester) {
        if (functionDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/test/JSTestGenerator", "doGenerateTestCalls"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/test/JSTestGenerator", "doGenerateTestCalls"));
        }
        if (jsTester == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/test/JSTestGenerator", "doGenerateTestCalls"));
        }
        for (FunctionDescriptor functionDescriptor : functionDescriptors) {
            ClassDescriptor classDescriptor = JsDescriptorUtils.getContainingClass(functionDescriptor);
            if (classDescriptor == null) {
                return;
            }
            JSTestGenerator.generateCodeForTestMethod(context, functionDescriptor, classDescriptor, jsTester);
        }
    }

    private static void generateCodeForTestMethod(@NotNull TranslationContext context, @NotNull FunctionDescriptor functionDescriptor, @NotNull ClassDescriptor classDescriptor, @NotNull JSTester tester) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/test/JSTestGenerator", "generateCodeForTestMethod"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/test/JSTestGenerator", "generateCodeForTestMethod"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/test/JSTestGenerator", "generateCodeForTestMethod"));
        }
        if (tester == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/k2js/translate/test/JSTestGenerator", "generateCodeForTestMethod"));
        }
        JsExpression expression = ReferenceTranslator.translateAsFQReference(classDescriptor, context);
        JsNew testClass = new JsNew(expression);
        JsExpression functionToTestCall = CallBuilder.build(context).descriptor(functionDescriptor).receiver(testClass).translate();
        JsStringLiteral testName = context.program().getStringLiteral(classDescriptor.getName() + "." + functionDescriptor.getName());
        tester.constructTestMethodInvocation(functionToTestCall, testName);
    }
}

