/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.DescriptorFactory;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.CachedAccessTranslator;
import org.jetbrains.k2js.translate.reference.CachedPropertyAccessTranslator;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.reference.PropertyAccessTranslator;

public final class KotlinPropertyAccessTranslator
extends PropertyAccessTranslator {
    @Nullable
    private final JsExpression receiver;
    @NotNull
    private final PropertyDescriptor propertyDescriptor;
    @NotNull
    private final ResolvedCall<?> resolvedCall;

    KotlinPropertyAccessTranslator(@NotNull PropertyDescriptor descriptor, @Nullable JsExpression receiver, @NotNull ResolvedCall<?> resolvedCall, @NotNull TranslationContext context) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/KotlinPropertyAccessTranslator", "<init>"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/reference/KotlinPropertyAccessTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/k2js/translate/reference/KotlinPropertyAccessTranslator", "<init>"));
        }
        super(context);
        this.receiver = receiver;
        this.propertyDescriptor = descriptor.getOriginal();
        this.resolvedCall = resolvedCall;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        JsExpression jsExpression = this.translateAsGet(this.receiver);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/KotlinPropertyAccessTranslator", "translateAsGet"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet(@Nullable JsExpression receiver) {
        PropertyGetterDescriptor getter = this.propertyDescriptor.getGetter();
        if (getter == null) {
            PropertyGetterDescriptorImpl getterImpl = DescriptorFactory.createDefaultGetter(this.propertyDescriptor);
            getterImpl.initialize(this.propertyDescriptor.getType());
            ((PropertyDescriptorImpl)this.propertyDescriptor).initialize(getterImpl, null);
            getter = getterImpl;
        }
        assert (getter != null) : "Getter for kotlin properties should bot be null.";
        JsExpression jsExpression = this.callBuilderForAccessor(receiver).descriptor(getter).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/KotlinPropertyAccessTranslator", "translateAsGet"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression toSetTo) {
        if (toSetTo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/KotlinPropertyAccessTranslator", "translateAsSet"));
        }
        JsExpression jsExpression = this.translateAsSet(this.receiver, toSetTo);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/KotlinPropertyAccessTranslator", "translateAsSet"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@Nullable JsExpression receiver, @NotNull JsExpression toSetTo) {
        if (toSetTo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/reference/KotlinPropertyAccessTranslator", "translateAsSet"));
        }
        PropertySetterDescriptor setter = this.propertyDescriptor.getSetter();
        assert (setter != null) : "Setter for kotlin properties should not be null.";
        JsExpression jsExpression = this.callBuilderForAccessor(receiver).args(toSetTo).descriptor(setter).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/KotlinPropertyAccessTranslator", "translateAsSet"));
        }
        return jsExpression;
    }

    @NotNull
    private CallBuilder callBuilderForAccessor(@Nullable JsExpression qualifier) {
        CallBuilder callBuilder = CallBuilder.build(this.context()).receiver(qualifier).resolvedCall(this.resolvedCall).type(this.getCallType());
        if (callBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/KotlinPropertyAccessTranslator", "callBuilderForAccessor"));
        }
        return callBuilder;
    }

    @Override
    @NotNull
    public CachedAccessTranslator getCached() {
        CachedPropertyAccessTranslator cachedPropertyAccessTranslator = new CachedPropertyAccessTranslator(this.receiver, this, this.context());
        if (cachedPropertyAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/KotlinPropertyAccessTranslator", "getCached"));
        }
        return cachedPropertyAccessTranslator;
    }
}

