/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetDotQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSafeQualifiedExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public abstract class CallType
extends Enum<CallType> {
    public static final /* enum */ CallType SAFE = new CallType(){

        @Override
        @NotNull
        JsExpression constructCall(@Nullable JsExpression receiver, @NotNull CallConstructor constructor, @NotNull TranslationContext context) {
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/reference/CallType$1", "constructCall"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/reference/CallType$1", "constructCall"));
            }
            assert (receiver != null);
            JsConditional expression = TranslationUtils.notNullConditional(receiver, JsLiteral.NULL, context);
            expression.setThenExpression(constructor.construct(expression.getThenExpression()));
            JsConditional jsConditional = expression;
            if (jsConditional == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallType$1", "constructCall"));
            }
            return jsConditional;
        }
    };
    public static final /* enum */ CallType NORMAL = new CallType(){

        @Override
        @NotNull
        JsExpression constructCall(@Nullable JsExpression receiver, @NotNull CallConstructor constructor, @NotNull TranslationContext context) {
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/reference/CallType$2", "constructCall"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/reference/CallType$2", "constructCall"));
            }
            JsExpression jsExpression = constructor.construct(receiver);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallType$2", "constructCall"));
            }
            return jsExpression;
        }
    };
    private static final /* synthetic */ CallType[] $VALUES;

    public static CallType[] values() {
        return (CallType[])$VALUES.clone();
    }

    public static CallType valueOf(String name) {
        return Enum.valueOf(CallType.class, name);
    }

    @NotNull
    abstract JsExpression constructCall(@Nullable JsExpression var1, @NotNull CallConstructor var2, @NotNull TranslationContext var3);

    @NotNull
    public static CallType getCallTypeForQualifiedExpression(@NotNull JetQualifiedExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/CallType", "getCallTypeForQualifiedExpression"));
        }
        if (expression instanceof JetSafeQualifiedExpression) {
            CallType callType = SAFE;
            if (callType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallType", "getCallTypeForQualifiedExpression"));
            }
            return callType;
        }
        assert (expression instanceof JetDotQualifiedExpression);
        CallType callType = NORMAL;
        if (callType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallType", "getCallTypeForQualifiedExpression"));
        }
        return callType;
    }

    static {
        $VALUES = new CallType[]{SAFE, NORMAL};
    }

    public static interface CallConstructor {
        @NotNull
        public JsExpression construct(@Nullable JsExpression var1);
    }
}

