/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.CachedAccessTranslator;
import org.jetbrains.k2js.translate.reference.PropertyAccessTranslator;

public final class CachedPropertyAccessTranslator
implements CachedAccessTranslator {
    @NotNull
    private final PropertyAccessTranslator baseTranslator;
    @Nullable
    private final TemporaryVariable cachedReceiver;

    CachedPropertyAccessTranslator(@Nullable JsExpression receiverExpression, @NotNull PropertyAccessTranslator baseTranslator, @NotNull TranslationContext context) {
        if (baseTranslator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/reference/CachedPropertyAccessTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/reference/CachedPropertyAccessTranslator", "<init>"));
        }
        this.cachedReceiver = receiverExpression != null ? context.declareTemporary(receiverExpression) : null;
        this.baseTranslator = baseTranslator;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        JsExpression jsExpression = this.baseTranslator.translateAsGet(this.receiverOrNull());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CachedPropertyAccessTranslator", "translateAsGet"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression toSetTo) {
        if (toSetTo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/CachedPropertyAccessTranslator", "translateAsSet"));
        }
        JsExpression jsExpression = this.baseTranslator.translateAsSet(this.receiverOrNull(), toSetTo);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CachedPropertyAccessTranslator", "translateAsSet"));
        }
        return jsExpression;
    }

    @Nullable
    private JsNameRef receiverOrNull() {
        return this.cachedReceiver != null ? this.cachedReceiver.reference() : null;
    }

    @Override
    @NotNull
    public CachedAccessTranslator getCached() {
        CachedPropertyAccessTranslator cachedPropertyAccessTranslator = this;
        if (cachedPropertyAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CachedPropertyAccessTranslator", "getCached"));
        }
        return cachedPropertyAccessTranslator;
    }

    @Override
    @NotNull
    public List<TemporaryVariable> declaredTemporaries() {
        List<TemporaryVariable> list = this.cachedReceiver != null ? Collections.singletonList(this.cachedReceiver) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CachedPropertyAccessTranslator", "declaredTemporaries"));
        }
        return list;
    }
}

