/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.utils;

import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.utils.WrappedValues;

public abstract class NullableMemoizedFunction<K, V>
implements NullableFunction<K, V> {
    private final Map<K, Object> cache;

    public static <K, V> NullableFunction<K, V> create(final @NotNull Function<K, V> compute) {
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/utils/NullableMemoizedFunction", "create"));
        }
        return new NullableMemoizedFunction<K, V>(){

            @Override
            @Nullable
            protected V compute(@NotNull K input) {
                if (input == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/utils/NullableMemoizedFunction$1", "compute"));
                }
                return compute.fun(input);
            }
        };
    }

    public NullableMemoizedFunction(@NotNull Map<K, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/utils/NullableMemoizedFunction", "<init>"));
        }
        this.cache = map;
    }

    public NullableMemoizedFunction() {
        this(new HashMap());
    }

    @Override
    @Nullable
    public V fun(@NotNull K input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/utils/NullableMemoizedFunction", "fun"));
        }
        Object value = this.cache.get(input);
        if (value != null) {
            return WrappedValues.unescapeNull(value);
        }
        V typedValue = this.compute(input);
        Object oldValue = this.cache.put(input, WrappedValues.escapeNull(typedValue));
        assert (oldValue == null) : "Race condition detected";
        return typedValue;
    }

    @Nullable
    protected abstract V compute(@NotNull K var1);
}

