/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.utils;

import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryUtils {
    public static final String VENDOR_JETBRAINS = "JetBrains";
    public static final String TITLE_KOTLIN_RUNTIME_AND_STDLIB = "Kotlin Compiler Runtime + StdLib";
    public static final String TITLE_KOTLIN_RUNTIME_AND_STDLIB_SOURCES = "Kotlin Compiler Runtime + StdLib Sources";
    public static final String TITLE_KOTLIN_JAVASCRIPT_STDLIB = "Kotlin JavaScript StdLib";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Manifest getManifestFromJar(@NotNull File library) {
        Manifest manifest;
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/utils/LibraryUtils", "getManifestFromJar"));
        }
        if (!library.canRead()) {
            return null;
        }
        JarFile jarFile = new JarFile(library);
        try {
            manifest = jarFile.getManifest();
        }
        catch (Throwable throwable) {
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        jarFile.close();
        return manifest;
    }

    @Nullable
    public static Attributes getManifestMainAttributesFromJar(@NotNull File library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/utils/LibraryUtils", "getManifestMainAttributesFromJar"));
        }
        Manifest manifest = LibraryUtils.getManifestFromJar(library);
        return manifest != null ? manifest.getMainAttributes() : null;
    }

    private static boolean checkImplTitle(@NotNull File library, String expected) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/utils/LibraryUtils", "checkImplTitle"));
        }
        Attributes attributes = LibraryUtils.getManifestMainAttributesFromJar(library);
        if (attributes == null) {
            return false;
        }
        String title = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        return title != null && title.equals(expected);
    }

    public static boolean isJsRuntimeLibrary(@NotNull File library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/utils/LibraryUtils", "isJsRuntimeLibrary"));
        }
        return LibraryUtils.checkImplTitle(library, TITLE_KOTLIN_JAVASCRIPT_STDLIB);
    }

    public static boolean isJvmRuntimeLibrary(@NotNull File library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/utils/LibraryUtils", "isJvmRuntimeLibrary"));
        }
        return LibraryUtils.checkImplTitle(library, TITLE_KOTLIN_RUNTIME_AND_STDLIB);
    }
}

