/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.name;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.name.FqNameBase;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class FqName
extends FqNameBase {
    public static final FqName ROOT = new FqName("");
    @NotNull
    private final FqNameUnsafe fqName;
    private transient FqName parent;

    @NotNull
    public static FqName fromSegments(@NotNull List<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/name/FqName", "fromSegments"));
        }
        String fqName = StringUtil.join(names, ".");
        FqName fqName2 = new FqName(fqName);
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/FqName", "fromSegments"));
        }
        return fqName2;
    }

    public FqName(@NotNull String fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/name/FqName", "<init>"));
        }
        this.fqName = new FqNameUnsafe(fqName, this);
        this.validateFqName();
    }

    public FqName(@NotNull FqNameUnsafe fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/name/FqName", "<init>"));
        }
        this.fqName = fqName;
        this.validateFqName();
    }

    private FqName(@NotNull FqNameUnsafe fqName, FqName parent) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/name/FqName", "<init>"));
        }
        this.fqName = fqName;
        this.parent = parent;
        this.validateFqName();
    }

    private void validateFqName() {
        if (!FqName.isValidAfterUnsafeCheck(this.fqName.asString())) {
            throw new IllegalArgumentException("incorrect fq name: " + this.fqName);
        }
    }

    static boolean isValidAfterUnsafeCheck(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/name/FqName", "isValidAfterUnsafeCheck"));
        }
        return qualifiedName.indexOf(60) < 0;
    }

    @Override
    @NotNull
    public String asString() {
        String string = this.fqName.asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/FqName", "asString"));
        }
        return string;
    }

    @NotNull
    public FqNameUnsafe toUnsafe() {
        FqNameUnsafe fqNameUnsafe = this.fqName;
        if (fqNameUnsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/FqName", "toUnsafe"));
        }
        return fqNameUnsafe;
    }

    public boolean isRoot() {
        return this.fqName.isRoot();
    }

    @NotNull
    public FqName parent() {
        if (this.parent != null) {
            FqName fqName = this.parent;
            if (fqName == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/FqName", "parent"));
            }
            return fqName;
        }
        if (this.isRoot()) {
            throw new IllegalStateException("root");
        }
        FqName fqName = this.parent = new FqName(this.fqName.parent());
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/FqName", "parent"));
        }
        return fqName;
    }

    @NotNull
    public FqName child(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/name/FqName", "child"));
        }
        FqName fqName = new FqName(this.fqName.child(name), this);
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/FqName", "child"));
        }
        return fqName;
    }

    @NotNull
    public Name shortName() {
        Name name = this.fqName.shortName();
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/FqName", "shortName"));
        }
        return name;
    }

    @NotNull
    public Name shortNameOrSpecial() {
        Name name = this.fqName.shortNameOrSpecial();
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/FqName", "shortNameOrSpecial"));
        }
        return name;
    }

    @NotNull
    public List<FqName> path() {
        final ArrayList<FqName> path = Lists.newArrayList();
        path.add(ROOT);
        this.fqName.walk(new FqNameUnsafe.WalkCallback(){

            @Override
            public void segment(@NotNull Name shortName, @NotNull FqNameUnsafe fqName) {
                if (shortName == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/name/FqName$1", "segment"));
                }
                if (fqName == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/name/FqName$1", "segment"));
                }
                path.add(new FqName(fqName));
            }
        });
        ArrayList<FqName> arrayList = path;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/FqName", "path"));
        }
        return arrayList;
    }

    @NotNull
    public List<Name> pathSegments() {
        List<Name> list = this.fqName.pathSegments();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/FqName", "pathSegments"));
        }
        return list;
    }

    public boolean firstSegmentIs(@NotNull Name segment) {
        if (segment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/name/FqName", "firstSegmentIs"));
        }
        return this.fqName.firstSegmentIs(segment);
    }

    public boolean lastSegmentIs(@NotNull Name segment) {
        if (segment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/name/FqName", "lastSegmentIs"));
        }
        return this.fqName.lastSegmentIs(segment);
    }

    @NotNull
    public static FqName topLevel(@NotNull Name shortName) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/name/FqName", "topLevel"));
        }
        FqName fqName = new FqName(FqNameUnsafe.topLevel(shortName));
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/FqName", "topLevel"));
        }
        return fqName;
    }

    public String toString() {
        return this.fqName.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FqName)) {
            return false;
        }
        FqName otherFqName = (FqName)o;
        return this.fqName.equals(otherFqName.fqName);
    }

    public int hashCode() {
        return this.fqName.hashCode();
    }
}

