/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotationArgument;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaAnnotationAsAnnotationArgumentImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaArrayAnnotationArgumentImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassObjectAnnotationArgumentImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaElementImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaLiteralAnnotationArgumentImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaReferenceAnnotationArgumentImpl;
import org.jetbrains.jet.lang.resolve.name.Name;

public abstract class JavaAnnotationArgumentImpl<Psi extends PsiAnnotationMemberValue>
extends JavaElementImpl<Psi>
implements JavaAnnotationArgument {
    private final Name name;

    protected JavaAnnotationArgumentImpl(@NotNull Psi psiAnnotationMemberValue, @Nullable Name name) {
        if (psiAnnotationMemberValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaAnnotationArgumentImpl", "<init>"));
        }
        super(psiAnnotationMemberValue);
        this.name = name;
    }

    @NotNull
    static JavaAnnotationArgument create(@NotNull PsiAnnotationMemberValue argument, @Nullable Name name) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaAnnotationArgumentImpl", "create"));
        }
        Object value = JavaPsiFacade.getInstance(argument.getProject()).getConstantEvaluationHelper().computeConstantExpression(argument);
        if (value != null || argument instanceof PsiLiteralExpression) {
            JavaLiteralAnnotationArgumentImpl javaLiteralAnnotationArgumentImpl = new JavaLiteralAnnotationArgumentImpl(name, value);
            if (javaLiteralAnnotationArgumentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaAnnotationArgumentImpl", "create"));
            }
            return javaLiteralAnnotationArgumentImpl;
        }
        if (argument instanceof PsiReferenceExpression) {
            JavaReferenceAnnotationArgumentImpl javaReferenceAnnotationArgumentImpl = new JavaReferenceAnnotationArgumentImpl((PsiReferenceExpression)argument, name);
            if (javaReferenceAnnotationArgumentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaAnnotationArgumentImpl", "create"));
            }
            return javaReferenceAnnotationArgumentImpl;
        }
        if (argument instanceof PsiArrayInitializerMemberValue) {
            JavaArrayAnnotationArgumentImpl javaArrayAnnotationArgumentImpl = new JavaArrayAnnotationArgumentImpl((PsiArrayInitializerMemberValue)argument, name);
            if (javaArrayAnnotationArgumentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaAnnotationArgumentImpl", "create"));
            }
            return javaArrayAnnotationArgumentImpl;
        }
        if (argument instanceof PsiAnnotation) {
            JavaAnnotationAsAnnotationArgumentImpl javaAnnotationAsAnnotationArgumentImpl = new JavaAnnotationAsAnnotationArgumentImpl((PsiAnnotation)argument, name);
            if (javaAnnotationAsAnnotationArgumentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaAnnotationArgumentImpl", "create"));
            }
            return javaAnnotationAsAnnotationArgumentImpl;
        }
        if (argument instanceof PsiClassObjectAccessExpression) {
            JavaClassObjectAnnotationArgumentImpl javaClassObjectAnnotationArgumentImpl = new JavaClassObjectAnnotationArgumentImpl((PsiClassObjectAccessExpression)argument, name);
            if (javaClassObjectAnnotationArgumentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaAnnotationArgumentImpl", "create"));
            }
            return javaClassObjectAnnotationArgumentImpl;
        }
        throw new UnsupportedOperationException("Unsupported annotation argument type: " + argument);
    }

    @Override
    @Nullable
    public Name getName() {
        return this.name;
    }
}

