/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaMemberResolver;
import org.jetbrains.jet.lang.resolve.java.scope.JavaBaseScope;
import org.jetbrains.jet.lang.resolve.java.scope.MembersProvider;
import org.jetbrains.jet.lang.resolve.java.scope.NamedMembers;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;

public abstract class JavaClassMembersScope
extends JavaBaseScope {
    private Map<Name, ClassDescriptor> innerClassesMap;

    protected JavaClassMembersScope(@NotNull ClassOrNamespaceDescriptor descriptor, @NotNull MembersProvider membersProvider, @NotNull JavaMemberResolver memberResolver) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassMembersScope", "<init>"));
        }
        if (membersProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassMembersScope", "<init>"));
        }
        if (memberResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassMembersScope", "<init>"));
        }
        super(descriptor, memberResolver, membersProvider);
        this.innerClassesMap = null;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(LabelName labelName) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected Set<FunctionDescriptor> computeFunctionDescriptor(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassMembersScope", "computeFunctionDescriptor"));
        }
        NamedMembers members = this.membersProvider.get(name);
        if (members == null) {
            Set<FunctionDescriptor> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassMembersScope", "computeFunctionDescriptor"));
            }
            return set;
        }
        Set<FunctionDescriptor> set = this.memberResolver.resolveFunctionGroupForClass(members, this.descriptor);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassMembersScope", "computeFunctionDescriptor"));
        }
        return set;
    }

    @NotNull
    private Map<Name, ClassDescriptor> getInnerClassesMap() {
        if (this.innerClassesMap == null) {
            Collection<ClassDescriptor> innerClasses = this.getInnerClasses();
            this.innerClassesMap = new HashMap<Name, ClassDescriptor>();
            for (ClassDescriptor innerClass : innerClasses) {
                this.innerClassesMap.put(innerClass.getName(), innerClass);
            }
        }
        Map<Name, ClassDescriptor> map = this.innerClassesMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassMembersScope", "getInnerClassesMap"));
        }
        return map;
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassMembersScope", "getObjectDescriptor"));
        }
        ClassDescriptor innerClass = this.getInnerClassesMap().get(name);
        if (innerClass != null && innerClass.getKind().isObject()) {
            return innerClass;
        }
        return null;
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassMembersScope", "getClassifier"));
        }
        ClassDescriptor innerClass = this.getInnerClassesMap().get(name);
        if (innerClass == null || innerClass.getKind().isObject()) {
            return null;
        }
        return innerClass;
    }
}

