/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.mapping;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMapBuilder;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;

public class KotlinToJavaTypesMap
extends JavaToKotlinClassMapBuilder {
    private static KotlinToJavaTypesMap instance = null;
    private final Map<FqName, Type> asmTypes = new HashMap<FqName, Type>();
    private final Map<FqName, Type> asmNullableTypes = new HashMap<FqName, Type>();

    @NotNull
    public static KotlinToJavaTypesMap getInstance() {
        if (instance == null) {
            instance = new KotlinToJavaTypesMap();
        }
        KotlinToJavaTypesMap kotlinToJavaTypesMap = instance;
        if (kotlinToJavaTypesMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "getInstance"));
        }
        return kotlinToJavaTypesMap;
    }

    private KotlinToJavaTypesMap() {
        this.init();
        this.initPrimitives();
    }

    private void initPrimitives() {
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            FqName className = jvmPrimitiveType.getPrimitiveType().getClassName();
            this.register(className, jvmPrimitiveType.getAsmType());
            this.registerNullable(className, jvmPrimitiveType.getWrapper().getAsmType());
        }
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            PrimitiveType primitiveType = jvmPrimitiveType.getPrimitiveType();
            this.register(primitiveType.getArrayClassName(), jvmPrimitiveType.getAsmArrayType());
        }
    }

    @Nullable
    public Type getJavaAnalog(@NotNull JetType jetType) {
        Type nullableType;
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "getJavaAnalog"));
        }
        ClassifierDescriptor classifier = jetType.getConstructor().getDeclarationDescriptor();
        assert (classifier != null);
        FqNameUnsafe className = DescriptorUtils.getFQName(classifier);
        if (!className.isSafe()) {
            return null;
        }
        FqName fqName = className.toSafe();
        if (jetType.isNullable() && (nullableType = this.asmNullableTypes.get(fqName)) != null) {
            return nullableType;
        }
        return this.asmTypes.get(fqName);
    }

    @Override
    protected void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull JavaToKotlinClassMapBuilder.Direction direction) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "register"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "register"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "register"));
        }
        if (direction == JavaToKotlinClassMapBuilder.Direction.BOTH || direction == JavaToKotlinClassMapBuilder.Direction.KOTLIN_TO_JAVA) {
            this.register(kotlinDescriptor, AsmTypeConstants.getType(javaClass));
        }
    }

    @Override
    protected void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull ClassDescriptor kotlinMutableDescriptor, @NotNull JavaToKotlinClassMapBuilder.Direction direction) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "register"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "register"));
        }
        if (kotlinMutableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "register"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "register"));
        }
        if (direction == JavaToKotlinClassMapBuilder.Direction.BOTH || direction == JavaToKotlinClassMapBuilder.Direction.KOTLIN_TO_JAVA) {
            this.register(javaClass, kotlinDescriptor);
            this.register(javaClass, kotlinMutableDescriptor);
        }
    }

    private void register(@NotNull ClassDescriptor kotlinDescriptor, @NotNull Type javaType) {
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "register"));
        }
        if (javaType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "register"));
        }
        FqNameUnsafe fqName = DescriptorUtils.getFQName(kotlinDescriptor);
        assert (fqName.isSafe());
        this.register(fqName.toSafe(), javaType);
    }

    private void register(@NotNull FqName fqName, @NotNull Type type) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "register"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "register"));
        }
        this.asmTypes.put(fqName, type);
    }

    private void registerNullable(@NotNull FqName fqName, @NotNull Type nullableType) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "registerNullable"));
        }
        if (nullableType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "registerNullable"));
        }
        this.asmNullableTypes.put(fqName, nullableType);
    }
}

