/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class PackageClassUtils {
    public static final String PACKAGE_CLASS_NAME_SUFFIX = "Package";

    private PackageClassUtils() {
    }

    public static String getPackageClassName(@NotNull FqName packageFQN) {
        if (packageFQN == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/PackageClassUtils", "getPackageClassName"));
        }
        if (packageFQN.isRoot()) {
            return "_DefaultPackage";
        }
        return StringUtil.capitalize(packageFQN.shortName().asString()) + PACKAGE_CLASS_NAME_SUFFIX;
    }

    public static FqName getPackageClassFqName(@NotNull FqName packageFQN) {
        if (packageFQN == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/PackageClassUtils", "getPackageClassFqName"));
        }
        return packageFQN.child(Name.identifier(PackageClassUtils.getPackageClassName(packageFQN)));
    }

    public static boolean isPackageClassFqName(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/PackageClassUtils", "isPackageClassFqName"));
        }
        if (fqName.isRoot()) {
            return false;
        }
        return PackageClassUtils.getPackageClassFqName(fqName.parent()).equals(fqName);
    }
}

