/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class JvmClassName {
    private final String internalName;
    private FqName fqName;
    private String descriptor;
    private String signatureName;
    private Type asmType;

    @NotNull
    public static JvmClassName byInternalName(@NotNull String internalName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byInternalName"));
        }
        JvmClassName jvmClassName = new JvmClassName(internalName);
        if (jvmClassName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byInternalName"));
        }
        return jvmClassName;
    }

    @NotNull
    public static JvmClassName byType(@NotNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byType"));
        }
        if (type.getSort() != 10) {
            throw new IllegalArgumentException("Type is not convertible to " + JvmClassName.class.getSimpleName() + ": " + type);
        }
        JvmClassName jvmClassName = JvmClassName.byInternalName(type.getInternalName());
        if (jvmClassName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byType"));
        }
        return jvmClassName;
    }

    @NotNull
    public static JvmClassName byFqNameWithoutInnerClasses(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byFqNameWithoutInnerClasses"));
        }
        JvmClassName r = new JvmClassName(JvmClassName.fqNameToInternalName(fqName));
        r.fqName = fqName;
        JvmClassName jvmClassName = r;
        if (jvmClassName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byFqNameWithoutInnerClasses"));
        }
        return jvmClassName;
    }

    @NotNull
    public static JvmClassName byFqNameWithoutInnerClasses(@NotNull String fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byFqNameWithoutInnerClasses"));
        }
        JvmClassName jvmClassName = JvmClassName.byFqNameWithoutInnerClasses(new FqName(fqName));
        if (jvmClassName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byFqNameWithoutInnerClasses"));
        }
        return jvmClassName;
    }

    @NotNull
    public static JvmClassName byClass(@NotNull Class<?> klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byClass"));
        }
        JvmClassName jvmClassName = JvmClassName.byFqNameWithoutInnerClasses(new FqName(klass.getCanonicalName()));
        if (jvmClassName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byClass"));
        }
        return jvmClassName;
    }

    @NotNull
    public static JvmClassName bySignatureName(@NotNull String signatureName) {
        if (signatureName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "bySignatureName"));
        }
        JvmClassName className = new JvmClassName(JvmClassName.signatureNameToInternalName(signatureName));
        className.signatureName = signatureName;
        JvmClassName jvmClassName = className;
        if (jvmClassName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "bySignatureName"));
        }
        return jvmClassName;
    }

    private static String encodeSpecialNames(String str) {
        String encodedObjectNames = StringUtil.replace(str, "object", "<class_object>");
        return StringUtil.replace(encodedObjectNames, "$TImpl", "<trait_impl>");
    }

    private static String decodeSpecialNames(String str) {
        String decodedObjectNames = StringUtil.replace(str, "<class_object>", "object");
        return StringUtil.replace(decodedObjectNames, "<trait_impl>", "$TImpl");
    }

    @NotNull
    private static JvmClassName byFqNameAndInnerClassList(@NotNull FqName fqName, @NotNull List<String> innerClassList) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byFqNameAndInnerClassList"));
        }
        if (innerClassList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byFqNameAndInnerClassList"));
        }
        String outerClassName = JvmClassName.fqNameToInternalName(fqName);
        StringBuilder sb = new StringBuilder(outerClassName);
        for (String innerClassName : innerClassList) {
            sb.append("$").append(innerClassName);
        }
        JvmClassName jvmClassName = new JvmClassName(sb.toString());
        if (jvmClassName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byFqNameAndInnerClassList"));
        }
        return jvmClassName;
    }

    @NotNull
    public static JvmClassName byClassDescriptor(@NotNull ClassifierDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byClassDescriptor"));
        }
        DeclarationDescriptor descriptor = classDescriptor;
        ArrayList<String> innerClassNames = new ArrayList<String>();
        while (descriptor.getContainingDeclaration() instanceof ClassDescriptor) {
            innerClassNames.add(descriptor.getName().asString());
            descriptor = descriptor.getContainingDeclaration();
            assert (descriptor != null);
        }
        JvmClassName jvmClassName = JvmClassName.byFqNameAndInnerClassList(DescriptorUtils.getFQName(descriptor).toSafe(), innerClassNames);
        if (jvmClassName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byClassDescriptor"));
        }
        return jvmClassName;
    }

    @NotNull
    private static String fqNameToInternalName(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "fqNameToInternalName"));
        }
        String string = fqName.asString().replace('.', '/');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "fqNameToInternalName"));
        }
        return string;
    }

    @NotNull
    private static String signatureNameToInternalName(@NotNull String signatureName) {
        if (signatureName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "signatureNameToInternalName"));
        }
        String string = signatureName.replace('.', '$');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "signatureNameToInternalName"));
        }
        return string;
    }

    @NotNull
    private static String internalNameToFqName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "internalNameToFqName"));
        }
        String string = JvmClassName.decodeSpecialNames(JvmClassName.encodeSpecialNames(name).replace('$', '.').replace('/', '.'));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "internalNameToFqName"));
        }
        return string;
    }

    @NotNull
    private static String internalNameToSignatureName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "internalNameToSignatureName"));
        }
        String string = JvmClassName.decodeSpecialNames(JvmClassName.encodeSpecialNames(name).replace('$', '.'));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "internalNameToSignatureName"));
        }
        return string;
    }

    @NotNull
    private static String signatureNameToFqName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "signatureNameToFqName"));
        }
        String string = name.replace('/', '.');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "signatureNameToFqName"));
        }
        return string;
    }

    private JvmClassName(@NotNull String internalName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "<init>"));
        }
        this.internalName = internalName;
    }

    @NotNull
    public FqName getFqName() {
        if (this.fqName == null) {
            this.fqName = new FqName(JvmClassName.internalNameToFqName(this.internalName));
        }
        FqName fqName = this.fqName;
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "getFqName"));
        }
        return fqName;
    }

    @NotNull
    public String getInternalName() {
        String string = this.internalName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "getInternalName"));
        }
        return string;
    }

    @NotNull
    public String getDescriptor() {
        if (this.descriptor == null) {
            StringBuilder sb = new StringBuilder(this.internalName.length() + 2);
            sb.append('L');
            sb.append(this.internalName);
            sb.append(';');
            this.descriptor = sb.toString();
        }
        String string = this.descriptor;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "getDescriptor"));
        }
        return string;
    }

    @NotNull
    public Type getAsmType() {
        if (this.asmType == null) {
            this.asmType = Type.getType(this.getDescriptor());
        }
        Type type = this.asmType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "getAsmType"));
        }
        return type;
    }

    @NotNull
    public String getSignatureName() {
        if (this.signatureName == null) {
            this.signatureName = JvmClassName.internalNameToSignatureName(this.internalName);
        }
        String string = this.signatureName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "getSignatureName"));
        }
        return string;
    }

    @NotNull
    public FqName getOuterClassFqName() {
        String signatureName = this.getSignatureName();
        int index = signatureName.indexOf(46);
        String outerClassName = index != -1 ? signatureName.substring(0, index) : signatureName;
        FqName fqName = new FqName(JvmClassName.signatureNameToFqName(outerClassName));
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "getOuterClassFqName"));
        }
        return fqName;
    }

    @NotNull
    public List<String> getInnerClassNameList() {
        ArrayList<String> innerClassList = new ArrayList<String>();
        String signatureName = this.getSignatureName();
        int index = signatureName.indexOf(46);
        while (index != -1) {
            int nextIndex = signatureName.indexOf(46, index + 1);
            String innerClassName = nextIndex != -1 ? signatureName.substring(index + 1, nextIndex) : signatureName.substring(index + 1);
            innerClassList.add(innerClassName);
            index = nextIndex;
        }
        ArrayList<String> arrayList = innerClassList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "getInnerClassNameList"));
        }
        return arrayList;
    }

    public String toString() {
        return this.getInternalName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JvmClassName name = (JvmClassName)o;
        return this.internalName.equals(name.internalName);
    }

    public int hashCode() {
        return this.internalName.hashCode();
    }
}

