/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.types.JetType;

public class InferenceErrorData {
    @NotNull
    public final CallableDescriptor descriptor;
    @NotNull
    public final ConstraintSystem constraintSystem;

    private InferenceErrorData(@NotNull CallableDescriptor descriptor, @NotNull ConstraintSystem constraintSystem) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/InferenceErrorData", "<init>"));
        }
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/inference/InferenceErrorData", "<init>"));
        }
        this.descriptor = descriptor;
        this.constraintSystem = constraintSystem;
    }

    public static ExtendedInferenceErrorData create(@NotNull CallableDescriptor descriptor, @NotNull ConstraintSystem constraintSystem, @NotNull List<JetType> valueArgumentsTypes, @Nullable JetType receiverArgumentType, @NotNull JetType expectedType) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/InferenceErrorData", "create"));
        }
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/inference/InferenceErrorData", "create"));
        }
        if (valueArgumentsTypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/inference/InferenceErrorData", "create"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/resolve/calls/inference/InferenceErrorData", "create"));
        }
        return new ExtendedInferenceErrorData(descriptor, constraintSystem, valueArgumentsTypes, receiverArgumentType, expectedType);
    }

    public static InferenceErrorData create(@NotNull CallableDescriptor descriptor, @NotNull ConstraintSystem constraintSystem) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/InferenceErrorData", "create"));
        }
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/inference/InferenceErrorData", "create"));
        }
        return new InferenceErrorData(descriptor, constraintSystem);
    }

    public static class ExtendedInferenceErrorData
    extends InferenceErrorData {
        @Nullable
        public final JetType receiverArgumentType;
        @NotNull
        public final JetType expectedType;
        @NotNull
        public final List<JetType> valueArgumentsTypes;

        private ExtendedInferenceErrorData(@NotNull CallableDescriptor descriptor, @NotNull ConstraintSystem constraintSystem, @NotNull List<JetType> valueArgumentsTypes, @Nullable JetType receiverArgumentType, @NotNull JetType expectedType) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/InferenceErrorData$ExtendedInferenceErrorData", "<init>"));
            }
            if (constraintSystem == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/inference/InferenceErrorData$ExtendedInferenceErrorData", "<init>"));
            }
            if (valueArgumentsTypes == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/inference/InferenceErrorData$ExtendedInferenceErrorData", "<init>"));
            }
            if (expectedType == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/resolve/calls/inference/InferenceErrorData$ExtendedInferenceErrorData", "<init>"));
            }
            super(descriptor, constraintSystem);
            this.receiverArgumentType = receiverArgumentType;
            this.valueArgumentsTypes = valueArgumentsTypes;
            this.expectedType = expectedType;
        }
    }
}

