/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.calls.CallResolverExtension;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.types.JetType;

public class TypeParameterAsReifiedCheck
implements CallResolverExtension {
    @Override
    public <F extends CallableDescriptor> void run(@NotNull OverloadResolutionResultsImpl<F> results, @NotNull BasicCallResolutionContext context) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/TypeParameterAsReifiedCheck", "run"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/TypeParameterAsReifiedCheck", "run"));
        }
        if (results.isSuccess()) {
            Map<TypeParameterDescriptor, JetType> typeArguments = results.getResultingCall().getTypeArguments();
            for (Map.Entry<TypeParameterDescriptor, JetType> entry : typeArguments.entrySet()) {
                TypeParameterDescriptor parameter = entry.getKey();
                JetType argument = entry.getValue();
                if (!parameter.isReified() || !(argument.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor)) continue;
                JetExpression callee = context.call.getCalleeExpression();
                JetExpression element = callee != null ? callee : context.call.getCallElement();
                context.trace.report(Errors.TYPE_PARAMETER_AS_REIFIED.on(element, typeArguments.keySet().iterator().next()));
            }
        }
    }
}

