/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.ref.JetTypeName;

public class AnalyzerScriptParameter {
    @NotNull
    private final Name name;
    @NotNull
    private final JetTypeName type;

    public AnalyzerScriptParameter(@NotNull Name name, @NotNull JetTypeName type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnalyzerScriptParameter", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/AnalyzerScriptParameter", "<init>"));
        }
        this.name = name;
        this.type = type;
    }

    public AnalyzerScriptParameter(@NotNull String name, @NotNull String type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnalyzerScriptParameter", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/AnalyzerScriptParameter", "<init>"));
        }
        this(Name.identifier(name), JetTypeName.parse(type));
    }

    @NotNull
    public Name getName() {
        Name name = this.name;
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/AnalyzerScriptParameter", "getName"));
        }
        return name;
    }

    @NotNull
    public JetTypeName getType() {
        JetTypeName jetTypeName = this.type;
        if (jetTypeName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/AnalyzerScriptParameter", "getType"));
        }
        return jetTypeName;
    }
}

