/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetCallableDeclaration;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPropertyDelegate;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwnerStub;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVariableDeclaration;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.stubs.PsiJetPropertyStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetPropertyElementType;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lexer.JetTokens;

public class JetProperty
extends JetTypeParameterListOwnerStub<PsiJetPropertyStub>
implements JetCallableDeclaration,
JetVariableDeclaration {
    public JetProperty(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetProperty", "<init>"));
        }
        super(node);
    }

    public JetProperty(@NotNull PsiJetPropertyStub stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetProperty", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/psi/JetProperty", "<init>"));
        }
        super(stub, nodeType);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetProperty", "accept"));
        }
        visitor.visitProperty(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetProperty", "accept"));
        }
        return visitor.visitProperty(this, data);
    }

    @Override
    @NotNull
    public IStubElementType getElementType() {
        JetPropertyElementType jetPropertyElementType = JetStubElementTypes.PROPERTY;
        if (jetPropertyElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetProperty", "getElementType"));
        }
        return jetPropertyElementType;
    }

    @Override
    public boolean isVar() {
        PsiJetPropertyStub stub = (PsiJetPropertyStub)this.getStub();
        if (stub != null) {
            return stub.isVar();
        }
        return this.getNode().findChildByType(JetTokens.VAR_KEYWORD) != null;
    }

    public boolean isLocal() {
        PsiElement parent = this.getParent();
        return !(parent instanceof JetFile) && !(parent instanceof JetClassBody);
    }

    public boolean isTopLevel() {
        PsiJetPropertyStub stub = (PsiJetPropertyStub)this.getStub();
        if (stub != null) {
            return stub.isTopLevel();
        }
        return this.getParent() instanceof JetFile;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        if (this.isLocal()) {
            Object block = PsiTreeUtil.getParentOfType((PsiElement)this, JetBlockExpression.class, JetClassInitializer.class);
            if (block == null) {
                SearchScope searchScope = super.getUseScope();
                if (searchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetProperty", "getUseScope"));
                }
                return searchScope;
            }
            LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)block);
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetProperty", "getUseScope"));
            }
            return localSearchScope;
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetProperty", "getUseScope"));
        }
        return searchScope;
    }

    @Override
    @Nullable
    public JetParameterList getValueParameterList() {
        return null;
    }

    @Override
    @Nullable
    public JetTypeReference getReceiverTypeRef() {
        IElementType tt;
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null && (tt = node.getElementType()) != JetTokens.COLON; node = node.getTreeNext()) {
            if (tt != JetNodeTypes.TYPE_REFERENCE) continue;
            return (JetTypeReference)node.getPsi();
        }
        return null;
    }

    @Override
    @Nullable
    public JetTypeReference getReturnTypeRef() {
        return this.getTypeRef();
    }

    @Override
    @Nullable
    public JetTypeReference getTypeRef() {
        boolean passedColon = false;
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            IElementType tt = node.getElementType();
            if (tt == JetTokens.COLON) {
                passedColon = true;
                continue;
            }
            if (tt != JetNodeTypes.TYPE_REFERENCE || !passedColon) continue;
            return (JetTypeReference)node.getPsi();
        }
        return null;
    }

    @NotNull
    public List<JetPropertyAccessor> getAccessors() {
        List<JetPropertyAccessor> list = this.findChildrenByType(JetNodeTypes.PROPERTY_ACCESSOR);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetProperty", "getAccessors"));
        }
        return list;
    }

    @Nullable
    public JetPropertyAccessor getGetter() {
        for (JetPropertyAccessor accessor : this.getAccessors()) {
            if (!accessor.isGetter()) continue;
            return accessor;
        }
        return null;
    }

    @Nullable
    public JetPropertyAccessor getSetter() {
        for (JetPropertyAccessor accessor : this.getAccessors()) {
            if (!accessor.isSetter()) continue;
            return accessor;
        }
        return null;
    }

    @Nullable
    public JetPropertyDelegate getDelegate() {
        return (JetPropertyDelegate)this.findChildByType(JetNodeTypes.PROPERTY_DELEGATE);
    }

    @Nullable
    public JetExpression getDelegateExpression() {
        JetPropertyDelegate delegate = this.getDelegate();
        if (delegate != null) {
            return delegate.getExpression();
        }
        return null;
    }

    @Override
    @Nullable
    public JetExpression getInitializer() {
        return PsiTreeUtil.getNextSiblingOfType(this.findChildByType(JetTokens.EQ), JetExpression.class);
    }

    @Nullable
    public JetExpression getDelegateExpressionOrInitializer() {
        JetExpression expression = this.getDelegateExpression();
        if (expression == null) {
            return this.getInitializer();
        }
        return expression;
    }

    @Override
    @NotNull
    public ASTNode getValOrVarNode() {
        ASTNode node = this.getNode().findChildByType(TokenSet.create(JetTokens.VAL_KEYWORD, JetTokens.VAR_KEYWORD));
        assert (node != null) : "Val or var should always exist for property";
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetProperty", "getValOrVarNode"));
        }
        return aSTNode;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }
}

