/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class JetNamespaceHeader
extends JetReferenceExpression {
    private String qualifiedNameCache;

    public JetNamespaceHeader(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetNamespaceHeader", "<init>"));
        }
        super(node);
        this.qualifiedNameCache = null;
    }

    @NotNull
    public List<JetSimpleNameExpression> getParentNamespaceNames() {
        List<JetSimpleNameExpression> parentParts = this.findChildrenByType(JetNodeTypes.REFERENCE_EXPRESSION);
        JetSimpleNameExpression lastPart = (JetSimpleNameExpression)this.findLastChildByType(JetNodeTypes.REFERENCE_EXPRESSION);
        parentParts.remove(lastPart);
        List<JetSimpleNameExpression> list = parentParts;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamespaceHeader", "getParentNamespaceNames"));
        }
        return list;
    }

    @Nullable
    public JetSimpleNameExpression getLastPartExpression() {
        return (JetSimpleNameExpression)this.findLastChildByType(JetNodeTypes.REFERENCE_EXPRESSION);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        JetSimpleNameExpression lastPart = (JetSimpleNameExpression)this.findLastChildByType(JetNodeTypes.REFERENCE_EXPRESSION);
        if (lastPart == null) {
            return null;
        }
        return lastPart.getIdentifier();
    }

    @Override
    @NotNull
    public String getName() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        String string = nameIdentifier == null ? "" : nameIdentifier.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamespaceHeader", "getName"));
        }
        return string;
    }

    @NotNull
    public Name getNameAsName() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        Name name = nameIdentifier == null ? DescriptorUtils.ROOT_NAMESPACE_NAME : Name.identifier(nameIdentifier.getText());
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamespaceHeader", "getNameAsName"));
        }
        return name;
    }

    public boolean isRoot() {
        return this.getName().length() == 0;
    }

    @NotNull
    public FqName getFqName() {
        String qualifiedName = this.getQualifiedName();
        FqName fqName = qualifiedName.isEmpty() ? FqName.ROOT : new FqName(qualifiedName);
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamespaceHeader", "getFqName"));
        }
        return fqName;
    }

    @NotNull
    public FqName getParentFqName(JetReferenceExpression nameExpression) {
        String parentQualifiedName = this.getQualifiedNameParentOf(nameExpression);
        FqName fqName = parentQualifiedName.isEmpty() ? FqName.ROOT : new FqName(parentQualifiedName);
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamespaceHeader", "getParentFqName"));
        }
        return fqName;
    }

    @NotNull
    public String getQualifiedName() {
        if (this.qualifiedNameCache == null) {
            this.qualifiedNameCache = this.getQualifiedNameParentOf(null);
        }
        String string = this.qualifiedNameCache;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamespaceHeader", "getQualifiedName"));
        }
        return string;
    }

    @NotNull
    private String getQualifiedNameParentOf(@Nullable JetReferenceExpression nameExpression) {
        StringBuilder builder = new StringBuilder();
        for (JetSimpleNameExpression e : this.findChildrenByClass(JetSimpleNameExpression.class)) {
            if (e == nameExpression) break;
            if (builder.length() > 0) {
                builder.append(".");
            }
            builder.append(e.getReferencedName());
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamespaceHeader", "getQualifiedNameParentOf"));
        }
        return string;
    }

    @Override
    public void subtreeChanged() {
        this.qualifiedNameCache = null;
    }
}

