/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.di;

import com.intellij.openapi.project.Project;
import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.psi.JetImportsFactory;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.QualifiedExpressionResolver;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.jet.lang.resolve.calls.CallExpressionResolver;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.CandidateResolver;
import org.jetbrains.jet.lang.resolve.calls.CompositeExtension;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.ScopeProvider;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;

public class InjectorForLazyResolve {
    private final Project project;
    private final ResolveSession resolveSession;
    private final ModuleDescriptor moduleDescriptor;
    private final DescriptorResolver descriptorResolver;
    private final ExpressionTypingServices expressionTypingServices;
    private final TypeResolver typeResolver;
    private final ScopeProvider scopeProvider;
    private final AnnotationResolver annotationResolver;
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    private final JetImportsFactory jetImportsFactory;
    private final CompositeExtension compositeExtension;
    private final PlatformToKotlinClassMap platformToKotlinClassMap;
    private final CallExpressionResolver callExpressionResolver;
    private final CallResolver callResolver;
    private final ArgumentTypeResolver argumentTypeResolver;
    private final CandidateResolver candidateResolver;

    public InjectorForLazyResolve(@NotNull Project project, @NotNull ResolveSession resolveSession, @NotNull ModuleDescriptor moduleDescriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/di/InjectorForLazyResolve", "<init>"));
        }
        if (resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/di/InjectorForLazyResolve", "<init>"));
        }
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/di/InjectorForLazyResolve", "<init>"));
        }
        this.project = project;
        this.resolveSession = resolveSession;
        this.moduleDescriptor = moduleDescriptor;
        this.descriptorResolver = new DescriptorResolver();
        this.expressionTypingServices = new ExpressionTypingServices();
        this.typeResolver = new TypeResolver();
        this.scopeProvider = new ScopeProvider(resolveSession);
        this.annotationResolver = new AnnotationResolver();
        this.qualifiedExpressionResolver = new QualifiedExpressionResolver();
        this.jetImportsFactory = new JetImportsFactory();
        this.compositeExtension = new CompositeExtension();
        this.platformToKotlinClassMap = moduleDescriptor.getPlatformToKotlinClassMap();
        this.callExpressionResolver = new CallExpressionResolver();
        this.callResolver = new CallResolver();
        this.argumentTypeResolver = new ArgumentTypeResolver();
        this.candidateResolver = new CandidateResolver();
        this.descriptorResolver.setAnnotationResolver(this.annotationResolver);
        this.descriptorResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.descriptorResolver.setTypeResolver(this.typeResolver);
        this.expressionTypingServices.setAnnotationResolver(this.annotationResolver);
        this.expressionTypingServices.setCallExpressionResolver(this.callExpressionResolver);
        this.expressionTypingServices.setCallResolver(this.callResolver);
        this.expressionTypingServices.setDescriptorResolver(this.descriptorResolver);
        this.expressionTypingServices.setPlatformToKotlinClassMap(this.platformToKotlinClassMap);
        this.expressionTypingServices.setProject(project);
        this.expressionTypingServices.setTypeResolver(this.typeResolver);
        this.typeResolver.setAnnotationResolver(this.annotationResolver);
        this.typeResolver.setModuleDescriptor(moduleDescriptor);
        this.typeResolver.setQualifiedExpressionResolver(this.qualifiedExpressionResolver);
        this.annotationResolver.setCallResolver(this.callResolver);
        this.annotationResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.jetImportsFactory.setProject(project);
        this.callExpressionResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.callResolver.setArgumentTypeResolver(this.argumentTypeResolver);
        this.callResolver.setCandidateResolver(this.candidateResolver);
        this.callResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.callResolver.setExtension(this.compositeExtension);
        this.callResolver.setTypeResolver(this.typeResolver);
        this.argumentTypeResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.argumentTypeResolver.setTypeResolver(this.typeResolver);
        this.candidateResolver.setArgumentTypeResolver(this.argumentTypeResolver);
    }

    @PreDestroy
    public void destroy() {
    }

    public DescriptorResolver getDescriptorResolver() {
        return this.descriptorResolver;
    }

    public ExpressionTypingServices getExpressionTypingServices() {
        return this.expressionTypingServices;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public ScopeProvider getScopeProvider() {
        return this.scopeProvider;
    }

    public AnnotationResolver getAnnotationResolver() {
        return this.annotationResolver;
    }

    public QualifiedExpressionResolver getQualifiedExpressionResolver() {
        return this.qualifiedExpressionResolver;
    }

    public JetImportsFactory getJetImportsFactory() {
        return this.jetImportsFactory;
    }
}

