/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization.descriptors;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;

public interface AnnotationDeserializer {
    public static final AnnotationDeserializer UNSUPPORTED = new AnnotationDeserializer(){

        @Override
        @NotNull
        public List<AnnotationDescriptor> loadClassAnnotations(@NotNull ClassDescriptor descriptor, @NotNull ProtoBuf.Class classProto) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/AnnotationDeserializer$1", "loadClassAnnotations"));
            }
            if (classProto == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/descriptors/serialization/descriptors/AnnotationDeserializer$1", "loadClassAnnotations"));
            }
            List<AnnotationDescriptor> list = this.notSupported();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/AnnotationDeserializer$1", "loadClassAnnotations"));
            }
            return list;
        }

        @Override
        @NotNull
        public List<AnnotationDescriptor> loadCallableAnnotations(@NotNull ClassOrNamespaceDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull AnnotatedCallableKind kind) {
            if (container == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/AnnotationDeserializer$1", "loadCallableAnnotations"));
            }
            if (proto == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/descriptors/serialization/descriptors/AnnotationDeserializer$1", "loadCallableAnnotations"));
            }
            if (nameResolver == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/descriptors/serialization/descriptors/AnnotationDeserializer$1", "loadCallableAnnotations"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/descriptors/serialization/descriptors/AnnotationDeserializer$1", "loadCallableAnnotations"));
            }
            List<AnnotationDescriptor> list = this.notSupported();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/AnnotationDeserializer$1", "loadCallableAnnotations"));
            }
            return list;
        }

        @Override
        @NotNull
        public List<AnnotationDescriptor> loadValueParameterAnnotations(@NotNull ProtoBuf.Callable.ValueParameter parameterProto) {
            if (parameterProto == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/AnnotationDeserializer$1", "loadValueParameterAnnotations"));
            }
            List<AnnotationDescriptor> list = this.notSupported();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/AnnotationDeserializer$1", "loadValueParameterAnnotations"));
            }
            return list;
        }

        @NotNull
        private List<AnnotationDescriptor> notSupported() {
            throw new UnsupportedOperationException("Annotations are not supported");
        }
    };

    @NotNull
    public List<AnnotationDescriptor> loadClassAnnotations(@NotNull ClassDescriptor var1, @NotNull ProtoBuf.Class var2);

    @NotNull
    public List<AnnotationDescriptor> loadCallableAnnotations(@NotNull ClassOrNamespaceDescriptor var1, @NotNull ProtoBuf.Callable var2, @NotNull NameResolver var3, @NotNull AnnotatedCallableKind var4);

    @NotNull
    public List<AnnotationDescriptor> loadValueParameterAnnotations(@NotNull ProtoBuf.Callable.ValueParameter var1);

    public static enum AnnotatedCallableKind {
        FUNCTION,
        PROPERTY,
        PROPERTY_GETTER,
        PROPERTY_SETTER;

    }
}

