/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassData;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.DescriptorFinder;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotationDeserializer;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNullable;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;

public abstract class AbstractDescriptorFinder
implements DescriptorFinder {
    private final MemoizedFunctionToNullable<ClassId, ClassDescriptor> findClass;
    private final AnnotationDeserializer annotationDeserializer;

    public AbstractDescriptorFinder(final @NotNull StorageManager storageManager, @NotNull AnnotationDeserializer annotationDeserializer) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/AbstractDescriptorFinder", "<init>"));
        }
        if (annotationDeserializer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/descriptors/serialization/AbstractDescriptorFinder", "<init>"));
        }
        this.annotationDeserializer = annotationDeserializer;
        this.findClass = storageManager.createMemoizedFunctionWithNullableValues(new Function<ClassId, ClassDescriptor>(){

            @Override
            public ClassDescriptor fun(ClassId classId) {
                ClassData classData = AbstractDescriptorFinder.this.getClassData(classId);
                if (classData == null) {
                    return null;
                }
                AbstractDescriptorFinder _this = AbstractDescriptorFinder.this;
                DeserializedClassDescriptor classDescriptor = new DeserializedClassDescriptor(storageManager, _this.annotationDeserializer, _this, classData);
                AbstractDescriptorFinder.this.classDescriptorCreated(classDescriptor);
                return classDescriptor;
            }
        }, StorageManager.ReferenceKind.STRONG);
    }

    @Override
    @Nullable
    public ClassDescriptor findClass(@NotNull ClassId classId) {
        if (classId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/AbstractDescriptorFinder", "findClass"));
        }
        return this.findClass.fun(classId);
    }

    @Nullable
    protected abstract ClassData getClassData(@NotNull ClassId var1);

    protected void classDescriptorCreated(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/AbstractDescriptorFinder", "classDescriptorCreated"));
        }
    }
}

