/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.config;

import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.config.CompilerConfigurationKey;

public class CompilerConfiguration {
    private final Map<Key, Object> map = new HashMap<Key, Object>();
    private boolean readOnly = false;

    @Nullable
    public <T> T get(@NotNull CompilerConfigurationKey<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/config/CompilerConfiguration", "get"));
        }
        Object data = this.map.get(key.ideaKey);
        return (T)(data == null ? null : CompilerConfiguration.unmodifiable(data));
    }

    @NotNull
    public <T> T get(@NotNull CompilerConfigurationKey<T> key, @NotNull T defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/config/CompilerConfiguration", "get"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/config/CompilerConfiguration", "get"));
        }
        Object data = this.map.get(key.ideaKey);
        Object object = data == null ? defaultValue : CompilerConfiguration.unmodifiable(data);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/config/CompilerConfiguration", "get"));
        }
        return object;
    }

    @NotNull
    public <T> List<T> getList(@NotNull CompilerConfigurationKey<List<T>> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/config/CompilerConfiguration", "getList"));
        }
        List data = (List)this.map.get(key.ideaKey);
        if (data == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/config/CompilerConfiguration", "getList"));
            }
            return list;
        }
        List list = Collections.unmodifiableList(data);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/config/CompilerConfiguration", "getList"));
        }
        return list;
    }

    public <T> void put(@NotNull CompilerConfigurationKey<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/config/CompilerConfiguration", "put"));
        }
        this.checkReadOnly();
        this.map.put(key.ideaKey, value);
    }

    public <T> void add(@NotNull CompilerConfigurationKey<List<T>> key, @NotNull T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/config/CompilerConfiguration", "add"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/config/CompilerConfiguration", "add"));
        }
        this.checkReadOnly();
        Key ideaKey = key.ideaKey;
        if (this.map.get(ideaKey) == null) {
            this.map.put(ideaKey, new ArrayList());
        }
        List list = (List)this.map.get(ideaKey);
        list.add(value);
    }

    public <T> void addAll(@NotNull CompilerConfigurationKey<List<T>> key, @NotNull Collection<T> values) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/config/CompilerConfiguration", "addAll"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/config/CompilerConfiguration", "addAll"));
        }
        this.checkReadOnly();
        CompilerConfiguration.checkForNullElements(values);
        Key ideaKey = key.ideaKey;
        if (this.map.get(ideaKey) == null) {
            this.map.put(ideaKey, new ArrayList());
        }
        List list = (List)this.map.get(ideaKey);
        list.addAll(values);
    }

    public CompilerConfiguration copy() {
        CompilerConfiguration copy = new CompilerConfiguration();
        copy.map.putAll(this.map);
        return copy;
    }

    private void checkReadOnly() {
        if (this.readOnly) {
            throw new IllegalStateException("CompilerConfiguration is read-only");
        }
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly != this.readOnly) {
            this.checkReadOnly();
            this.readOnly = readOnly;
        }
    }

    @NotNull
    private static <T> T unmodifiable(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/config/CompilerConfiguration", "unmodifiable"));
        }
        if (object instanceof List) {
            List list = Collections.unmodifiableList((List)object);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/config/CompilerConfiguration", "unmodifiable"));
            }
            return (T)list;
        }
        if (object instanceof Map) {
            Map map = Collections.unmodifiableMap((Map)object);
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/config/CompilerConfiguration", "unmodifiable"));
            }
            return (T)map;
        }
        if (object instanceof Collection) {
            Collection collection = Collections.unmodifiableCollection((Collection)object);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/config/CompilerConfiguration", "unmodifiable"));
            }
            return (T)collection;
        }
        T t = object;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/config/CompilerConfiguration", "unmodifiable"));
        }
        return t;
    }

    private static <T> void checkForNullElements(Collection<T> values) {
        int index = 0;
        for (T value : values) {
            if (value == null) {
                throw new IllegalArgumentException("Element " + index + " is null, while null values in compiler configuration are not allowed");
            }
            ++index;
        }
    }
}

