/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.repl;

import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.testFramework.LightVirtualFile;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageCollectorToString;
import org.jetbrains.jet.cli.jvm.JVMConfigurationKeys;
import org.jetbrains.jet.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.jet.cli.jvm.repl.EarlierLine;
import org.jetbrains.jet.cli.jvm.repl.ReplClassLoader;
import org.jetbrains.jet.codegen.ClassBuilderFactories;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.config.CompilerConfiguration;
import org.jetbrains.jet.di.InjectorForTopDownAnalyzerForJvm;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceLikeBuilderDummy;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.ScriptHeaderResolver;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.java.AnalyzerFacadeForJVM;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.plugin.JetLanguage;
import org.jetbrains.jet.utils.ExceptionUtils;

public class ReplInterpreter {
    private int lineNumber;
    @Nullable
    private JetScope lastLineScope;
    private List<EarlierLine> earlierLines;
    private List<String> previousIncompleteLines;
    private final ReplClassLoader classLoader;
    @NotNull
    private final InjectorForTopDownAnalyzerForJvm injector;
    @NotNull
    private final JetCoreEnvironment jetCoreEnvironment;
    @NotNull
    private final BindingTraceContext trace;
    @NotNull
    private final ModuleDescriptorImpl module;

    public ReplInterpreter(@NotNull Disposable disposable, @NotNull CompilerConfiguration configuration) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "<init>"));
        }
        this.lineNumber = 0;
        this.earlierLines = Lists.newArrayList();
        this.previousIncompleteLines = Lists.newArrayList();
        this.jetCoreEnvironment = new JetCoreEnvironment(disposable, configuration);
        Project project = this.jetCoreEnvironment.getProject();
        this.trace = new BindingTraceContext();
        this.module = AnalyzerFacadeForJVM.createJavaModule("<repl>");
        TopDownAnalysisParameters topDownAnalysisParameters = new TopDownAnalysisParameters(Predicates.<PsiFile>alwaysTrue(), false, true, Collections.<AnalyzerScriptParameter>emptyList());
        this.injector = new InjectorForTopDownAnalyzerForJvm(project, topDownAnalysisParameters, this.trace, this.module);
        this.module.setModuleConfiguration(this.injector.getJavaBridgeConfiguration());
        ArrayList<URL> classpath = Lists.newArrayList();
        for (File file : configuration.getList(JVMConfigurationKeys.CLASSPATH_KEY)) {
            try {
                classpath.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw ExceptionUtils.rethrow(e);
            }
        }
        this.classLoader = new ReplClassLoader(new URLClassLoader(classpath.toArray(new URL[0])));
    }

    @NotNull
    public LineResult eval(@NotNull String line) {
        Object scriptInstance;
        Class<?> scriptClass;
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "eval"));
        }
        ++this.lineNumber;
        JvmClassName scriptClassName = JvmClassName.byInternalName("Line" + this.lineNumber);
        StringBuilder fullText = new StringBuilder();
        for (String prevLine : this.previousIncompleteLines) {
            fullText.append(prevLine + "\n");
        }
        fullText.append(line);
        LightVirtualFile virtualFile = new LightVirtualFile("line" + this.lineNumber + ".ktscript", JetLanguage.INSTANCE, (CharSequence)fullText.toString());
        virtualFile.setCharset(CharsetToolkit.UTF8_CHARSET);
        JetFile psiFile = (JetFile)((PsiFileFactoryImpl)PsiFileFactory.getInstance(this.jetCoreEnvironment.getProject())).trySetupPsiForFile(virtualFile, JetLanguage.INSTANCE, true, false);
        MessageCollectorToString errorCollector = new MessageCollectorToString();
        AnalyzerWithCompilerReport.SyntaxErrorReport syntaxErrorReport = AnalyzerWithCompilerReport.reportSyntaxErrors(psiFile, errorCollector);
        if (syntaxErrorReport.isOnlyErrorAtEof()) {
            this.previousIncompleteLines.add(line);
            LineResult lineResult = LineResult.incomplete();
            if (lineResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "eval"));
            }
            return lineResult;
        }
        this.previousIncompleteLines.clear();
        if (syntaxErrorReport.isHasErrors()) {
            LineResult lineResult = LineResult.error(errorCollector.getString());
            if (lineResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "eval"));
            }
            return lineResult;
        }
        this.injector.getTopDownAnalyzer().prepareForTheNextReplLine();
        this.trace.clearDiagnostics();
        psiFile.getScript().putUserData(ScriptHeaderResolver.PRIORITY_KEY, this.lineNumber);
        ScriptDescriptor scriptDescriptor = this.doAnalyze(psiFile, errorCollector);
        if (scriptDescriptor == null) {
            LineResult lineResult = LineResult.error(errorCollector.getString());
            if (lineResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "eval"));
            }
            return lineResult;
        }
        ArrayList<Pair<ScriptDescriptor, JvmClassName>> earierScripts = Lists.newArrayList();
        for (EarlierLine earlierLine : this.earlierLines) {
            earierScripts.add(Pair.create(earlierLine.getScriptDescriptor(), earlierLine.getClassName()));
        }
        BindingContext bindingContext = AnalyzeExhaust.success(this.trace.getBindingContext(), this.module).getBindingContext();
        GenerationState generationState = new GenerationState(psiFile.getProject(), ClassBuilderFactories.binaries(false), bindingContext, Collections.singletonList(psiFile));
        generationState.getScriptCodegen().compileScript(psiFile.getScript(), scriptClassName, earierScripts, CompilationErrorHandler.THROW_EXCEPTION);
        for (String file : generationState.getFactory().files()) {
            this.classLoader.addClass(JvmClassName.byInternalName(file.replaceFirst("\\.class$", "")), generationState.getFactory().asBytes(file));
        }
        try {
            scriptClass = this.classLoader.loadClass(scriptClassName.getFqName().asString());
            Class[] constructorParams = new Class[this.earlierLines.size()];
            Object[] constructorArgs = new Object[this.earlierLines.size()];
            for (int i = 0; i < this.earlierLines.size(); ++i) {
                constructorParams[i] = this.earlierLines.get(i).getScriptClass();
                constructorArgs[i] = this.earlierLines.get(i).getScriptInstance();
            }
            Constructor<?> scriptInstanceConstructor = scriptClass.getConstructor(constructorParams);
            try {
                scriptInstance = scriptInstanceConstructor.newInstance(constructorArgs);
            }
            catch (Throwable e) {
                LineResult lineResult = LineResult.error(Throwables.getStackTraceAsString(e));
                if (lineResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "eval"));
                }
                return lineResult;
            }
        }
        catch (Throwable e) {
            PrintWriter writer = new PrintWriter(System.err);
            this.classLoader.dumpClasses(writer);
            writer.flush();
            throw ExceptionUtils.rethrow(e);
        }
        Field rvField = scriptClass.getDeclaredField("rv");
        rvField.setAccessible(true);
        Object rv = rvField.get(scriptInstance);
        this.earlierLines.add(new EarlierLine(line, scriptDescriptor, scriptClass, scriptInstance, scriptClassName));
        LineResult lineResult = LineResult.successful(rv, ((Object)scriptDescriptor.getReturnType()).equals(KotlinBuiltIns.getInstance().getUnitType()));
        if (lineResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "eval"));
        }
        return lineResult;
    }

    @Nullable
    private ScriptDescriptor doAnalyze(@NotNull JetFile psiFile, @NotNull MessageCollector messageCollector) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "doAnalyze"));
        }
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "doAnalyze"));
        }
        WritableScopeImpl scope = new WritableScopeImpl(JetScope.EMPTY, this.module, new TraceBasedRedeclarationHandler(this.trace), "Root scope in analyzeNamespace");
        scope.changeLockLevel(WritableScope.LockLevel.BOTH);
        NamespaceDescriptorImpl rootNs = this.injector.getNamespaceFactory().createNamespaceDescriptorPathIfNeeded(FqName.ROOT);
        this.injector.getNamespaceFactory().createNamespaceDescriptorPathIfNeeded(KotlinBuiltIns.getInstance().getBuiltInsPackageFqName());
        scope.importScope(rootNs.getMemberScope());
        if (this.lastLineScope != null) {
            scope.importScope(this.lastLineScope);
        }
        scope.changeLockLevel(WritableScope.LockLevel.READING);
        this.injector.getTopDownAnalyzer().doProcess(scope, new NamespaceLikeBuilderDummy(), Collections.singletonList(psiFile));
        boolean hasErrors = AnalyzerWithCompilerReport.reportDiagnostics(this.trace.getBindingContext(), messageCollector);
        if (hasErrors) {
            return null;
        }
        ScriptDescriptor scriptDescriptor = this.injector.getTopDownAnalysisContext().getScripts().get(psiFile.getScript());
        this.lastLineScope = this.trace.get(BindingContext.SCRIPT_SCOPE, scriptDescriptor);
        if (this.lastLineScope == null) {
            throw new IllegalStateException("last line scope is not initialized");
        }
        return scriptDescriptor;
    }

    public void dumpClasses(@NotNull PrintWriter out) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "dumpClasses"));
        }
        this.classLoader.dumpClasses(out);
    }

    public static class LineResult {
        private final Object value;
        private final boolean unit;
        private final String errorText;
        @NotNull
        private final LineResultType type;

        private LineResult(Object value, boolean unit, String errorText, @NotNull LineResultType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter$LineResult", "<init>"));
            }
            this.value = value;
            this.unit = unit;
            this.errorText = errorText;
            this.type = type;
        }

        @NotNull
        public LineResultType getType() {
            LineResultType lineResultType = this.type;
            if (lineResultType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter$LineResult", "getType"));
            }
            return lineResultType;
        }

        private void checkSuccessful() {
            if (this.getType() != LineResultType.SUCCESS) {
                throw new IllegalStateException("it is error");
            }
        }

        public Object getValue() {
            this.checkSuccessful();
            return this.value;
        }

        public boolean isUnit() {
            this.checkSuccessful();
            return this.unit;
        }

        @NotNull
        public String getErrorText() {
            String string = this.errorText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter$LineResult", "getErrorText"));
            }
            return string;
        }

        public static LineResult successful(Object value, boolean unit) {
            return new LineResult(value, unit, null, LineResultType.SUCCESS);
        }

        public static LineResult error(@NotNull String errorText) {
            if (errorText == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter$LineResult", "error"));
            }
            if (errorText.isEmpty()) {
                errorText = "<unknown error>";
            } else if (!errorText.endsWith("\n")) {
                errorText = errorText + "\n";
            }
            return new LineResult(null, false, errorText, LineResultType.ERROR);
        }

        public static LineResult incomplete() {
            return new LineResult(null, false, null, LineResultType.INCOMPLETE);
        }
    }

    public static enum LineResultType {
        SUCCESS,
        ERROR,
        INCOMPLETE;

    }
}

