/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import org.jetbrains.annotations.Nullable;

public class FunctionalInterfaceParameterizationUtil {
    private static final Logger LOG = Logger.getInstance("#" + FunctionalInterfaceParameterizationUtil.class.getName());

    public static boolean isWildcardParameterized(@Nullable PsiType classType) {
        if (classType == null) {
            return false;
        }
        if (classType instanceof PsiIntersectionType) {
            for (PsiType type : ((PsiIntersectionType)classType).getConjuncts()) {
                if (FunctionalInterfaceParameterizationUtil.isWildcardParameterized(type)) continue;
                return false;
            }
        }
        if (classType instanceof PsiClassType) {
            for (PsiType type : ((PsiClassType)classType).getParameters()) {
                if (!(type instanceof PsiWildcardType) && !(type instanceof PsiCapturedWildcardType)) continue;
                return true;
            }
            return false;
        }
        LOG.error("Unexpected type: " + classType);
        return false;
    }

    @Nullable
    public static PsiType getFunctionalType(@Nullable PsiType psiClassType, PsiLambdaExpression expr) {
        if (!expr.hasFormalParameterTypes() || expr.getParameterList().getParametersCount() == 0) {
            return psiClassType;
        }
        if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(psiClassType)) {
            return psiClassType;
        }
        PsiParameter[] lambdaParams = expr.getParameterList().getParameters();
        if (psiClassType instanceof PsiIntersectionType) {
            for (PsiType psiType : ((PsiIntersectionType)psiClassType).getConjuncts()) {
                PsiType functionalType = FunctionalInterfaceParameterizationUtil.getFunctionalType(psiType, expr);
                if (functionalType == null) continue;
                return functionalType;
            }
            return null;
        }
        LOG.assertTrue(psiClassType instanceof PsiClassType, "Unexpected type: " + psiClassType);
        PsiType[] parameters = ((PsiClassType)psiClassType).getParameters();
        PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)psiClassType).resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass != null) {
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
            if (interfaceMethod == null) {
                return null;
            }
            InferenceSession session = new InferenceSession(PsiSubstitutor.EMPTY);
            PsiTypeParameter[] typeParameters = psiClass.getTypeParameters();
            if (typeParameters.length != parameters.length) {
                return null;
            }
            for (int i = 0; i < typeParameters.length; ++i) {
                session.addVariable(typeParameters[i], parameters[i]);
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(psiClass.getProject());
            PsiParameter[] targetMethodParams = interfaceMethod.getParameterList().getParameters();
            for (int i = 0; i < targetMethodParams.length; ++i) {
                session.addConstraint(new TypeEqualityConstraint(lambdaParams[i].getType(), targetMethodParams[i].getType()));
            }
            PsiClassType parameterization = elementFactory.createType(psiClass, session.infer());
            if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(parameterization)) {
                return parameterization;
            }
        }
        return null;
    }
}

