/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import com.google.common.collect.Lists;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

public final class TemporariesUtils {
    private TemporariesUtils() {
    }

    @NotNull
    public static List<TemporaryVariable> fromExpressionList(@NotNull List<JsExpression> expressions, @NotNull TranslationContext context) {
        if (expressions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/TemporariesUtils", "fromExpressionList"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/TemporariesUtils", "fromExpressionList"));
        }
        ArrayList<TemporaryVariable> result = Lists.newArrayList();
        for (JsExpression expression : expressions) {
            result.add(context.declareTemporary(expression));
        }
        ArrayList<TemporaryVariable> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TemporariesUtils", "fromExpressionList"));
        }
        return arrayList;
    }

    @NotNull
    public static List<JsExpression> toExpressionList(@NotNull List<TemporaryVariable> temporaries) {
        if (temporaries == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/TemporariesUtils", "toExpressionList"));
        }
        ArrayList<JsExpression> result = Lists.newArrayList();
        for (TemporaryVariable temp : temporaries) {
            result.add(temp.reference());
        }
        ArrayList<JsExpression> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TemporariesUtils", "toExpressionList"));
        }
        return arrayList;
    }

    @NotNull
    public static JsExpression temporariesInitialization(TemporaryVariable ... temporaries) {
        if (temporaries == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/TemporariesUtils", "temporariesInitialization"));
        }
        ArrayList<JsExpression> result = Lists.newArrayList();
        for (TemporaryVariable temporary : temporaries) {
            result.add(temporary.assignmentExpression());
        }
        JsExpression jsExpression = JsAstUtils.newSequence(result);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TemporariesUtils", "temporariesInitialization"));
        }
        return jsExpression;
    }

    @NotNull
    public static List<JsExpression> temporariesInitialization(@NotNull List<TemporaryVariable> temporaries) {
        if (temporaries == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/TemporariesUtils", "temporariesInitialization"));
        }
        ArrayList<JsExpression> result = Lists.newArrayList();
        for (TemporaryVariable temporary : temporaries) {
            result.add(temporary.assignmentExpression());
        }
        ArrayList<JsExpression> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TemporariesUtils", "temporariesInitialization"));
        }
        return arrayList;
    }
}

