/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.initializer;

import com.google.dart.compiler.backend.js.ast.JsStatement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.general.TranslatorVisitor;
import org.jetbrains.k2js.translate.initializer.InitializerUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;

public final class InitializerVisitor
extends TranslatorVisitor<Void> {
    private final List<JsStatement> result;

    public InitializerVisitor(List<JsStatement> result) {
        this.result = result;
    }

    @Override
    public final Void visitProperty(@NotNull JetProperty property, @NotNull TranslationContext context) {
        JsStatement delegate;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/initializer/InitializerVisitor", "visitProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/initializer/InitializerVisitor", "visitProperty"));
        }
        JetExpression initializer = property.getInitializer();
        if (initializer != null) {
            this.result.add(InitializerUtils.generateInitializerForProperty(context, BindingUtils.getPropertyDescriptor(context.bindingContext(), property), Translation.translateAsExpression(initializer, context)));
        }
        if ((delegate = InitializerUtils.generateInitializerForDelegate(context, property)) != null) {
            this.result.add(delegate);
        }
        return null;
    }

    @Override
    public Void visitAnonymousInitializer(@NotNull JetClassInitializer initializer, @NotNull TranslationContext context) {
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/initializer/InitializerVisitor", "visitAnonymousInitializer"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/initializer/InitializerVisitor", "visitAnonymousInitializer"));
        }
        this.result.add(Translation.translateAsStatement(initializer.getBody(), context));
        return null;
    }

    @Override
    public Void visitDeclaration(@NotNull JetDeclaration expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/initializer/InitializerVisitor", "visitDeclaration"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/initializer/InitializerVisitor", "visitDeclaration"));
        }
        return null;
    }

    @Override
    public Void visitObjectDeclaration(@NotNull JetObjectDeclaration declaration, @NotNull TranslationContext context) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/initializer/InitializerVisitor", "visitObjectDeclaration"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/initializer/InitializerVisitor", "visitObjectDeclaration"));
        }
        InitializerUtils.generateObjectInitializer(declaration, this.result, context);
        return null;
    }
}

