/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.util.Box;
import org.jetbrains.jet.utils.RecursionIntolerantLazyValue;
import org.jetbrains.jet.utils.ReenteringLazyValueComputationException;

public class DeferredType
implements JetType {
    private final RecursionIntolerantLazyValue<JetType> lazyValue;

    public static DeferredType create(BindingTrace trace, RecursionIntolerantLazyValue<JetType> lazyValue) {
        DeferredType deferredType = new DeferredType(lazyValue);
        trace.record(BindingContext.DEFERRED_TYPE, new Box<DeferredType>(deferredType));
        return deferredType;
    }

    private DeferredType(RecursionIntolerantLazyValue<JetType> lazyValue) {
        this.lazyValue = lazyValue;
    }

    public boolean isComputed() {
        return this.lazyValue.isComputed();
    }

    @NotNull
    public JetType getActualType() {
        JetType jetType = this.lazyValue.get();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/DeferredType", "getActualType"));
        }
        return jetType;
    }

    @Override
    @NotNull
    public JetScope getMemberScope() {
        JetScope jetScope = this.getActualType().getMemberScope();
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/DeferredType", "getMemberScope"));
        }
        return jetScope;
    }

    @Override
    public boolean isError() {
        return this.getActualType().isError();
    }

    @Override
    @NotNull
    public TypeConstructor getConstructor() {
        TypeConstructor typeConstructor = this.getActualType().getConstructor();
        if (typeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/DeferredType", "getConstructor"));
        }
        return typeConstructor;
    }

    @Override
    @NotNull
    public List<TypeProjection> getArguments() {
        List<TypeProjection> list = this.getActualType().getArguments();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/DeferredType", "getArguments"));
        }
        return list;
    }

    @Override
    public boolean isNullable() {
        return this.getActualType().isNullable();
    }

    @Override
    public List<AnnotationDescriptor> getAnnotations() {
        return this.getActualType().getAnnotations();
    }

    public String toString() {
        try {
            if (this.lazyValue.isComputed()) {
                return this.getActualType().toString();
            }
            return "<Not computed yet>";
        }
        catch (ReenteringLazyValueComputationException e) {
            return "<Failed to compute this type>";
        }
    }

    @Override
    public boolean equals(Object obj) {
        return ((Object)this.getActualType()).equals(obj);
    }

    public int hashCode() {
        return this.getActualType().hashCode();
    }
}

