/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.storage;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNullable;
import org.jetbrains.jet.utils.WrappedValues;

public abstract class MemoizedFunctionToNullableImpl<K, V>
implements MemoizedFunctionToNullable<K, V> {
    private final Map<K, Object> cache;

    public MemoizedFunctionToNullableImpl() {
        this(new HashMap());
    }

    public MemoizedFunctionToNullableImpl(@NotNull Map<K, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/storage/MemoizedFunctionToNullableImpl", "<init>"));
        }
        this.cache = map;
    }

    @Override
    @Nullable
    public V fun(K input) {
        Object value = this.cache.get(input);
        if (value != null) {
            return WrappedValues.unescapeNull(value);
        }
        V typedValue = this.doCompute(input);
        Object oldValue = this.cache.put(input, WrappedValues.escapeNull(typedValue));
        assert (oldValue == null) : "Race condition detected";
        return typedValue;
    }

    @Nullable
    protected abstract V doCompute(K var1);
}

