/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorBase;
import org.jetbrains.jet.lang.psi.JetNamed;
import org.jetbrains.jet.lang.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.util.QualifiedNamesUtil;

public class ResolveSessionUtils {
    public static final Name NO_NAME_FOR_LAZY_RESOLVE = Name.identifier("no_name_in_PSI_for_lazy_resolve_3d19d79d_1ba9_4cd0_b7f5_b46aa3cd5d40");

    private ResolveSessionUtils() {
    }

    @NotNull
    public static Collection<ClassDescriptor> getClassDescriptorsByFqName(@NotNull KotlinCodeAnalyzer analyzer, @NotNull FqName fqName) {
        if (analyzer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "getClassDescriptorsByFqName"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "getClassDescriptorsByFqName"));
        }
        Collection<ClassDescriptor> collection = ResolveSessionUtils.getClassOrObjectDescriptorsByFqName(analyzer, fqName, false);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "getClassDescriptorsByFqName"));
        }
        return collection;
    }

    @NotNull
    public static Collection<ClassDescriptor> getClassOrObjectDescriptorsByFqName(@NotNull KotlinCodeAnalyzer analyzer, @NotNull FqName fqName, boolean includeObjectDeclarations) {
        if (analyzer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "getClassOrObjectDescriptorsByFqName"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "getClassOrObjectDescriptorsByFqName"));
        }
        if (fqName.isRoot()) {
            List<ClassDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "getClassOrObjectDescriptorsByFqName"));
            }
            return list;
        }
        ArrayList<ClassDescriptor> classDescriptors = Lists.newArrayList();
        FqName packageFqName = fqName.parent();
        while (true) {
            NamespaceDescriptor packageDescriptor;
            if ((packageDescriptor = analyzer.getPackageDescriptorByFqName(packageFqName)) != null) {
                FqName classInPackagePath = new FqName(QualifiedNamesUtil.tail(packageFqName, fqName));
                Collection<ClassDescriptor> descriptors = ResolveSessionUtils.getClassOrObjectDescriptorsByFqName(packageDescriptor, classInPackagePath, includeObjectDeclarations);
                classDescriptors.addAll(descriptors);
            }
            if (packageFqName.isRoot()) break;
            packageFqName = packageFqName.parent();
        }
        ArrayList<ClassDescriptor> arrayList = classDescriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "getClassOrObjectDescriptorsByFqName"));
        }
        return arrayList;
    }

    private static Collection<ClassDescriptor> getClassOrObjectDescriptorsByFqName(NamespaceDescriptor packageDescriptor, FqName path, boolean includeObjectDeclarations) {
        if (path.isRoot()) {
            return Collections.emptyList();
        }
        List<JetScope> scopes = Arrays.asList(packageDescriptor.getMemberScope());
        List<Name> names = path.pathSegments();
        if (names.size() > 1) {
            for (Name subName : path.pathSegments().subList(0, names.size() - 1)) {
                ArrayList<JetScope> tempScopes = Lists.newArrayList();
                for (JetScope scope : scopes) {
                    ClassifierDescriptor classifier = scope.getClassifier(subName);
                    if (!(classifier instanceof ClassDescriptorBase)) continue;
                    ClassDescriptorBase classDescriptor = (ClassDescriptorBase)classifier;
                    tempScopes.add(classDescriptor.getUnsubstitutedInnerClassesScope());
                }
                scopes = tempScopes;
            }
        }
        Name shortName = path.shortName();
        ArrayList<ClassDescriptor> resultClassifierDescriptors = Lists.newArrayList();
        for (JetScope scope : scopes) {
            ClassDescriptor objectDescriptor;
            ClassifierDescriptor classifier = scope.getClassifier(shortName);
            if (classifier instanceof ClassDescriptor) {
                resultClassifierDescriptors.add((ClassDescriptor)classifier);
            }
            if (!includeObjectDeclarations || (objectDescriptor = scope.getObjectDescriptor(shortName)) == null) continue;
            resultClassifierDescriptors.add(objectDescriptor);
        }
        return resultClassifierDescriptors;
    }

    @NotNull
    public static Name safeNameForLazyResolve(@NotNull JetNamed named) {
        if (named == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "safeNameForLazyResolve"));
        }
        Name name = named.getNameAsName();
        Name name2 = ResolveSessionUtils.safeNameForLazyResolve(name);
        if (name2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "safeNameForLazyResolve"));
        }
        return name2;
    }

    @NotNull
    public static Name safeNameForLazyResolve(@Nullable Name name) {
        Name name2 = name != null ? name : NO_NAME_FOR_LAZY_RESOLVE;
        if (name2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "safeNameForLazyResolve"));
        }
        return name2;
    }
}

