/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin.header;

import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.AbiVersionUtil;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.kotlin.header.IncompatibleAnnotationHeader;
import org.jetbrains.jet.lang.resolve.kotlin.header.KotlinClassFileHeader;
import org.jetbrains.jet.lang.resolve.kotlin.header.PackageFragmentClassFileHeader;
import org.jetbrains.jet.lang.resolve.kotlin.header.SerializedDataHeader;
import org.jetbrains.jet.lang.resolve.name.Name;

class ReadDataFromAnnotationVisitor
implements KotlinJvmBinaryClass.AnnotationVisitor {
    private static final Logger LOG = Logger.getInstance(ReadDataFromAnnotationVisitor.class);
    private int version = -1;
    @Nullable
    private String[] annotationData = null;
    @Nullable
    private HeaderType foundType = null;

    ReadDataFromAnnotationVisitor() {
    }

    @Nullable
    public KotlinClassFileHeader createHeader(@NotNull KotlinJvmBinaryClass kotlinClass) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor", "createHeader"));
        }
        if (this.foundType == null) {
            return null;
        }
        if (!AbiVersionUtil.isAbiVersionCompatible(this.version)) {
            return new IncompatibleAnnotationHeader(this.version);
        }
        switch (this.foundType) {
            case CLASS: {
                return this.serializedDataHeader(SerializedDataHeader.Kind.CLASS, kotlinClass);
            }
            case PACKAGE: {
                return this.serializedDataHeader(SerializedDataHeader.Kind.PACKAGE, kotlinClass);
            }
            case PACKAGE_FRAGMENT: {
                return new PackageFragmentClassFileHeader(this.version);
            }
        }
        throw new UnsupportedOperationException("Unknown compatible HeaderType: " + (Object)((Object)this.foundType));
    }

    @Nullable
    private SerializedDataHeader serializedDataHeader(@NotNull SerializedDataHeader.Kind kind, @NotNull KotlinJvmBinaryClass kotlinClass) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor", "serializedDataHeader"));
        }
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor", "serializedDataHeader"));
        }
        if (this.annotationData == null) {
            LOG.error("Kotlin annotation " + (Object)((Object)this.foundType) + " is incorrect for class: " + kotlinClass);
            return null;
        }
        return new SerializedDataHeader(this.version, this.annotationData, kind);
    }

    @Override
    @Nullable
    public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull JvmClassName annotationClassName) {
        if (annotationClassName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor", "visitAnnotation"));
        }
        HeaderType newType = HeaderType.byClassName(annotationClassName);
        if (newType == null) {
            return null;
        }
        if (this.foundType != null) {
            LOG.error("Both annotations are present for compiled Kotlin file: " + (Object)((Object)this.foundType) + " and " + (Object)((Object)newType));
            return null;
        }
        this.foundType = newType;
        if (newType == HeaderType.CLASS || newType == HeaderType.PACKAGE) {
            return this.kotlinClassOrPackageVisitor(annotationClassName);
        }
        if (newType == HeaderType.PACKAGE_FRAGMENT) {
            return this.kotlinPackageFragmentVisitor(annotationClassName);
        }
        return null;
    }

    @Override
    public void visitEnd() {
    }

    @NotNull
    private KotlinJvmBinaryClass.AnnotationArgumentVisitor kotlinClassOrPackageVisitor(final @NotNull JvmClassName annotationClassName) {
        if (annotationClassName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor", "kotlinClassOrPackageVisitor"));
        }
        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = new KotlinJvmBinaryClass.AnnotationArgumentVisitor(){

            @Override
            public void visit(@Nullable Name name, @Nullable Object value) {
                ReadDataFromAnnotationVisitor.this.visitIntValueForSupportedAnnotation(name, value, annotationClassName);
            }

            @Override
            public void visitEnum(@NotNull Name name, @NotNull JvmClassName enumClassName, @NotNull Name enumEntryName) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor$1", "visitEnum"));
                }
                if (enumClassName == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor$1", "visitEnum"));
                }
                if (enumEntryName == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor$1", "visitEnum"));
                }
                ReadDataFromAnnotationVisitor.this.unexpectedArgument(name, annotationClassName);
            }

            @Override
            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitArray(@NotNull Name name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor$1", "visitArray"));
                }
                if (name.asString().equals("data")) {
                    return this.stringArrayVisitor();
                }
                if (AbiVersionUtil.isAbiVersionCompatible(ReadDataFromAnnotationVisitor.this.version)) {
                    throw new IllegalStateException("Unexpected array argument " + name + " for annotation " + annotationClassName);
                }
                return null;
            }

            @NotNull
            private KotlinJvmBinaryClass.AnnotationArgumentVisitor stringArrayVisitor() {
                final ArrayList strings = new ArrayList(1);
                KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = new KotlinJvmBinaryClass.AnnotationArgumentVisitor(){

                    @Override
                    public void visit(@Nullable Name name, @Nullable Object value) {
                        if (!(value instanceof String)) {
                            throw new IllegalStateException("Unexpected argument value: " + value);
                        }
                        strings.add((String)value);
                    }

                    @Override
                    public void visitEnum(@NotNull Name name, @NotNull JvmClassName enumClassName, @NotNull Name enumEntryName) {
                        if (name == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor$1$1", "visitEnum"));
                        }
                        if (enumClassName == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor$1$1", "visitEnum"));
                        }
                        if (enumEntryName == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor$1$1", "visitEnum"));
                        }
                        ReadDataFromAnnotationVisitor.this.unexpectedArgument(name, annotationClassName);
                    }

                    @Override
                    @Nullable
                    public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitArray(@NotNull Name name) {
                        if (name == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor$1$1", "visitArray"));
                        }
                        return ReadDataFromAnnotationVisitor.this.unexpectedArgument(name, annotationClassName);
                    }

                    @Override
                    public void visitEnd() {
                        ReadDataFromAnnotationVisitor.access$402(ReadDataFromAnnotationVisitor.this, strings.toArray(new String[strings.size()]));
                    }
                };
                if (annotationArgumentVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor$1", "stringArrayVisitor"));
                }
                return annotationArgumentVisitor;
            }

            @Override
            public void visitEnd() {
            }
        };
        if (annotationArgumentVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor", "kotlinClassOrPackageVisitor"));
        }
        return annotationArgumentVisitor;
    }

    @NotNull
    private KotlinJvmBinaryClass.AnnotationArgumentVisitor kotlinPackageFragmentVisitor(final @NotNull JvmClassName annotationClassName) {
        if (annotationClassName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor", "kotlinPackageFragmentVisitor"));
        }
        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = new KotlinJvmBinaryClass.AnnotationArgumentVisitor(){

            @Override
            public void visit(@Nullable Name name, @Nullable Object value) {
                ReadDataFromAnnotationVisitor.this.visitIntValueForSupportedAnnotation(name, value, annotationClassName);
            }

            @Override
            public void visitEnum(@NotNull Name name, @NotNull JvmClassName enumClassName, @NotNull Name enumEntryName) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor$2", "visitEnum"));
                }
                if (enumClassName == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor$2", "visitEnum"));
                }
                if (enumEntryName == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor$2", "visitEnum"));
                }
                ReadDataFromAnnotationVisitor.this.unexpectedArgument(name, annotationClassName);
            }

            @Override
            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitArray(@NotNull Name name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor$2", "visitArray"));
                }
                return ReadDataFromAnnotationVisitor.this.unexpectedArgument(name, annotationClassName);
            }

            @Override
            public void visitEnd() {
            }
        };
        if (annotationArgumentVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor", "kotlinPackageFragmentVisitor"));
        }
        return annotationArgumentVisitor;
    }

    private void visitIntValueForSupportedAnnotation(@Nullable Name name, @Nullable Object value, @NotNull JvmClassName className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor", "visitIntValueForSupportedAnnotation"));
        }
        if (name != null && name.asString().equals("abiVersion")) {
            this.version = value == null ? -1 : (Integer)value;
        } else {
            this.unexpectedArgument(name, className);
        }
    }

    @Nullable
    private KotlinJvmBinaryClass.AnnotationArgumentVisitor unexpectedArgument(@Nullable Name name, @NotNull JvmClassName annotationClassName) {
        if (annotationClassName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor", "unexpectedArgument"));
        }
        if (AbiVersionUtil.isAbiVersionCompatible(this.version)) {
            throw new IllegalStateException("Unexpected argument " + name + " for annotation " + annotationClassName);
        }
        return null;
    }

    static /* synthetic */ String[] access$402(ReadDataFromAnnotationVisitor x0, String[] x1) {
        x0.annotationData = x1;
        return x1;
    }

    private static enum HeaderType {
        CLASS(JvmAnnotationNames.KOTLIN_CLASS),
        PACKAGE(JvmAnnotationNames.KOTLIN_PACKAGE),
        PACKAGE_FRAGMENT(JvmAnnotationNames.KOTLIN_PACKAGE_FRAGMENT),
        OLD_CLASS(JvmAnnotationNames.OLD_JET_CLASS_ANNOTATION),
        OLD_PACKAGE(JvmAnnotationNames.OLD_JET_PACKAGE_CLASS_ANNOTATION);

        @NotNull
        private final JvmClassName annotation;

        private HeaderType(@NotNull JvmClassName annotation) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor$HeaderType", "<init>"));
            }
            this.annotation = annotation;
        }

        @Nullable
        private static HeaderType byClassName(@NotNull JvmClassName className) {
            if (className == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadDataFromAnnotationVisitor$HeaderType", "byClassName"));
            }
            for (HeaderType headerType : HeaderType.values()) {
                if (!className.equals(headerType.annotation)) continue;
                return headerType;
            }
            return null;
        }
    }
}

